/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.ExtendedUnbakedModel;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;

public class ChestDynamicModel
implements ExtendedUnbakedModel {
    private static final String BLOCK_BREAK_FOLDER = "block/break/";
    private static final Map<String, ResourceLocation> WOOD_BREAK_TEXTURES = new HashMap<String, ResourceLocation>();
    public static final ResourceLocation TINTABLE_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/tintable_chest");

    public BakedModel bake(TextureSlots textureSlots, ModelBaker modelBaker, ModelState modelState, boolean b, boolean b1, ItemTransforms itemTransforms, ContextMap contextMap) {
        return new ChestBakedModel();
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }

    static {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.keySet().forEach(woodType -> WOOD_BREAK_TEXTURES.put(woodType.name(), SophisticatedStorage.getRL(BLOCK_BREAK_FOLDER + woodType.name() + "_chest")));
    }

    private static class ChestBakedModel
    implements BakedModel {
        private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();

        private ChestBakedModel() {
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return Collections.emptyList();
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            BakedModel model = Minecraft.getInstance().getModelManager().getModel(BlockModelShaper.stateToModelLocation((BlockState)Blocks.OAK_PLANKS.defaultBlockState()));
            return model.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        @Nonnull
        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).map(be -> {
                ModelData.Builder builder = ModelData.builder();
                builder.with(HAS_MAIN_COLOR, (Object)(be.getStorageWrapper().getMainColor() != -1 ? 1 : 0));
                be.getWoodType().ifPresent(n -> builder.with(WOOD_NAME, (Object)n.name()));
                return builder.build();
            }).orElse(ModelData.EMPTY);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            ResourceLocation texture = TINTABLE_BREAK_TEXTURE;
            if (Boolean.FALSE.equals(data.get(HAS_MAIN_COLOR)) && data.has(WOOD_NAME) && WOOD_BREAK_TEXTURES.containsKey(data.get(WOOD_NAME))) {
                texture = WOOD_BREAK_TEXTURES.get(data.get(WOOD_NAME));
            }
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<ChestDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public ChestDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return new ChestDynamicModel();
        }
    }
}

