/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class ChestRenderer
extends StorageRenderer<ChestBlockEntity> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new Vec3(-0.0625, 0.0, -0.0075));
    private final Map<ChestType, ChestSubRenderer> chestSubRenderers;

    public ChestRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(ClientEventHandler.CHEST_LAYER);
        ChestSubRenderer singleChestRenderer = new ChestSubRenderer(ChestType.SINGLE, modelpart.getChild(LID), modelpart.getChild(BOTTOM), modelpart.getChild(LOCK));
        modelpart = context.bakeLayer(ClientEventHandler.CHEST_RIGHT_LAYER);
        ChestSubRenderer doubleChestRightRenderer = new ChestSubRenderer(ChestType.RIGHT, modelpart.getChild(LID), modelpart.getChild(BOTTOM), modelpart.getChild(LOCK));
        modelpart = context.bakeLayer(ClientEventHandler.CHEST_LEFT_LAYER);
        ChestSubRenderer doubleChestLeftRenderer = new ChestSubRenderer(ChestType.LEFT, modelpart.getChild(LID), modelpart.getChild(BOTTOM), modelpart.getChild(LOCK));
        this.chestSubRenderers = Map.of(ChestType.SINGLE, singleChestRenderer, ChestType.RIGHT, doubleChestRightRenderer, ChestType.LEFT, doubleChestLeftRenderer);
    }

    public static LayerDefinition createSingleBodyLayer(boolean addLock) {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        if (addLock) {
            partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        }
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(ChestBlockEntity chestEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockstate = chestEntity.getBlockState();
        Optional<WoodType> woodType = chestEntity.getWoodType();
        ChestType chestType = (ChestType)blockstate.getValue(ChestBlock.TYPE);
        ChestSubRenderer subRenderer = this.chestSubRenderers.get(chestType);
        if (!subRenderer.setChestMaterialsFrom(woodType.orElse(WoodType.ACACIA), blockstate.getBlock())) {
            return;
        }
        poseStack.pushPose();
        Direction facing = (Direction)blockstate.getValue(ChestBlock.FACING);
        float f = facing.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(-f));
        poseStack.translate(-0.5, -0.5, -0.5);
        float lidAngle = chestEntity.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        StorageWrapper storageWrapper = chestEntity.getMainStorageWrapper();
        boolean hasMainColor = storageWrapper.hasMainColor();
        boolean hasAccentColor = storageWrapper.hasAccentColor();
        if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.BASE);
        }
        if (hasMainColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getMainColor(), StorageTextureManager.ChestMaterial.TINTABLE_MAIN);
        }
        if (hasAccentColor) {
            subRenderer.renderBottomAndLidWithTint(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, storageWrapper.getAccentColor(), StorageTextureManager.ChestMaterial.TINTABLE_ACCENT);
        }
        if (chestEntity.shouldShowTier()) {
            subRenderer.renderTier(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            subRenderer.renderHiddenTier(poseStack, bufferSource, packedLight, packedOverlay);
        }
        Optional displayItem = storageWrapper.getRenderInfo().getItemDisplayRenderInfo().getDisplayItem();
        if (displayItem.map(di -> di.getDisplaySide() != DisplaySide.FRONT).orElse(true).booleanValue()) {
            subRenderer.renderChestLock(poseStack, bufferSource, lidAngle, packedLight, packedOverlay);
        }
        if (chestEntity.isPacked()) {
            poseStack.pushPose();
            poseStack.translate(-0.005, -0.005, -0.005);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            subRenderer.renderBottomAndLid(poseStack, bufferSource, lidAngle, packedLight, packedOverlay, StorageTextureManager.ChestMaterial.PACKED);
            poseStack.popPose();
        } else {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.4375);
            if (chestEntity.isMainChest() && (chestEntity.shouldShowUpgrades() || this.holdsItemThatShowsUpgrades())) {
                poseStack.pushPose();
                if (chestType == ChestType.LEFT) {
                    poseStack.translate(1.0f, 0.0f, 0.0f);
                }
                if (chestEntity.showUpgradesOnTop) {
                    if (lidAngle > 0.0f) {
                        poseStack.translate(0.0, 0.5625, 0.875);
                        poseStack.mulPose(Axis.XP.rotationDegrees(lidAngle * 90.0f));
                        poseStack.translate(0.0, -0.5625, -0.875);
                    }
                    poseStack.translate(0.5, 0.5, 0.4375);
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.translate(-0.5, -0.4375, -0.375);
                }
                this.displayItemRenderer.renderUpgradeItems(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, this.holdsItemThatShowsUpgrades(), this.shouldShowDisabledUpgradesDisplay(chestEntity));
                poseStack.popPose();
            }
            if (chestEntity.isMainChest()) {
                this.renderLocked(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, chestType, lidAngle);
            }
            poseStack.popPose();
            if (chestEntity.isMainChest()) {
                displayItem.ifPresent(di -> this.renderDisplayItem((RenderInfo.DisplayItem)di, poseStack, bufferSource, packedLight, packedOverlay, chestType));
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderDisplayItem(RenderInfo.DisplayItem displayItem, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ChestType chestType) {
        DisplaySide displaySide = displayItem.getDisplaySide();
        if (displaySide == DisplaySide.LEFT) {
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            if (chestType == ChestType.LEFT) {
                poseStack.translate(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.RIGHT) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            if (chestType == ChestType.RIGHT) {
                poseStack.translate(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.FRONT) {
            if (chestType == ChestType.RIGHT) {
                poseStack.translate(-0.5, 0.0, 0.0);
            } else if (chestType == ChestType.LEFT) {
                poseStack.translate(0.5, 0.0, 0.0);
            }
        }
        poseStack.translate(-0.5, -0.5, -0.4375);
        this.displayItemRenderer.renderDisplayItem(poseStack, bufferSource, packedLight, packedOverlay, displayItem);
    }

    private void renderLocked(ChestBlockEntity chestEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, ChestType chestType, float lidAngle) {
        poseStack.pushPose();
        if (lidAngle > 0.0f) {
            poseStack.translate(0.0, 0.5625, 0.875);
            poseStack.mulPose(Axis.XP.rotationDegrees(lidAngle * 90.0f));
            poseStack.translate(0.0, -0.5625, -0.875);
        }
        if (chestType == ChestType.LEFT) {
            poseStack.translate(0.5, 0.0, 0.0);
        } else if (chestType == ChestType.RIGHT) {
            poseStack.translate(-0.5, 0.0, 0.0);
        }
        LockRenderer.renderLock(chestEntity, poseStack, bufferSource, packedLight, packedOverlay, 0.8125f, this::holdsToolInToggleLockOrLockDisplay);
        poseStack.popPose();
    }

    private static class ChestSubRenderer {
        private final ChestType chestType;
        private final ModelPart lidPart;
        private final ModelPart bottomPart;
        private final ModelPart lockPart;
        private Map<StorageTextureManager.ChestMaterial, Material> chestMaterials;
        private Material tierMaterial;

        public ChestSubRenderer(ChestType chestType, ModelPart lidPart, ModelPart bottomPart, ModelPart lockPart) {
            this.chestType = chestType;
            this.lidPart = lidPart;
            this.bottomPart = bottomPart;
            this.lockPart = lockPart;
        }

        private boolean setChestMaterialsFrom(WoodType woodType, Block block) {
            this.chestMaterials = StorageTextureManager.INSTANCE.getWoodChestMaterials(this.chestType, woodType);
            if (this.chestMaterials == null) {
                return false;
            }
            this.tierMaterial = this.getTierMaterial(block);
            return true;
        }

        private void renderHiddenTier(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
            TextureAtlasSprite sprite = this.tierMaterial.sprite();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                MultiBufferSource.BufferSource multiBufferSource = (MultiBufferSource.BufferSource)bufferSource;
                multiBufferSource.endBatch();
            }
            VertexConsumer translucentConsumer = sprite.wrap(bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation())));
            poseStack.pushPose();
            poseStack.translate(-0.005, -0.005, -0.005);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            int color = Integer.MAX_VALUE;
            this.lidPart.render(poseStack, translucentConsumer, packedLight, packedOverlay, color);
            this.bottomPart.render(poseStack, translucentConsumer, packedLight, packedOverlay, color);
            poseStack.popPose();
        }

        private void renderBottomAndLid(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay, StorageTextureManager.ChestMaterial chestMaterial) {
            VertexConsumer consumer = this.chestMaterials.get((Object)chestMaterial).buffer(bufferSource, RenderType::entityCutout);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, consumer);
        }

        private void renderBottomAndLid(PoseStack poseStack, float lidAngle, int packedLight, int packedOverlay, VertexConsumer consumer) {
            this.lidPart.xRot = -(lidAngle * 1.5707964f);
            if (lidAngle > 0.0f) {
                poseStack.pushPose();
                poseStack.translate(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.scale(1.001f, 1.001f, 1.001f);
            }
            this.lidPart.render(poseStack, consumer, packedLight, packedOverlay);
            if (lidAngle > 0.0f) {
                poseStack.popPose();
            }
            this.bottomPart.render(poseStack, consumer, packedLight, packedOverlay);
        }

        private void renderBottomAndLidWithTint(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay, int tint, StorageTextureManager.ChestMaterial chestMaterial) {
            VertexConsumer consumer = this.chestMaterials.get((Object)chestMaterial).buffer(bufferSource, RenderType::entityCutout);
            this.lidPart.xRot = -(lidAngle * 1.5707964f);
            int color = 0xFF000000 | tint;
            if (lidAngle > 0.0f) {
                poseStack.pushPose();
                poseStack.translate(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.scale(1.001f, 1.001f, 1.001f);
            }
            this.lidPart.render(poseStack, consumer, packedLight, packedOverlay, color);
            if (lidAngle > 0.0f) {
                poseStack.popPose();
            }
            this.bottomPart.render(poseStack, consumer, packedLight, packedOverlay, color);
        }

        private void renderChestLock(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            VertexConsumer consumer = this.tierMaterial.buffer(bufferSource, RenderType::entityCutout);
            this.lockPart.xRot = -(lidAngle * 1.5707964f);
            this.lockPart.render(poseStack, consumer, packedLight, packedOverlay);
        }

        private Material getTierMaterial(Block block) {
            if (block == ModBlocks.COPPER_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.COPPER_TIER);
            }
            if (block == ModBlocks.IRON_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
            }
            if (block == ModBlocks.GOLD_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
            }
            if (block == ModBlocks.DIAMOND_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
            }
            if (block == ModBlocks.NETHERITE_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
            }
            return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
        }

        public void renderTier(PoseStack poseStack, MultiBufferSource bufferSource, float lidAngle, int packedLight, int packedOverlay) {
            VertexConsumer vertexconsumer = this.tierMaterial.buffer(bufferSource, RenderType::entityCutout);
            this.renderBottomAndLid(poseStack, lidAngle, packedLight, packedOverlay, vertexconsumer);
        }
    }
}

