/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBakedModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelDynamicModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import org.joml.Vector3f;

public class LimitedBarrelDynamicModel
extends BarrelDynamicModelBase {
    public LimitedBarrelDynamicModel(@Nullable ResourceLocation parentLocation, Map<String, Map<BarrelModelPart, BarrelDynamicModelBase.BarrelModelPartDefinition>> woodOverrides, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels, Map<String, Map<BarrelModelPart, BarrelDynamicModelBase.BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions) {
        super(parentLocation, woodOverrides, dynamicPartModels, woodPartitionedModelPartDefinitions);
    }

    @Override
    protected BarrelBakedModelBase instantiateBakedModel(ModelBaker baker, Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts) {
        return new LimitedBarrelBakedModel(baker, woodModelParts, woodDynamicBakingData, woodPartitionedModelParts);
    }

    private static class LimitedBarrelBakedModel
    extends BarrelBakedModelBase {
        public LimitedBarrelBakedModel(ModelBaker baker, Map<String, Map<BarrelModelPart, BakedModel>> woodModelParts, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, BakedModel>> woodPartitionedModelParts) {
            super(baker, woodModelParts, woodDynamicBakingData, woodPartitionedModelParts);
        }

        @Override
        protected BarrelModelPart getBasePart(@Nullable BlockState state) {
            return BarrelModelPart.BASE;
        }

        @Override
        protected int getInWorldBlockHash(BlockState state, ModelData data, @Nullable RenderType renderType) {
            int hash = super.getInWorldBlockHash(state, data, renderType);
            hash = hash * 31 + ((Direction)state.getValue(LimitedBarrelBlock.HORIZONTAL_FACING)).get2DDataValue();
            hash = hash * 31 + ((VerticalFacing)((Object)state.getValue(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }

        @Override
        protected List<BakedQuad> rotateDisplayItemQuads(List<BakedQuad> quads, BlockState state) {
            VerticalFacing verticalFacing = (VerticalFacing)((Object)state.getValue(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                quads = ((IQuadTransformer)DIRECTION_ROTATES.get(verticalFacing.getDirection())).process(quads);
            }
            quads = ((IQuadTransformer)DIRECTION_ROTATES.get(state.getValue(LimitedBarrelBlock.HORIZONTAL_FACING))).process(quads);
            return quads;
        }

        @Override
        protected int calculateMoveBackToSideHash(BlockState state, Direction dir, float distFromCenter, int displayItemIndex, int displayItemCount) {
            int hash = super.calculateMoveBackToSideHash(state, dir, distFromCenter, displayItemIndex, displayItemCount);
            hash = hash * 31 + ((Direction)state.getValue(LimitedBarrelBlock.HORIZONTAL_FACING)).get2DDataValue();
            hash = hash * 31 + ((VerticalFacing)((Object)state.getValue(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }

        @Override
        protected void rotateDisplayItemFrontOffset(BlockState state, Direction dir, Vector3f frontOffset) {
            VerticalFacing verticalFacing = (VerticalFacing)((Object)state.getValue(LimitedBarrelBlock.VERTICAL_FACING));
            if (verticalFacing != VerticalFacing.NO) {
                DisplayItemRenderer.getNorthBasedRotation(verticalFacing.getDirection()).transform(frontOffset);
            }
            DisplayItemRenderer.getNorthBasedRotation((Direction)state.getValue(LimitedBarrelBlock.HORIZONTAL_FACING)).transform(frontOffset);
        }

        @Override
        protected int calculateDirectionMoveHash(BlockState state, ItemStack displayItem, int displayItemIndex, int displayItemCount, boolean isFlatTop) {
            int hash = super.calculateDirectionMoveHash(state, displayItem, displayItemIndex, displayItemCount, isFlatTop);
            hash = 31 * hash + ((Direction)state.getValue(LimitedBarrelBlock.HORIZONTAL_FACING)).get2DDataValue();
            hash = 31 * hash + ((VerticalFacing)((Object)state.getValue(LimitedBarrelBlock.VERTICAL_FACING))).getIndex();
            return hash;
        }

        @Override
        protected boolean rendersOpen() {
            return false;
        }
    }

    public static final class Loader
    extends BarrelDynamicModelBase.Loader<LimitedBarrelDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        @Override
        protected LimitedBarrelDynamicModel instantiateModel(@Nullable ResourceLocation parentLocation, Map<String, Map<BarrelModelPart, BarrelDynamicModelBase.BarrelModelPartDefinition>> woodOverrides, Map<DynamicBarrelBakingData.DynamicPart, ResourceLocation> dynamicPartModels, Map<String, Map<BarrelModelPart, BarrelDynamicModelBase.BarrelModelPartDefinition>> woodPartitionedModelPartDefinitions) {
            return new LimitedBarrelDynamicModel(parentLocation, woodOverrides, dynamicPartModels, woodPartitionedModelPartDefinitions);
        }
    }
}

