/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.ExtendedUnbakedModel;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;

public class ShulkerBoxDynamicModel
implements ExtendedUnbakedModel {
    private static final String BLOCK_BREAK_FOLDER = "block/break/";
    public static final ResourceLocation TINTABLE_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/tintable_shulker_box");
    public static final ResourceLocation MAIN_BREAK_TEXTURE = SophisticatedStorage.getRL("block/break/shulker_box");

    public BakedModel bake(TextureSlots textureSlots, ModelBaker modelBaker, ModelState modelState, boolean useAmbientOcclusion, boolean usesBlockLight, ItemTransforms itemTransforms, ContextMap contextMap) {
        return new ShulkerBoxBakedModel();
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }

    private static class ShulkerBoxBakedModel
    implements BakedModel {
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();

        private ShulkerBoxBakedModel() {
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            return Collections.emptyList();
        }

        public boolean useAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return true;
        }

        public boolean usesBlockLight() {
            return true;
        }

        public TextureAtlasSprite getParticleIcon() {
            BakedModel model = Minecraft.getInstance().getModelManager().getModel(BlockModelShaper.stateToModelLocation((BlockState)Blocks.OAK_PLANKS.defaultBlockState()));
            return model.getParticleIcon();
        }

        public ItemTransforms getTransforms() {
            return ItemTransforms.NO_TRANSFORMS;
        }

        @Nonnull
        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
                ModelData.Builder builder = ModelData.builder();
                builder.with(HAS_MAIN_COLOR, (Object)(be.getStorageWrapper().getMainColor() != -1 ? 1 : 0));
                return builder.build();
            }).orElse(ModelData.EMPTY);
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            ResourceLocation texture = TINTABLE_BREAK_TEXTURE;
            if (Boolean.FALSE.equals(data.get(HAS_MAIN_COLOR))) {
                texture = MAIN_BREAK_TEXTURE;
            }
            return (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(texture);
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<ShulkerBoxDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public ShulkerBoxDynamicModel read(JsonObject modelContents, JsonDeserializationContext deserializationContext) {
            return new ShulkerBoxDynamicModel();
        }
    }
}

