/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.AbstractUnbakedModel;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.StandardModelParameters;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;

public class SimpleCompositeModel
extends AbstractUnbakedModel {
    private final ImmutableMap<String, Either<ResourceLocation, UnbakedModel>> children;
    private List<UnbakedModel> resolvedChildren = List.of();

    private SimpleCompositeModel(ImmutableMap<String, Either<ResourceLocation, UnbakedModel>> children, StandardModelParameters parameters) {
        super(parameters);
        this.children = children;
    }

    public BakedModel bake(TextureSlots slots, ModelBaker baker, ModelState state, boolean useAmbientOcclusion, boolean usesBlockLight, ItemTransforms transforms, ContextMap additionalProperties) {
        ArrayList<BlockElement> allElements = new ArrayList<BlockElement>();
        this.addAllChildElements(allElements);
        Transformation rootTransform = (Transformation)additionalProperties.getOrDefault(NeoForgeModelProperties.TRANSFORM, (Object)Transformation.identity());
        if (!rootTransform.isIdentity()) {
            state = UnbakedElementsHelper.composeRootTransformIntoModelState((ModelState)state, (Transformation)rootTransform);
        }
        return SimpleBakedModel.bakeElements(allElements, (TextureSlots)slots, (SpriteGetter)baker.sprites(), (ModelState)state, (boolean)useAmbientOcclusion, (boolean)usesBlockLight, (boolean)true, (ItemTransforms)transforms, (Transformation)rootTransform, (RenderTypeGroup)RenderTypeGroup.EMPTY);
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        super.resolveDependencies(resolver);
        this.resolvedChildren = this.children.values().stream().map(child -> (UnbakedModel)child.map(arg_0 -> ((ResolvableModel.Resolver)resolver).resolve(arg_0), model -> {
            model.resolveDependencies(resolver);
            return model;
        })).toList();
    }

    private void addAllChildElements(List<BlockElement> elements) {
        this.resolvedChildren.forEach(child -> this.addModelElements(elements, (UnbakedModel)child));
    }

    private void addModelElements(List<BlockElement> elements, UnbakedModel child) {
        if (child instanceof SimpleCompositeModel) {
            SimpleCompositeModel compositeModel = (SimpleCompositeModel)child;
            compositeModel.addAllChildElements(elements);
        } else if (child instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)child;
            elements.addAll(blockModel.elements);
        }
        if (child.getParent() != null) {
            this.addModelElements(elements, child.getParent());
        }
    }

    public TextureSlots.Data getTextureSlots() {
        HashMap textures = new HashMap(super.getTextureSlots().values());
        this.children.values().forEach(child -> child.ifRight(unbakedModel -> this.addAllTextureSlots((UnbakedModel)unbakedModel, textures)));
        return new TextureSlots.Data(textures);
    }

    private void addAllTextureSlots(UnbakedModel unbakedModel, Map<String, TextureSlots.SlotContents> textures) {
        unbakedModel.getTextureSlots().values().forEach(textures::putIfAbsent);
        UnbakedModel model = unbakedModel;
        while (model.getParent() != null) {
            model = model.getParent();
            model.getTextureSlots().values().forEach(textures::putIfAbsent);
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<SimpleCompositeModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SimpleCompositeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            Loader.readChildren(jsonObject, "parts", (ImmutableMap.Builder<String, Either<ResourceLocation, UnbakedModel>>)childrenBuilder, deserializationContext);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Simple Composite model requires a \"parts\" element with at least one element.");
            }
            StandardModelParameters parameters = StandardModelParameters.parse((JsonObject)jsonObject, (JsonDeserializationContext)deserializationContext);
            return new SimpleCompositeModel((ImmutableMap<String, Either<ResourceLocation, UnbakedModel>>)children, parameters);
        }

        private static void readChildren(JsonObject jsonObject, String name, ImmutableMap.Builder<String, Either<ResourceLocation, UnbakedModel>> children, JsonDeserializationContext context) {
            if (jsonObject.has(name)) {
                JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
                for (Map.Entry entry : childrenJsonObject.entrySet()) {
                    JsonElement jsonElement;
                    JsonElement jsonElement2 = (JsonElement)entry.getValue();
                    Objects.requireNonNull(jsonElement2);
                    int n = 0;
                    Either child = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonObject.class}, (Object)jsonElement, n)) {
                        case 0 -> {
                            JsonPrimitive reference = (JsonPrimitive)jsonElement;
                            yield Either.left((Object)ResourceLocation.parse((String)reference.getAsString()));
                        }
                        case 1 -> {
                            JsonObject inline = (JsonObject)jsonElement;
                            yield Either.right((Object)((UnbakedModel)context.deserialize((JsonElement)inline, UnbakedModel.class)));
                        }
                        default -> throw new IllegalArgumentException("");
                    };
                    children.put((Object)((String)entry.getKey()), (Object)child);
                }
            }
        }
    }
}

