/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataPayload;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class DecorationTableMenu
extends AbstractContainerMenu
implements ISyncedContainer {
    private static final String SET_INHERITANCE_ACTION = "setInheritance";
    private static final ResourceLocation EMPTY_RED_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("container/slot/red_dye");
    private static final ResourceLocation EMPTY_GREEN_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("container/slot/green_dye");
    private static final ResourceLocation EMPTY_BLUE_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("container/slot/blue_dye");
    private static final ResourceLocation EMPTY_MATERIAL_SLOT_BACKGROUND = SophisticatedStorage.getRL("container/slot/material");
    public static final int DECORATION_SLOT_PADDING = 12;
    private final DecorationTableBlockEntity blockEntity;
    private Slot resultSlot;
    private SlotRange decorationSlotRange;
    private SlotRange dyeSlotRange;
    private SlotRange storageSlotRange;
    private SlotRange playerSlotRange;
    @Nullable
    private Runnable slotChangedListener = null;
    private SlotItemHandler storageSlot;

    public DecorationTableMenu(int containerId, Player player, BlockPos pos) {
        super(ModBlocks.DECORATION_TABLE_CONTAINER_TYPE.get(), containerId);
        this.blockEntity = player.level().getBlockEntity(pos, ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get()).orElse(null);
        if (this.blockEntity == null) {
            throw new IllegalStateException("No block entity found at position " + String.valueOf(pos));
        }
        int y = this.addDecorationSlots();
        this.addStorageSlots();
        this.addPlayerSlots(player.getInventory(), y += 14);
    }

    public void setSlotChangedListener(@Nullable Runnable listener) {
        this.slotChangedListener = listener;
    }

    public Slot getStorageSlot() {
        return this.storageSlot;
    }

    public List<ItemStack> getDecoratedPreviewStacks() {
        return this.blockEntity.getDecoratedPreviewStacks();
    }

    private void addStorageSlots() {
        ItemStackHandler storageBlock = this.blockEntity.getStorageBlock();
        this.storageSlot = new SlotItemHandler((IItemHandler)storageBlock, 0, this.getSlot((int)this.dyeSlotRange.firstSlot()).x, this.getSlot((int)3).y){

            public void setChanged() {
                super.setChanged();
                if (DecorationTableMenu.this.slotChangedListener != null) {
                    DecorationTableMenu.this.slotChangedListener.run();
                }
            }
        };
        this.addSlot((Slot)this.storageSlot);
        this.storageSlotRange = new SlotRange(this.dyeSlotRange.firstSlot() + this.dyeSlotRange.numberOfSlots(), 1);
        this.resultSlot = new Slot((Container)new SimpleContainer(1){

            public ItemStack getItem(int index) {
                return DecorationTableMenu.this.blockEntity.getResult();
            }

            public ItemStack removeItem(int index, int count) {
                return index == 0 ? DecorationTableMenu.this.blockEntity.extractResult(count) : ItemStack.EMPTY;
            }
        }, 0, this.storageSlot.x + 18 + 18, this.storageSlot.y){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return super.mayPickup(player) && DecorationTableMenu.this.getMissingDyes().isEmpty();
            }

            public ItemStack remove(int amount) {
                return super.remove(amount);
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (player.level().isClientSide()) {
                    return;
                }
                DecorationTableMenu.this.blockEntity.consumeIngredientsOnCraft();
                DecorationTableMenu.this.blockEntity.getStorageBlock().extractItem(0, 1, false);
            }
        };
        this.addSlot(this.resultSlot);
    }

    private int addDecorationSlots() {
        int xOffset = 8;
        int yOffset = 17;
        ItemStackHandler decorativeBlocks = this.blockEntity.getDecorativeBlocks();
        int x = xOffset;
        int y = yOffset;
        int slotIndex = 0;
        y = this.addDecorationSlot(decorativeBlocks, slotIndex, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 1, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 2, x, y, 12);
        this.addDecorationSlot(decorativeBlocks, 3, x, y, 12);
        y = yOffset + 18 + 12;
        y = this.addDecorationSlot(decorativeBlocks, 4, x += 48, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 5, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 6, x, y, 0);
        this.decorationSlotRange = new SlotRange(0, decorativeBlocks.getSlots());
        ItemStackHandler dyes = this.blockEntity.getDyes();
        this.addSlot(new SlotItemHandler((IItemHandler)dyes, 0, x += 44, yOffset).setBackground(EMPTY_RED_DYE_SLOT_BACKGROUND));
        this.addSlot(new SlotItemHandler((IItemHandler)dyes, 1, x += 18, yOffset).setBackground(EMPTY_GREEN_DYE_SLOT_BACKGROUND));
        this.addSlot(new SlotItemHandler((IItemHandler)dyes, 2, x += 18, yOffset).setBackground(EMPTY_BLUE_DYE_SLOT_BACKGROUND));
        this.dyeSlotRange = new SlotRange(this.decorationSlotRange.firstSlot() + this.decorationSlotRange.numberOfSlots(), dyes.getSlots());
        return y;
    }

    private int addDecorationSlot(ItemStackHandler itemHandler, int slotIndex, int xOffset, int y, int yPadding) {
        this.addSlot(new SlotItemHandler((IItemHandler)itemHandler, slotIndex, xOffset, y){

            public void setChanged() {
                super.setChanged();
                if (DecorationTableMenu.this.slotChangedListener != null) {
                    DecorationTableMenu.this.slotChangedListener.run();
                }
            }
        }.setBackground(EMPTY_MATERIAL_SLOT_BACKGROUND));
        y += 18;
        return y += yPadding;
    }

    private void addPlayerSlots(Inventory playerInventory, int y) {
        int playerSlotXOffset = 45;
        int hotbarPadding = 4;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, playerSlotXOffset + col * 18, y + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            Slot slot = new Slot((Container)playerInventory, col, playerSlotXOffset + col * 18, y + 54 + hotbarPadding);
            this.addSlot(slot);
        }
        this.playerSlotRange = new SlotRange(this.storageSlotRange.firstSlot() + this.storageSlotRange.numberOfSlots() + 1, 36);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = this.getSlot(slotIndex);
        ItemStack slotStack = slot.getItem();
        ItemStack slotStackCopy = slotStack.copy();
        if (this.isPlayerSlot(slotIndex)) {
            if (this.blockEntity.getDecorativeBlocks().isItemValid(this.decorationSlotRange.firstSlot(), slotStack) && !this.moveItemStackTo(slotStack, this.decorationSlotRange, false)) {
                return ItemStack.EMPTY;
            }
            if (this.isValidDye(slotStack) && !this.moveItemStackTo(slotStack, this.dyeSlotRange, false)) {
                return ItemStack.EMPTY;
            }
            if (this.blockEntity.getStorageBlock().isItemValid(0, slotStack) && !this.moveItemStackTo(slotStack, this.storageSlotRange, false)) {
                return ItemStack.EMPTY;
            }
        } else if (!this.moveItemStackTo(slotStack, this.playerSlotRange, true)) {
            return ItemStack.EMPTY;
        }
        if (slotStackCopy.getCount() == slotStack.getCount()) {
            return ItemStack.EMPTY;
        }
        this.blockEntity.updateResultAndSetChanged();
        slot.onTake(player, slotStackCopy);
        return slotStackCopy;
    }

    private boolean isValidDye(ItemStack stack) {
        ItemStackHandler dyes = this.blockEntity.getDyes();
        for (int slot = 0; slot < dyes.getSlots(); ++slot) {
            if (!dyes.isItemValid(slot, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean moveItemStackTo(ItemStack stack, SlotRange slotRange, boolean reverse) {
        return this.moveItemStackTo(stack, slotRange.firstSlot(), slotRange.firstSlot() + slotRange.numberOfSlots(), reverse);
    }

    private boolean isPlayerSlot(int slotIndex) {
        return this.playerSlotRange.isInRange(slotIndex);
    }

    public SlotRange getDyeSlotRange() {
        return this.dyeSlotRange;
    }

    public boolean stillValid(Player player) {
        return player.canInteractWithBlock(this.blockEntity.getBlockPos(), 4.0);
    }

    public static DecorationTableMenu fromBuffer(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        return new DecorationTableMenu(containerId, playerInventory.player, buffer.readBlockPos());
    }

    public void setSlotMaterialInheritance(int slot, boolean inheritance) {
        this.blockEntity.setSlotMaterialInheritance(slot, inheritance);
        this.sendToServer(tag -> {
            tag.putString("action", SET_INHERITANCE_ACTION);
            tag.putInt("slot", slot);
            tag.putBoolean("inheritance", inheritance);
        });
    }

    public void setMainColor(int color) {
        this.blockEntity.setMainColor(color);
        this.sendToServer(tag -> tag.putInt("mainColor", color));
    }

    public void setAccentColor(int color) {
        this.blockEntity.setAccentColor(color);
        this.sendToServer(tag -> tag.putInt("accentColor", color));
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.blockEntity.isSlotMaterialInherited(slot);
    }

    public ItemStack getInheritedItem(int childSlot) {
        return this.blockEntity.getInheritedItem(childSlot);
    }

    public int getMainColor() {
        return this.blockEntity.getMainColor();
    }

    public int getAccentColor() {
        return this.blockEntity.getAccentColor();
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }

    protected void sendToServer(Consumer<CompoundTag> addData) {
        if (this.blockEntity.getLevel() == null || !this.blockEntity.getLevel().isClientSide) {
            return;
        }
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        PacketDistributor.sendToServer((CustomPacketPayload)new SyncContainerClientDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Map<ResourceLocation, Integer> getPartsNeeded() {
        return this.blockEntity.getPartsNeeded();
    }

    public Set<ResourceLocation> getMissingDyes() {
        return this.blockEntity.getMissingDyes();
    }

    public void handlePacket(CompoundTag data) {
        String action = data.getString("action");
        if (action.equals(SET_INHERITANCE_ACTION)) {
            this.setSlotMaterialInheritance(data.getInt("slot"), data.getBoolean("inheritance"));
        } else if (data.contains("mainColor")) {
            this.setMainColor(data.getInt("mainColor"));
        } else if (data.contains("accentColor")) {
            this.setAccentColor(data.getInt("accentColor"));
        }
    }

    public Map<ResourceLocation, Integer> getPartsStored() {
        return this.blockEntity.getPartsStored();
    }

    public boolean hasMaterials() {
        return this.blockEntity.hasMaterials();
    }
}

