/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.template.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.template.ExtendedModelTemplateBuilder;
import net.p3pp3rf1y.sophisticatedcore.data.SophisticatedModelProvider;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.client.init.StorageTintSources;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelItemModel;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;

public class StorageModelProvider
extends SophisticatedModelProvider {
    private static final ModelTemplate EMPTY_MODEL_TEMPLATE = ModelTemplates.create((TextureSlot[])new TextureSlot[0]);
    private static final ResourceLocation BASE_CHEST_PARTICLE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)"block/break/acacia_chest");
    private static final ResourceLocation BASE_SHULKER_BOX_PARTICLE = ResourceLocation.fromNamespaceAndPath((String)"sophisticatedstorage", (String)"block/break/shulker_box");

    public StorageModelProvider(PackOutput output) {
        super(output, "sophisticatedstorage");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.generateBlockModels(blockModels);
        this.generateItemModels(itemModels);
    }

    private void generateBlockModels(BlockModelGenerators blockModels) {
        ArrayList barrelItems = new ArrayList();
        this.addItemClasses(barrelItems, List.of(BarrelBlockItem.class));
        barrelItems.forEach(item -> this.generateBarrel(blockModels, (Item)item));
        this.generateBlockWithCustomLoader(blockModels, "chest", (Block)ModBlocks.CHEST.get(), ModelTemplates.CHEST_INVENTORY, BASE_CHEST_PARTICLE, ChestBlock.class, new ChestItemRenderer.Unbaked());
        this.generateBlockWithCustomLoader(blockModels, "shulker_box", (Block)ModBlocks.SHULKER_BOX.get(), ModelTemplates.SHULKER_BOX_INVENTORY, BASE_SHULKER_BOX_PARTICLE, ShulkerBoxBlock.class, new ShulkerBoxItemRenderer.Unbaked());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.CONTROLLER.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_IO.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_INPUT.get());
        this.generateCubeBottomTopReuseTopOnBottom(blockModels, (Block)ModBlocks.STORAGE_OUTPUT.get());
        ModBlocks.STORAGE_CONNECTOR_BLOCKS.values().stream().map(Supplier::get).forEach(arg_0 -> ((BlockModelGenerators)blockModels).createTrivialCube(arg_0));
        StorageModelProvider.generateCustomModelBlock(blockModels, (Block)ModBlocks.DECORATION_TABLE.get(), BlockModelGenerators.createHorizontalFacingDispatch());
        StorageModelProvider.generateCustomModelBlock(blockModels, (Block)ModBlocks.STORAGE_LINK.get(), blockModels.createColumnWithFacing());
    }

    private void generateBlockWithCustomLoader(BlockModelGenerators blockModels, String loaderName, Block baseBlock, ModelTemplate itemModelTemplate, ResourceLocation baseParticle, Class<? extends Block> blockClass, SpecialModelRenderer.Unbaked unbakedSpecialRenderer) {
        TexturedModel.Provider provider = TexturedModel.createDefault(b -> new TextureMapping(), (ModelTemplate)ExtendedModelTemplateBuilder.builder().customLoader(() -> this.createSimpleCustomLoaderBuilder(loaderName), loader -> {}).build());
        ResourceLocation blockModel = provider.create(baseBlock, blockModels.modelOutput);
        ResourceLocation itemModel = itemModelTemplate.create(baseBlock.asItem(), TextureMapping.particle((ResourceLocation)baseParticle), blockModels.modelOutput);
        BuiltInRegistries.BLOCK.entrySet().stream().filter(entry -> ((ResourceKey)entry.getKey()).location().getNamespace().equals(this.modId) && blockClass.isAssignableFrom(((Block)entry.getValue()).getClass())).forEach(entry -> {
            Block block = (Block)entry.getValue();
            this.generateForBlock(blockModels, block, itemModel, blockModel, unbakedSpecialRenderer);
        });
    }

    private CustomLoaderBuilder createSimpleCustomLoaderBuilder(final String name) {
        return new CustomLoaderBuilder(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)name), false){

            protected CustomLoaderBuilder copyInternal() {
                return StorageModelProvider.this.createSimpleCustomLoaderBuilder(name);
            }
        };
    }

    private void generateForBlock(BlockModelGenerators blockModels, Block block, ResourceLocation itemModel, ResourceLocation blockModel, SpecialModelRenderer.Unbaked unbakedSpecialRenderer) {
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (ResourceLocation)blockModel));
        Item item = block.asItem();
        ItemModel.Unbaked unbakedItemModel = ItemModelUtils.specialModel((ResourceLocation)itemModel, (SpecialModelRenderer.Unbaked)unbakedSpecialRenderer);
        blockModels.itemModelOutput.accept(item, unbakedItemModel);
    }

    private void generateBarrel(BlockModelGenerators blockModels, Item item) {
        if (item instanceof BarrelBlockItem) {
            BarrelBlockItem barrelBlockItem = (BarrelBlockItem)item;
            Block block = barrelBlockItem.getBlock();
            ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
            ResourceLocation flatTopBlockModelId = StorageModelProvider.getFlatTopModelLocation(block);
            MultiVariantGenerator multiVariantGenerator = MultiVariantGenerator.multiVariant((Block)block);
            if (block instanceof LimitedBarrelBlock) {
                multiVariantGenerator.with(BlockModelGenerators.createHorizontalFacingDispatch());
                multiVariantGenerator.with(StorageModelProvider.createVerticalFacingDispatch());
            } else {
                multiVariantGenerator.with(blockModels.createColumnWithFacing());
            }
            blockModels.blockStateOutput.accept(multiVariantGenerator.with((PropertyDispatch)PropertyDispatch.property((Property)BarrelBlock.FLAT_TOP).select((Comparable)Boolean.valueOf(false), Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).select((Comparable)Boolean.valueOf(true), Variant.variant().with(VariantProperties.MODEL, (Object)flatTopBlockModelId))));
            blockModels.itemModelOutput.accept(item, (ItemModel.Unbaked)new BarrelItemModel.Unbaked(blockModelId, flatTopBlockModelId, List.of(new StorageTintSources.Main(-1), new StorageTintSources.Accent(-1))));
        }
    }

    private static void generateCustomModelBlock(BlockModelGenerators blockModels, Block block, PropertyDispatch facingPropertyDispatch) {
        ResourceLocation blockModelId = ModelLocationUtils.getModelLocation((Block)block);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)blockModelId)).with(facingPropertyDispatch));
        blockModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.plainModel((ResourceLocation)blockModelId));
    }

    private static PropertyDispatch createVerticalFacingDispatch() {
        return PropertyDispatch.property(LimitedBarrelBlock.VERTICAL_FACING).select((Comparable)((Object)VerticalFacing.NO), Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)((Object)VerticalFacing.DOWN), Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)((Object)VerticalFacing.UP), Variant.variant());
    }

    private static ResourceLocation getFlatTopModelLocation(Block block) {
        ResourceLocation resourcelocation = BuiltInRegistries.BLOCK.getKey((Object)block);
        return resourcelocation.withPrefix("block/flat/");
    }

    private void generateItemModels(ItemModelGenerators itemModels) {
        ArrayList<Item> flatItems = new ArrayList<Item>();
        this.addItemClasses(flatItems, List.of(UpgradeItemBase.class, StorageTierUpgradeItem.class));
        flatItems.add((Item)ModItems.DEBUG_TOOL.get());
        flatItems.add((Item)ModItems.PACKING_TAPE.get());
        flatItems.add((Item)ModItems.SUPER_PACKING_TAPE.get());
        flatItems.add((Item)ModItems.UPGRADE_BASE.get());
        flatItems.add(ModItems.INACCESSIBLE_SLOT.get());
        flatItems.forEach(item -> itemModels.generateFlatItem(item, ModelTemplates.FLAT_ITEM));
        itemModels.generateFlatItem((Item)ModItems.STORAGE_TOOL.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem((Item)ModItems.PAINTBRUSH.get(), ModelTemplates.FLAT_HANDHELD_ITEM);
    }
}

