/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;

public class StorageBlockItem
extends BlockItemBase
implements ITintableBlockItem {
    public StorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static Optional<CompoundTag> getEntityWrapperTagFromStack(IDataComponentHolderExtension componentHolder) {
        CustomData customData = (CustomData)componentHolder.get(() -> DataComponents.BLOCK_ENTITY_DATA);
        if (customData == null) {
            return Optional.empty();
        }
        return Optional.of(customData.copyTag().getCompound("storageWrapper"));
    }

    public static Optional<Integer> getMainColorFromComponentHolder(IDataComponentHolderExtension componentHolder) {
        return StorageBlockItem.getEntityWrapperTagFromStack(componentHolder).flatMap(tag -> tag.contains("mainColor") ? Optional.of(tag.getInt("mainColor")) : Optional.empty()).or(() -> Optional.ofNullable((Integer)componentHolder.get(ModCoreDataComponents.MAIN_COLOR)));
    }

    public static Optional<Integer> getAccentColorFromComponentHolder(IDataComponentHolderExtension componentHolder) {
        return StorageBlockItem.getEntityWrapperTagFromStack(componentHolder).flatMap(tag -> tag.contains("accentColor") ? Optional.of(tag.getInt("accentColor")) : Optional.empty()).or(() -> Optional.ofNullable((Integer)componentHolder.get(ModCoreDataComponents.ACCENT_COLOR)));
    }

    public static void setNumberOfInventorySlots(ItemStack storageStack, int numberOfInventorySlots) {
        storageStack.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
    }

    public static void setNumberOfUpgradeSlots(ItemStack storageStack, int numberOfUpgradeSlots) {
        storageStack.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
    }

    public static int getNumberOfInventorySlots(ItemStack storageStack) {
        return (Integer)storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)0);
    }

    public static int getNumberOfUpgradeSlots(ItemStack storageStack) {
        return (Integer)storageStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)0);
    }

    public static boolean isLocked(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.LOCKED, (Object)false);
    }

    public static void setLocked(ItemStack stack, boolean locked) {
        if (locked) {
            stack.set(ModDataComponents.LOCKED, (Object)true);
        } else {
            stack.remove(ModDataComponents.LOCKED);
        }
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        storageStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
    }

    @Override
    public Optional<Integer> getMainColor(ItemStack storageStack) {
        return StorageBlockItem.getMainColorFromComponentHolder((IDataComponentHolderExtension)storageStack);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        storageStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
    }

    @Override
    public void removeMainColor(ItemStack stack) {
        stack.remove(ModCoreDataComponents.MAIN_COLOR);
    }

    @Override
    public void removeAccentColor(ItemStack stack) {
        stack.remove(ModCoreDataComponents.ACCENT_COLOR);
    }

    @Override
    public Optional<Integer> getAccentColor(ItemStack stack) {
        return StorageBlockItem.getAccentColorFromComponentHolder((IDataComponentHolderExtension)stack);
    }

    public static boolean showsTier(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.TIER_VISIBLE, (Object)true);
    }

    public static void setShowsTier(ItemStack stack, boolean showsTier) {
        if (showsTier) {
            stack.remove(ModDataComponents.TIER_VISIBLE);
        } else {
            stack.set(ModDataComponents.TIER_VISIBLE, (Object)false);
        }
    }
}

