/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import org.joml.Vector3f;

public class LockRenderer {
    public static final Material LOCK_TEXTURE = new Material(InventoryMenu.BLOCK_ATLAS, SophisticatedStorage.getRL("block/lock"));

    private LockRenderer() {
    }

    public static void renderLock(StorageBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float yOffset, BooleanSupplier holdsCorrectItem) {
        VertexConsumer vertexConsumer;
        boolean translucentRender;
        if (!blockEntity.isLocked() || !holdsCorrectItem.getAsBoolean() && !blockEntity.shouldShowLock()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.46875, (double)yOffset, -0.001);
        poseStack.scale(0.0625f, 0.0625f, 0.0625f);
        poseStack.pushPose();
        boolean bl = translucentRender = !blockEntity.shouldShowLock() && holdsCorrectItem.getAsBoolean();
        if (translucentRender) {
            TextureAtlasSprite sprite = LOCK_TEXTURE.sprite();
            vertexConsumer = sprite.wrap(bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)sprite.atlasLocation())));
        } else {
            vertexConsumer = LOCK_TEXTURE.buffer(bufferSource, RenderType::entityCutoutNoCull);
        }
        PoseStack.Pose pose = poseStack.last();
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        pose.normal().transform(normal);
        RenderHelper.renderQuad(vertexConsumer, pose.pose(), normal, packedOverlay, packedLight, translucentRender ? 0.5f : 1.0f);
        poseStack.popPose();
        poseStack.popPose();
    }
}

