/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ChestRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Vector3f;

public class ChestItemRenderer
implements SpecialModelRenderer<ChestAttributes> {
    private final LoadingCache<BlockItem, ChestBlockEntity> chestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<BlockItem, ChestBlockEntity>(this){

        public ChestBlockEntity load(BlockItem blockItem) {
            return new ChestBlockEntity(BlockPos.ZERO, (BlockState)blockItem.getBlock().defaultBlockState().setValue(ChestBlock.FACING, (Comparable)Direction.SOUTH));
        }
    });
    private final LoadingCache<DoubleChestBlockEntityKey, ChestBlockEntity> doubleChestBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<DoubleChestBlockEntityKey, ChestBlockEntity>(this){

        public ChestBlockEntity load(DoubleChestBlockEntityKey key) {
            return new ChestBlockEntity(BlockPos.ZERO, (BlockState)((BlockState)key.blockItem().getBlock().defaultBlockState().setValue(ChestBlock.FACING, (Comparable)Direction.SOUTH)).setValue(ChestBlock.TYPE, (Comparable)key.chestType()));
        }
    });

    @Nullable
    public ChestAttributes extractArgument(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        boolean isDoubleChest = ChestBlockItem.isDoubleChest(stack);
        int mainColor = -1;
        int accentColor = -1;
        Item item2 = stack.getItem();
        if (item2 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item2;
            mainColor = tintableBlockItem.getMainColor(stack).orElse(-1);
            accentColor = tintableBlockItem.getAccentColor(stack).orElse(-1);
        }
        Optional<WoodType> woodType = WoodStorageBlockItem.getWoodType((DataComponentHolder)stack);
        boolean isPacked = WoodStorageBlockItem.isPacked(stack);
        boolean showsTier = StorageBlockItem.showsTier(stack);
        return new ChestAttributes(blockItem, isDoubleChest, mainColor, accentColor, woodType, isPacked, showsTier);
    }

    public void render(@Nullable ChestAttributes chestAttributes, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean hasFoil) {
        if (chestAttributes == null) {
            return;
        }
        if (chestAttributes.isDoubleChest()) {
            ChestBlockEntity leftChestBlockEntity = (ChestBlockEntity)this.doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(chestAttributes.blockItem(), ChestType.LEFT));
            poseStack.pushPose();
            poseStack.scale(0.8f, 0.8f, 0.8f);
            poseStack.translate(0.72, 0.0, 0.0);
            this.renderBlockEntity(chestAttributes, poseStack, buffer, packedLight, packedOverlay, leftChestBlockEntity);
            ChestBlockEntity rightChestBlockEntity = (ChestBlockEntity)this.doubleChestBlockEntities.getUnchecked((Object)new DoubleChestBlockEntityKey(chestAttributes.blockItem(), ChestType.RIGHT));
            poseStack.translate(-1.0, 0.0, 0.0);
            this.renderBlockEntity(chestAttributes, poseStack, buffer, packedLight, packedOverlay, rightChestBlockEntity);
            poseStack.popPose();
            return;
        }
        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)this.chestBlockEntities.getUnchecked((Object)chestAttributes.blockItem());
        this.renderBlockEntity(chestAttributes, poseStack, buffer, packedLight, packedOverlay, chestBlockEntity);
    }

    public void getExtents(Set<Vector3f> set) {
        PoseStack posestack = new PoseStack();
        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)this.chestBlockEntities.getUnchecked((Object)((BlockItem)ModBlocks.CHEST_ITEM.get()));
        BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)chestBlockEntity);
        if (blockentityrenderer instanceof ChestRenderer) {
            ChestRenderer chestRenderer = (ChestRenderer)blockentityrenderer;
            chestRenderer.rootModelPart().getExtentsForGui(posestack, set);
        }
    }

    private void renderBlockEntity(ChestAttributes chestAttributes, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, ChestBlockEntity chestBlockEntity) {
        BlockEntityRenderer blockentityrenderer;
        chestBlockEntity.getStorageWrapper().setColors(chestAttributes.mainColor(), chestAttributes.accentColor());
        Optional<WoodType> woodType = chestAttributes.woodType();
        if (woodType.isPresent() || !chestBlockEntity.getStorageWrapper().hasAccentColor() || !chestBlockEntity.getStorageWrapper().hasMainColor()) {
            chestBlockEntity.setWoodType(woodType.orElse(WoodType.ACACIA));
        }
        chestBlockEntity.setPacked(chestAttributes.isPacked());
        if (chestAttributes.showsTier() != chestBlockEntity.shouldShowTier()) {
            chestBlockEntity.toggleTierVisiblity();
        }
        if ((blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)chestBlockEntity)) != null) {
            blockentityrenderer.render((BlockEntity)chestBlockEntity, 0.0f, poseStack, buffer, packedLight, packedOverlay, Vec3.ZERO);
        }
    }

    public record ChestAttributes(BlockItem blockItem, boolean isDoubleChest, int mainColor, int accentColor, Optional<WoodType> woodType, boolean isPacked, boolean showsTier) {
    }

    private record DoubleChestBlockEntityKey(BlockItem blockItem, ChestType chestType) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleChestBlockEntityKey that = (DoubleChestBlockEntityKey)o;
            return Objects.equal((Object)this.blockItem, (Object)that.blockItem) && this.chestType == that.chestType;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.blockItem, this.chestType});
        }
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet entityModelSet) {
            return new ChestItemRenderer();
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

