/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class ItemContentsStorage
extends SavedData {
    private static final SavedDataType<ItemContentsStorage> TYPE = new SavedDataType("sophisticatedstorage", ItemContentsStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)CompoundTag.CODEC).fieldOf("storageContents").forGetter(storage -> storage.storageContents)).apply((Applicative)builder, ItemContentsStorage::new)));
    private final Map<UUID, CompoundTag> storageContents = new HashMap<UUID, CompoundTag>();
    private static final ItemContentsStorage clientStorageCopy = new ItemContentsStorage();

    private ItemContentsStorage(Map<UUID, CompoundTag> storageContents) {
        this.storageContents.putAll(storageContents);
    }

    private ItemContentsStorage() {
    }

    public static ItemContentsStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (ItemContentsStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public boolean has(UUID storageUuid) {
        return this.storageContents.containsKey(storageUuid);
    }

    public CompoundTag getOrCreateStorageContents(UUID storageUuid) {
        return this.storageContents.computeIfAbsent(storageUuid, uuid -> {
            this.setDirty();
            return new CompoundTag();
        });
    }

    public void removeStorageContents(UUID storageUuid) {
        this.storageContents.remove(storageUuid);
        this.setDirty();
    }

    public void setStorageContents(UUID storageUuid, CompoundTag contents) {
        this.storageContents.put(storageUuid, contents);
        this.setDirty();
    }
}

