/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeClientTickHandler;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeClientRegistry;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.DynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class StorageHolderBase
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay,
IFillLevelDisplay,
IMaterialHolder {
    @Nullable
    private MovingStorageOpenersCounter openersCounter = null;
    protected boolean updateRenderAttributes = false;
    protected IStorageWrapper storageWrapper = NoopStorageWrapper.INSTANCE;
    protected boolean isMainStorage = true;
    private final boolean showChestUpgradesOnTop;

    protected StorageHolderBase(boolean showChestUpgradesOnTop) {
        this.showChestUpgradesOnTop = showChestUpgradesOnTop;
    }

    private MovingStorageOpenersCounter getOpenersCounter() {
        if (this.openersCounter == null) {
            this.openersCounter = new MovingStorageOpenersCounter(){

                @Override
                protected void onOpen() {
                    if (StorageHolderBase.this.isBarrel()) {
                        StorageHolderBase.this.playSound(SoundEvents.BARREL_OPEN);
                        StorageHolderBase.this.updateBarrelOpenBlockState(true);
                    } else if (StorageHolderBase.this.isShulkerBox()) {
                        StorageHolderBase.this.playSound(SoundEvents.SHULKER_BOX_OPEN);
                        StorageBlockEntity storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity();
                        if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                            shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.OPENING);
                        }
                    } else if (StorageHolderBase.this.isChest()) {
                        StorageBlockEntity storageBlockEntity;
                        if (StorageHolderBase.this.isMainStorage) {
                            StorageHolderBase.this.playSound(SoundEvents.CHEST_OPEN);
                        }
                        if ((storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
                            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                            chestBlockEntity.getChestLidController().shouldBeOpen(true);
                        }
                    }
                }

                @Override
                protected void onClose() {
                    if (StorageHolderBase.this.isBarrel()) {
                        StorageHolderBase.this.playSound(SoundEvents.BARREL_CLOSE);
                        StorageHolderBase.this.updateBarrelOpenBlockState(false);
                    } else if (StorageHolderBase.this.isShulkerBox()) {
                        StorageHolderBase.this.playSound(SoundEvents.SHULKER_BOX_CLOSE);
                        StorageBlockEntity storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity();
                        if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                            shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.CLOSING);
                        }
                    } else if (StorageHolderBase.this.isChest()) {
                        StorageBlockEntity storageBlockEntity;
                        if (StorageHolderBase.this.isMainStorage) {
                            StorageHolderBase.this.playSound(SoundEvents.CHEST_CLOSE);
                        }
                        if ((storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
                            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                            chestBlockEntity.getChestLidController().shouldBeOpen(false);
                        }
                    }
                }

                @Override
                protected boolean isOwnContainer(Player player) {
                    return StorageHolderBase.this.isOwnContainer(player);
                }
            };
        }
        return this.openersCounter;
    }

    protected abstract boolean isOwnContainer(Player var1);

    protected abstract void playSound(SoundEvent var1);

    @Nullable
    protected abstract Entity getEntity();

    private void onStackChanged() {
        this.setSyncedStorageStack(this.getStorageWrapper().getWrappedStorageStack());
        this.updateRenderAttributes = true;
    }

    public void updateStorageWrapper() {
        ItemStack storageItem = this.getSyncedStorageStack();
        UUID id = (UUID)storageItem.get(ModCoreDataComponents.STORAGE_UUID);
        if (id == null) {
            id = UUID.randomUUID();
            storageItem.set(ModCoreDataComponents.STORAGE_UUID, (Object)id);
            this.setStorageItem(storageItem);
        }
        this.storageWrapper = MovingStorageWrapper.fromStack(storageItem, this::onContentsChanged, this::onStackChanged, this::getStorageData, this::isLocked, this::setLocked, this::isUpgradeRunnable);
    }

    protected boolean isUpgradeRunnable(ItemStack upgrade) {
        return true;
    }

    protected abstract IStorageSavedData getStorageData();

    private void onContentsChanged() {
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        ItemStack storageItem = this.getSyncedStorageStack();
        UUID storageId = (UUID)storageItem.get(ModCoreDataComponents.STORAGE_UUID);
        if (storageId == null) {
            return;
        }
        this.getStorageData().markChanged();
    }

    public void setStorageItem(ItemStack storageItem) {
        this.setSyncedStorageStack(storageItem);
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
        this.updateRenderAttributes = true;
    }

    public IStorageWrapper getStorageWrapper() {
        if (this.isPacked()) {
            return NoopStorageWrapper.INSTANCE;
        }
        if (!this.getSyncedStorageStack().isEmpty() && this.storageWrapper == NoopStorageWrapper.INSTANCE) {
            this.updateStorageWrapper();
        }
        return this.storageWrapper;
    }

    public boolean isBarrel() {
        return this.getSyncedStorageStack().getItem() instanceof BarrelBlockItem;
    }

    protected boolean isShulkerBox() {
        return this.getSyncedStorageStack().getItem() instanceof ShulkerBoxItem;
    }

    protected boolean isChest() {
        return this.getSyncedStorageStack().getItem() instanceof ChestBlockItem;
    }

    public boolean areUpgradesVisible() {
        return (Boolean)this.getSyncedStorageStack().getOrDefault(ModDataComponents.UPGRADES_VISIBLE, (Object)false);
    }

    public boolean areCountsVisible() {
        return (Boolean)this.getSyncedStorageStack().getOrDefault(ModDataComponents.COUNTS_VISIBLE, (Object)true);
    }

    public boolean areFillLevelsVisible() {
        return (Boolean)this.getSyncedStorageStack().getOrDefault(ModDataComponents.FILL_LEVELS_VISIBLE, (Object)false);
    }

    public boolean isLockVisible() {
        return (Boolean)this.getSyncedStorageStack().getOrDefault(ModDataComponents.LOCK_VISIBLE, (Object)true);
    }

    public boolean isPacked() {
        return WoodStorageBlockItem.isPacked(this.getSyncedStorageStack());
    }

    public CompoundTag getRenderInfoNbt(ItemStack storageItem) {
        return ((CustomData)storageItem.getOrDefault(ModCoreDataComponents.RENDER_INFO_TAG, (Object)CustomData.EMPTY)).copyTag();
    }

    protected abstract void setSyncedStorageStack(ItemStack var1);

    protected abstract ItemStack getSyncedStorageStack();

    protected abstract boolean isLocked(ItemStack var1);

    @Nullable
    protected abstract Level getLevel();

    protected abstract Vec3 getPosition();

    private void updateBarrelOpenBlockState(boolean open) {
        BarrelBlockEntity barrelBlockEntity;
        StorageBlockEntity storageBlockEntity = this.getRenderBlockEntity();
        if (storageBlockEntity instanceof BarrelBlockEntity && !((barrelBlockEntity = (BarrelBlockEntity)storageBlockEntity) instanceof LimitedBarrelBlockEntity)) {
            barrelBlockEntity.setBlockState((BlockState)barrelBlockEntity.getBlockState().setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    @Nullable
    public StorageBlockEntity getRenderBlockEntity() {
        StorageBlockEntity renderBlockEntity = this.retrieveRenderBlockEntity();
        if (renderBlockEntity != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), renderBlockEntity);
        }
        return renderBlockEntity;
    }

    protected void updateRenderBlockEntityAttributes(ItemStack storageItem, StorageBlockEntity renderBlockEntity) {
        if (this.updateRenderAttributes) {
            Item item;
            this.updateRenderAttributes = false;
            renderBlockEntity.getOpenersCounter().setForPhysicalBlock(false);
            if (renderBlockEntity.isLocked() != this.isLocked(storageItem)) {
                renderBlockEntity.toggleLock();
            }
            if (renderBlockEntity.shouldShowLock() != this.isLockVisible()) {
                renderBlockEntity.toggleLockVisibility();
            }
            if (renderBlockEntity.shouldShowTier() != this.shouldShowTier()) {
                renderBlockEntity.toggleTierVisiblity();
            }
            renderBlockEntity.getStorageWrapper().getRenderInfo().deserializeFrom(this.getRenderInfoNbt(storageItem));
            if (renderBlockEntity.shouldShowUpgrades() != this.areUpgradesVisible()) {
                renderBlockEntity.toggleUpgradesVisiblity();
            }
            if ((item = storageItem.getItem()) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                renderBlockEntity.getStorageWrapper().setColors(tintableBlockItem.getMainColor(storageItem).orElse(-1), tintableBlockItem.getAccentColor(storageItem).orElse(-1));
            }
            if (renderBlockEntity instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity woodStorage = (WoodStorageBlockEntity)renderBlockEntity;
                WoodStorageBlockItem.getWoodType((DataComponentHolder)storageItem).ifPresent(woodType -> {
                    if (woodStorage.getWoodType() != WoodStorageBlockItem.getWoodType((DataComponentHolder)storageItem)) {
                        woodStorage.setWoodType((WoodType)woodType);
                    }
                });
                boolean isPacked = this.isPacked();
                if (woodStorage.isPacked() != isPacked) {
                    woodStorage.setPacked(isPacked);
                }
            }
            if (renderBlockEntity instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)renderBlockEntity;
                barrel.setDynamicRenderTracker(new DynamicRenderTracker(this, barrel){

                    @Override
                    public boolean isDynamicRenderer() {
                        return true;
                    }
                });
                Map<BarrelMaterial, ResourceLocation> materials = BarrelBlockItem.getMaterials(storageItem);
                if (!barrel.getMaterials().equals(materials)) {
                    barrel.setMaterials(materials);
                }
                if (renderBlockEntity instanceof LimitedBarrelBlockEntity) {
                    LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)renderBlockEntity;
                    if (limitedBarrelBlockEntity.shouldShowFillLevels() != this.areFillLevelsVisible()) {
                        limitedBarrelBlockEntity.toggleFillLevelVisibility();
                    }
                    if (limitedBarrelBlockEntity.shouldShowCounts() != this.areCountsVisible()) {
                        limitedBarrelBlockEntity.toggleCountVisibility();
                    }
                    limitedBarrelBlockEntity.setUseLightInFrontForFrontRender(false);
                }
            }
            if (renderBlockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)renderBlockEntity;
                chestBlockEntity.showUpgradesOnTop = this.showChestUpgradesOnTop;
            }
        }
    }

    public void startOpen(Player player, Entity entity) {
        Level level;
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        if (!player.isSpectator()) {
            this.getOpenersCounter().incrementOpeners(player, entity);
        }
        if ((level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)player, (boolean)true);
        }
        this.sendOpenness(entity);
    }

    private void sendOpenness(Entity entity) {
        CustomPacketPayload opennessPayload = this.createOpennessPayload();
        if (opennessPayload == null) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)opennessPayload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Nullable
    protected abstract CustomPacketPayload createOpennessPayload();

    public void setShouldBeOpen(boolean shouldBeOpen) {
        if (this.getRenderBlockEntity() != null) {
            this.getRenderBlockEntity().setShouldBeOpen(shouldBeOpen);
        }
    }

    public void stopOpen(Player player, Entity entity) {
        if (!(player.level() instanceof ServerLevel)) {
            return;
        }
        if (!player.isSpectator()) {
            this.getOpenersCounter().decrementOpeners(player, entity);
        }
        this.sendOpenness(entity);
    }

    public void tick(Entity entity) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.getOpenersCounter().tick(level, entity);
        if (level.isClientSide()) {
            this.clientTick(level);
            return;
        }
        this.runTickableUpgrades(level);
        this.runPickupOnItemEntities(level);
    }

    protected void runTickableUpgrades(Level level) {
        this.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(this.getEntity(), level, new BlockPos((int)this.getPosition().x(), (int)this.getPosition().y(), (int)this.getPosition().z())));
    }

    private void clientTick(Level level) {
        StorageBlockEntity storageBlockEntity;
        if (this.updateRenderAttributes && this.getRenderBlockEntity() != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), this.getRenderBlockEntity());
        }
        if (level.random.nextInt(10) == 0) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(level, level.random, renderInfo);
        }
        if ((storageBlockEntity = this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
            ChestBlockEntity.lidAnimateTick(chestBlockEntity);
        } else {
            storageBlockEntity = this.getRenderBlockEntity();
            if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                ShulkerBoxBlockEntity.tick(null, BlockPos.ZERO, this.getRenderBlockEntity().getBlockState(), shulkerBoxBlockEntity);
            }
        }
    }

    protected void renderUpgrades(Level level, RandomSource rand, RenderInfo renderInfo) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        renderInfo.getUpgradeClientData().forEach((type, data) -> UpgradeClientRegistry.getUpgradeClientTickHandler((UpgradeClientDataType)type).ifPresent(renderer -> this.clientTickUpgrade((IUpgradeClientTickHandler)renderer, level, rand, (UpgradeClientDataType<?>)type, (IUpgradeClientData)data)));
    }

    private <T extends IUpgradeClientData> void clientTickUpgrade(IUpgradeClientTickHandler<T> renderer, Level level, RandomSource rand, UpgradeClientDataType<?> type, IUpgradeClientData data) {
        type.cast(data).ifPresent(clientData -> renderer.onClientTick(level, rand, vector -> vector.add((float)this.getPosition().x(), (float)this.getPosition().y() + this.getUpgradeRenderYOffset(), (float)this.getPosition().z()), clientData));
    }

    protected float getUpgradeRenderYOffset() {
        return 0.8f;
    }

    private void runPickupOnItemEntities(Level level) {
        AABB aabb = this.getPickupBoundingBox();
        List collidedWithItemEntities = level.getEntitiesOfClass(ItemEntity.class, aabb);
        collidedWithItemEntities.forEach(itemEntity -> {
            if (itemEntity.isAlive()) {
                this.tryToPickup(level, (ItemEntity)itemEntity);
            }
        });
    }

    protected void tryToPickup(Level level, ItemEntity itemEntity) {
        ItemStack remainingStack = itemEntity.getItem().copy();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)this.getStorageWrapper().getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.getCount() < itemEntity.getItem().getCount()) {
            itemEntity.setItem(remainingStack);
        }
    }

    @Nullable
    protected abstract StorageBlockEntity retrieveRenderBlockEntity();

    protected abstract void setLocked(boolean var1);

    protected abstract AABB getPickupBoundingBox();

    public void onStorageItemSynced() {
        StorageBlockEntity renderBlockEntity = this.getRenderBlockEntity();
        if (renderBlockEntity != null && renderBlockEntity.getBlockState().getBlock().asItem() != this.getSyncedStorageStack().getItem()) {
            this.refreshRenderBlockEntity();
        }
        this.updateRenderAttributes = true;
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
    }

    protected abstract void refreshRenderBlockEntity();

    public InteractionResult openContainerMenu(Player player) {
        if (this.isPacked()) {
            return InteractionResult.PASS;
        }
        this.openMenu(player);
        return player.level().isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    protected abstract void openMenu(Player var1);

    @Override
    public void toggleLock() {
        boolean locked;
        ItemStack storageItem = this.getSyncedStorageStack();
        boolean bl = locked = !this.isLocked(storageItem);
        if (this.memorizesItemsWhenLocked()) {
            if (locked) {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlots());
            } else {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
                ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
                InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                    if (stack.isEmpty()) {
                        itemDisplaySettings.itemChanged(slot.intValue());
                    }
                });
            }
        }
        this.setLocked(locked);
        this.setStorageItem(storageItem);
    }

    private boolean memorizesItemsWhenLocked() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack());
    }

    @Override
    public boolean isLocked() {
        return this.isLocked(this.getSyncedStorageStack());
    }

    @Override
    public boolean shouldShowLock() {
        return this.isLockVisible();
    }

    @Override
    public void toggleLockVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.set(ModDataComponents.LOCK_VISIBLE, (Object)(!this.isLockVisible() ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    @Override
    public boolean shouldShowCounts() {
        return this.areCountsVisible();
    }

    @Override
    public void toggleCountVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.set(ModDataComponents.COUNTS_VISIBLE, (Object)(!this.areCountsVisible() ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotCounts() : List.of();
    }

    @Override
    public boolean shouldShowFillLevels() {
        return this.areFillLevelsVisible();
    }

    @Override
    public void toggleFillLevelVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.set(ModDataComponents.FILL_LEVELS_VISIBLE, (Object)(!this.areFillLevelsVisible() ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios() : List.of();
    }

    @Override
    public boolean shouldShowTier() {
        return StorageBlockItem.showsTier(this.getSyncedStorageStack());
    }

    @Override
    public void toggleTierVisiblity() {
        ItemStack storageItem;
        StorageBlockItem.setShowsTier(storageItem, !StorageBlockItem.showsTier(storageItem = this.getSyncedStorageStack()));
        this.setStorageItem(storageItem);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.areUpgradesVisible();
    }

    @Override
    public void toggleUpgradesVisiblity() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.set(ModDataComponents.UPGRADES_VISIBLE, (Object)(!this.areUpgradesVisible() ? 1 : 0));
        this.setStorageItem(storageItem);
    }

    public boolean isOpen() {
        return this.getOpenersCounter().getOpenerCount() > 0;
    }

    @Override
    public void setMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        ItemStack storageItem = this.getSyncedStorageStack();
        if (this.isBarrel()) {
            BarrelBlockItem.setMaterials(storageItem, materials);
            this.setStorageItem(storageItem);
        }
    }

    @Override
    public Map<BarrelMaterial, ResourceLocation> getMaterials() {
        return this.isBarrel() ? BarrelBlockItem.getMaterials(this.getSyncedStorageStack()) : Collections.emptyMap();
    }

    @Override
    public boolean canHoldMaterials() {
        return this.isBarrel();
    }

    public StorageHolderBase getMainStorageHolder() {
        return this;
    }

    public Optional<StorageHolderBase> getAuxiliaryStorageHolder() {
        return Optional.empty();
    }
}

