/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;

public class TranslucentVertexConsumer
implements VertexConsumer {
    public static final RenderType TRANSLUCENT = RenderType.entityTranslucent((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
    private final VertexConsumer delegate;
    private static BiFunction<MultiBufferSource, Integer, VertexConsumer> factory = TranslucentVertexConsumer::new;
    private final int defaultA;

    public TranslucentVertexConsumer(VertexConsumer delegate, int alpha) {
        this.delegate = delegate;
        this.defaultA = alpha;
    }

    public TranslucentVertexConsumer(MultiBufferSource buffer, int alpha) {
        this(buffer.getBuffer(TRANSLUCENT), alpha);
    }

    static MultiBufferSource wrapBuffer(MultiBufferSource buffer, int alpha) {
        return renderType -> factory.apply(buffer, alpha);
    }

    public static VertexConsumer getVertexConsumer(MultiBufferSource buffer, int alpha) {
        return factory.apply(buffer, alpha);
    }

    public void addVertex(float x, float y, float z, int color, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        int modifiedColor = this.defaultA << 24 | color & 0xFFFFFF;
        super.addVertex(x, y, z, modifiedColor, texU, texV, overlayUV, lightmapUV, normalX, normalY, normalZ);
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        return this.delegate.addVertex(x, y, z);
    }

    public VertexConsumer setColor(int red, int green, int blue, int alpha) {
        return this.delegate.setColor(red, green, blue, this.defaultA);
    }

    public VertexConsumer setUv(float u, float v) {
        return this.delegate.setUv(u, v);
    }

    public VertexConsumer setUv1(int u1, int v1) {
        return this.delegate.setUv1(u1, v1);
    }

    public VertexConsumer setUv2(int u2, int v2) {
        return this.delegate.setUv2(u2, v2);
    }

    public VertexConsumer setNormal(float normalX, float normalY, float normalZ) {
        return this.delegate.setNormal(normalX, normalY, normalZ);
    }
}

