/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.StringRepresentable;

public enum IOMode implements StringRepresentable
{
    PUSH("push"),
    PULL("pull"),
    PUSH_PULL("push_pull"),
    OFF("off"),
    DISABLED("disabled");

    private final String name;
    private static final Map<String, IOMode> NAME_VALUES;
    private static final IOMode[] VALUES;

    private IOMode(String name) {
        this.name = name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public IOMode next() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    public static IOMode fromName(String name) {
        return NAME_VALUES.getOrDefault(name, OFF);
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (IOMode value : IOMode.values()) {
            builder.put((Object)value.getSerializedName(), (Object)value);
        }
        NAME_VALUES = builder.build();
        VALUES = IOMode.values();
    }
}

