/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public class ChestBlockEntity
extends WoodStorageBlockEntity {
    public static final String STORAGE_TYPE = "chest";
    public static final String DOUBLE_CHEST_MAIN_POS_TAG = "doubleMainPos";
    private final ChestLidController chestLidController = new ChestLidController();
    @Nullable
    private BlockPos doubleMainPos = null;
    public boolean showUpgradesOnTop = false;
    private final SophisticatedOpenersCounter openersCounter = new SophisticatedOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            if (state.getValue(ChestBlock.TYPE) != ChestType.LEFT) {
                ChestBlockEntity.this.playSound(state, SoundEvents.CHEST_OPEN);
            }
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            if (state.getValue(ChestBlock.TYPE) != ChestType.LEFT) {
                ChestBlockEntity.this.playSound(state, SoundEvents.CHEST_CLOSE);
            }
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousOpenCount, int openCount) {
            ChestBlockEntity.this.chestLidController.shouldBeOpen(openCount > 0);
        }

        protected boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)abstractContainerMenu;
                return storageContainerMenu.getStorageBlockEntity() == ChestBlockEntity.this.getMainChestBlockEntity();
            }
            return false;
        }

        @Override
        public void incrementOpeners(Player player, Level level, BlockPos pos, BlockState state) {
            super.incrementOpeners(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.this.runOnTheOtherPart(level, pos, (blockEntity, neighborPos) -> blockEntity.openersCounter.incrementOpeners(player, level, (BlockPos)neighborPos, level.getBlockState(neighborPos)));
            }
        }

        public void decrementOpeners(Player player, Level level, BlockPos pos, BlockState state) {
            super.decrementOpeners(player, level, pos, state);
            if (ChestBlockEntity.this.isMainChest()) {
                ChestBlockEntity.this.runOnTheOtherPart(level, pos, (blockEntity, neighborPos) -> blockEntity.openersCounter.decrementOpeners(player, level, (BlockPos)neighborPos, level.getBlockState(neighborPos)));
            }
        }
    };
    private boolean isDestroyedByPlayer = false;

    public void joinWithChest(ChestBlockEntity mainBE) {
        this.setMainPos(mainBE.getBlockPos());
        this.expandAndMoveItemsAndSettings(mainBE);
        this.removeFromController();
        this.setNotLinked();
        this.tryToAddToController();
        this.invalidateCapabilities();
    }

    public ChestLidController getChestLidController() {
        return this.chestLidController;
    }

    public void setMainPos(BlockPos doubleMainPos) {
        this.doubleMainPos = doubleMainPos;
        this.setChanged();
    }

    private void expandAndMoveItemsAndSettings(ChestBlockEntity mainBE) {
        int n;
        InventoryHandler mainInventoryHandler = mainBE.getStorageWrapper().getInventoryHandler();
        int originalNumberOfSlots = mainInventoryHandler.getSlots();
        InventoryHandler thisInventoryHandler = this.getStorageWrapper().getInventoryHandler();
        Block block = mainBE.getBlockState().getBlock();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            n = storageBlock.getNumberOfInventorySlots();
        } else {
            n = 0;
        }
        int inventorySlotDiff = 2 * n - mainInventoryHandler.getSlots();
        mainBE.changeStorageSize(inventorySlotDiff, 0);
        ChestBlockEntity.moveStacksToMain(thisInventoryHandler, mainInventoryHandler, originalNumberOfSlots);
        this.copySettings(this, mainBE, 0, originalNumberOfSlots);
        this.deleteSettingsFromSlot(this, 0);
        WorldHelper.notifyBlockUpdate((BlockEntity)mainBE);
    }

    private void copySettings(ChestBlockEntity from, ChestBlockEntity to, int startFromSlot, int slotOffset) {
        SettingsHandler mainSettingsHandler = to.getStorageWrapper().getSettingsHandler();
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> this.copyCategorySettings((ISettingsCategory)category, (ISettingsCategory<?>)mainSettingsHandler.getTypeCategory(category.getClass()), startFromSlot, slotOffset));
    }

    private void deleteSettingsFromSlot(ChestBlockEntity from, int startFromSlot) {
        from.getStorageWrapper().getSettingsHandler().getSettingsCategories().forEach((name, category) -> category.deleteSlotSettingsFrom(startFromSlot));
    }

    private <T extends ISettingsCategory<?>> void copyCategorySettings(ISettingsCategory<T> category, ISettingsCategory<?> mainCategory, int startFromSlot, int slotOffset) {
        category.copyTo(mainCategory, startFromSlot, slotOffset);
    }

    private static void moveStacksToMain(InventoryHandler thisInventoryHandler, InventoryHandler mainInventoryHandler, int originalNumberOfSlots) {
        int slot;
        int thisSlots = thisInventoryHandler.getSlots();
        int mainSlots = mainInventoryHandler.getSlots();
        for (slot = 0; slot < thisSlots && slot + originalNumberOfSlots < mainSlots; ++slot) {
            ItemStack slotStack = thisInventoryHandler.getSlotStack(slot);
            if (slotStack.isEmpty()) continue;
            mainInventoryHandler.setStackInSlot(slot + originalNumberOfSlots, slotStack);
        }
        for (slot = 0; slot < thisSlots; ++slot) {
            thisInventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
        }
    }

    public void syncTogglesFrom(ChestBlockEntity chestBE) {
        if (chestBE.isLocked() != this.isLocked()) {
            this.toggleJustMyLock();
        }
        if (chestBE.shouldShowLock() != this.shouldShowLock()) {
            this.toggleJustMyLockVisibility();
        }
        if (chestBE.shouldShowTier() != this.shouldShowTier()) {
            this.toggleJustMyTierVisiblity();
        }
        if (chestBE.shouldShowUpgrades() != this.shouldShowUpgrades()) {
            this.toggleJustMyUpgradesVisiblity();
        }
    }

    @Override
    public void dropContents() {
        if (this.isDestroyedByPlayer && this.getBlockState().getValue(ChestBlock.TYPE) != ChestType.SINGLE) {
            if (this.doubleMainPos != null) {
                this.moveMyStacksFromMain();
            } else {
                this.moveOtherPartStacksToIt();
            }
        }
        super.dropContents();
    }

    @Override
    public void onNeighborChange(BlockPos neighborPos) {
        Direction direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.getMainStorageWrapper().getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.level, this.worldPosition, direction));
    }

    private void moveOtherPartStacksToIt() {
        this.runOnTheOtherPart(this.level, this.getBlockPos(), (be, pos) -> {
            int firstIndex;
            be.removeDoubleMainPos();
            InventoryHandler mainInventoryHandler = this.getStorageWrapper().getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlots() / 2; slot < mainInventoryHandler.getSlots(); ++slot) {
                ItemStack slotStack = mainInventoryHandler.getSlotStack(slot);
                be.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, slotStack.split(slotStack.getMaxStackSize()));
            }
            this.copySettings(this, (ChestBlockEntity)be, firstIndex, -firstIndex);
            be.removeControllerPos();
            be.tryToAddToController();
            be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((BlockEntity)be);
        });
    }

    private void moveMyStacksFromMain() {
        this.level.getBlockEntity(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBE -> {
            int n;
            int firstIndex;
            StorageWrapper mainStorageWrapper = mainBE.getStorageWrapper();
            InventoryHandler mainInventoryHandler = mainStorageWrapper.getInventoryHandler();
            for (int slot = firstIndex = mainInventoryHandler.getSlots() / 2; slot < mainInventoryHandler.getSlots(); ++slot) {
                this.getStorageWrapper().getInventoryHandler().setSlotStack(slot - firstIndex, mainInventoryHandler.getSlotStack(slot));
                mainInventoryHandler.setSlotStack(slot, ItemStack.EMPTY);
            }
            Block patt0$temp = mainBE.getBlockState().getBlock();
            if (patt0$temp instanceof StorageBlockBase) {
                StorageBlockBase storageBlock = (StorageBlockBase)patt0$temp;
                n = storageBlock.getNumberOfInventorySlots();
            } else {
                n = 0;
            }
            int inventorySlotDiff = n - mainInventoryHandler.getSlots();
            mainBE.changeStorageSize(inventorySlotDiff, 0);
            this.deleteSettingsFromSlot((ChestBlockEntity)mainBE, firstIndex);
            ((ItemDisplaySettingsCategory)mainStorageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
            mainStorageWrapper.getUpgradeHandler().refreshUpgradeWrappers();
            WorldHelper.notifyBlockUpdate((BlockEntity)mainBE);
        });
    }

    public boolean hasStorageData() {
        return this.isMainChest();
    }

    @Override
    public SophisticatedOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    public ChestBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get());
    }

    public static void lidAnimateTick(ChestBlockEntity chestBlockEntity) {
        chestBlockEntity.chestLidController.tickLid();
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    @Override
    public void toggleLock() {
        super.toggleLock();
        if (this.level != null) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> be.toggleJustMyLock());
        }
    }

    private void toggleJustMyLock() {
        super.toggleLock();
    }

    @Override
    public void toggleLockVisibility() {
        super.toggleLockVisibility();
        if (this.level != null) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> be.toggleJustMyLockVisibility());
        }
    }

    private void toggleJustMyLockVisibility() {
        super.toggleLockVisibility();
    }

    @Override
    public void toggleTierVisiblity() {
        super.toggleTierVisiblity();
        if (this.level != null) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> be.toggleJustMyTierVisiblity());
        }
    }

    private void toggleJustMyTierVisiblity() {
        super.toggleTierVisiblity();
    }

    @Override
    public void toggleUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
        if (this.level != null) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> be.toggleJustMyUpgradesVisiblity());
        }
    }

    private void toggleJustMyUpgradesVisiblity() {
        super.toggleUpgradesVisiblity();
    }

    private void runOnTheOtherPart(Level level, BlockPos pos, BiConsumer<ChestBlockEntity, BlockPos> execute) {
        ChestType chestType = (ChestType)this.getBlockState().getValue(ChestBlock.TYPE);
        if (chestType == ChestType.SINGLE) {
            return;
        }
        Direction facing = (Direction)this.getBlockState().getValue(ChestBlock.FACING);
        BlockPos neighborPos = this.isMainChest() ? pos.relative(facing.getCounterClockWise()) : pos.relative(facing.getClockWise());
        level.getBlockEntity(neighborPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(chestBlockEntity -> execute.accept((ChestBlockEntity)chestBlockEntity, neighborPos));
    }

    public void removeDoubleMainPos() {
        this.doubleMainPos = null;
    }

    @Override
    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        if (this.level == null) {
            return null;
        }
        if (this.doubleMainPos != null) {
            return this.level.getBlockEntity(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(be -> be.getExternalItemHandler(side)).orElse(null);
        }
        return super.getExternalItemHandler(side);
    }

    public boolean isMainChest() {
        return this.doubleMainPos == null;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadSynchronizedData(tag, registries);
        this.doubleMainPos = NBTHelper.getLong((CompoundTag)tag, (String)DOUBLE_CHEST_MAIN_POS_TAG).map(BlockPos::of).orElse(null);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (this.doubleMainPos != null) {
            tag.putLong(DOUBLE_CHEST_MAIN_POS_TAG, this.doubleMainPos.asLong());
        }
    }

    @Override
    public CompoundTag getStorageContentsTag() {
        CompoundTag tag = super.getStorageContentsTag();
        tag.remove(DOUBLE_CHEST_MAIN_POS_TAG);
        return tag;
    }

    @Override
    protected ItemStack addWrappedStorageStackData(ItemStack cloneItemStack, BlockState state) {
        ItemStack ret = super.addWrappedStorageStackData(cloneItemStack, state);
        if (state.getValue(ChestBlock.TYPE) != ChestType.SINGLE) {
            ChestBlockItem.setDoubleChest(ret, true);
        }
        return ret;
    }

    public StorageWrapper getMainStorageWrapper() {
        if (this.doubleMainPos != null) {
            return this.level.getBlockEntity(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(StorageBlockEntity::getStorageWrapper).orElseGet(this::getStorageWrapper);
        }
        return this.getStorageWrapper();
    }

    @Nullable
    public ChestBlockEntity getMainChestBlockEntity() {
        if (this.doubleMainPos != null) {
            return this.level.getBlockEntity(this.doubleMainPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).orElse(null);
        }
        return this;
    }

    @Override
    public boolean canBeLinked() {
        return this.isMainChest() && super.canBeLinked();
    }

    public void dropSecondPartContents(ChestBlock chestBlock, BlockPos dropPosition) {
        InventoryHandler invHandler = this.getStorageWrapper().getInventoryHandler();
        ArrayList<ItemStack> dropItems = new ArrayList<ItemStack>();
        for (int slot = chestBlock.getNumberOfInventorySlots(); slot < invHandler.getSlots(); ++slot) {
            ItemStack slotStack = invHandler.getSlotStack(slot);
            if (slotStack.isEmpty()) continue;
            dropItems.add(slotStack.copy());
        }
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().schedule((Runnable)new TickTask(serverLevel.getServer().getTickCount(), () -> dropItems.forEach(itemStack -> Containers.dropItemStack((Level)serverLevel, (double)dropPosition.getX(), (double)dropPosition.getY(), (double)dropPosition.getZ(), (ItemStack)itemStack))));
        }
        int inventorySlotDiff = chestBlock.getNumberOfInventorySlots() - invHandler.getSlots();
        this.changeStorageSize(inventorySlotDiff, 0);
        this.deleteSettingsFromSlot(this, chestBlock.getNumberOfInventorySlots());
        ((ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).setDisplaySide(DisplaySide.FRONT);
        this.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void setDestroyedByPlayer() {
        this.isDestroyedByPlayer = true;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (!this.isBeingUpgraded() && this.getBlockState().getValue(ChestBlock.TYPE) == ChestType.SINGLE) {
            Block block = this.getBlockState().getBlock();
            if (block instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)block;
                if (this.getStorageWrapper().getInventoryHandler().getSlots() > chestBlock.getNumberOfInventorySlots()) {
                    this.dropSecondPartContents(chestBlock, this.worldPosition);
                }
            }
            if (!this.isMainChest()) {
                this.removeDoubleMainPos();
            }
        }
    }

    public void changeSlots(int newSlots) {
        if (this.hasStorageData()) {
            super.changeSlots(newSlots);
        }
    }

    @Override
    public void setShouldBeOpen(boolean shouldBeOpen) {
        this.chestLidController.shouldBeOpen(shouldBeOpen);
        if (this.level != null) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> be.chestLidController.shouldBeOpen(shouldBeOpen));
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        if (this.getBlockState().getValue(ChestBlock.TYPE) != ChestType.SINGLE && this.isPacked()) {
            this.level.removeBlock(pos.relative(ChestBlock.getConnectedDirection(state)), false);
        }
    }

    public BlockPos getMainPos() {
        return this.doubleMainPos != null ? this.doubleMainPos : this.worldPosition;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && this.getBlockState().getValue(ChestBlock.TYPE) != ChestType.SINGLE && this.isMainChest()) {
            this.runOnTheOtherPart(this.level, this.worldPosition, (be, pos) -> this.level.updateNeighbourForOutputSignal(pos, be.getBlockState().getBlock()));
        }
    }
}

