/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.extensions.IDataComponentHolderExtension;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.util.IDoubleBlock;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ChestBlock
extends WoodStorageBlockBase
implements SimpleWaterloggedBlock,
IDoubleBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier) {
        this(numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier, 2.5f);
    }

    public ChestBlock(Supplier<Integer> numberOfInventorySlotsSupplier, Supplier<Integer> numberOfUpgradeSlotsSupplier, float explosionResistance) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).strength(2.5f, explosionResistance).sound(SoundType.WOOD), numberOfInventorySlotsSupplier, numberOfUpgradeSlotsSupplier);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TICKING, (Comparable)Boolean.valueOf(false))).setValue(TYPE, (Comparable)ChestType.SINGLE));
    }

    public static boolean isChestBlockedAt(LevelAccessor level, BlockPos pos) {
        return ChestBlock.isBlockedChestByBlock((BlockGetter)level, pos) || ChestBlock.isCatSittingOnChest(level, pos);
    }

    private static boolean isBlockedChestByBlock(BlockGetter level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return level.getBlockState(blockpos).isRedstoneConductor(level, blockpos);
    }

    public static Direction getConnectedDirection(BlockState blockState) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        return blockState.getValue(TYPE) == ChestType.LEFT ? direction.getClockWise() : direction.getCounterClockWise();
    }

    private static boolean isCatSittingOnChest(LevelAccessor level, BlockPos pos) {
        List list = level.getEntitiesOfClass(Cat.class, new AABB((double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 1.0));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (level.getBlockEntity(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(StorageBlockEntity::isBeingUpgraded).orElse(false).booleanValue()) {
            return state;
        }
        if (Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED))) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (this.isSameChest(facingState, level, currentPos, facingPos) && facing.getAxis().isHorizontal()) {
            ChestType chesttype = (ChestType)facingState.getValue(TYPE);
            if (state.getValue(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.getValue((Property)FACING) == facingState.getValue((Property)FACING) && ChestBlock.getConnectedDirection(facingState) == facing.getOpposite()) {
                level.getBlockEntity(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                    Block patt0$temp = state.getBlock();
                    if (patt0$temp instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt0$temp;
                        if (be.getStorageWrapper().getInventoryHandler().getSlots() <= chestBlock.getNumberOfInventorySlots()) {
                            ChestBlock.joinWithChest(level, facingPos, chesttype.getOpposite(), be);
                        }
                    }
                    if (be.isMainChest()) {
                        be.getStorageWrapper().getUpgradeHandler().refreshUpgradeWrappers();
                    }
                });
                return (BlockState)state.setValue(TYPE, (Comparable)chesttype.getOpposite());
            }
        } else if (ChestBlock.getConnectedDirection(state) == facing) {
            level.getBlockEntity(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                if (!(level.isClientSide() || be.isBeingUpgraded() || be.isPacked())) {
                    Block patt0$temp;
                    if (be.isMainChest() && (patt0$temp = state.getBlock()) instanceof ChestBlock) {
                        ChestBlock chestBlock = (ChestBlock)patt0$temp;
                        be.dropSecondPartContents(chestBlock, facingPos);
                    } else if (!be.isMainChest()) {
                        be.removeDoubleMainPos();
                    }
                }
            });
            return (BlockState)state.setValue(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    private boolean isSameChest(BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!facingState.is((Block)this)) {
            return false;
        }
        return level.getBlockEntity(facingPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).flatMap(facingBE -> level.getBlockEntity(currentPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(currentBE -> currentBE.isPacked() == facingBE.isPacked() && currentBE.getStorageWrapper().getMainColor() == facingBE.getStorageWrapper().getMainColor() && currentBE.getStorageWrapper().getAccentColor() == facingBE.getStorageWrapper().getAccentColor() && (currentBE.getWoodType().isEmpty() && facingBE.getWoodType().isEmpty() || currentBE.getWoodType().isPresent() && facingBE.getWoodType().isPresent() && currentBE.getWoodType().get() == facingBE.getWoodType().get()))).orElse(false);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(TYPE) == ChestType.SINGLE) {
            return AABB;
        }
        return switch (ChestBlock.getConnectedDirection(state)) {
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            default -> NORTH_AABB;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        ItemStack chestBeingPlaced = context.getItemInHand();
        if (ChestBlockItem.isDoubleChest(chestBeingPlaced)) {
            BlockPos otherPartPos = context.getClickedPos().relative(context.getHorizontalDirection().getClockWise());
            Level level = context.getLevel();
            if (!level.getBlockState(otherPartPos).canBeReplaced(context) || !level.getWorldBorder().isWithinBounds(otherPartPos)) {
                return null;
            }
        }
        Direction direction = context.getHorizontalDirection().getOpposite();
        StackStorageWrapper wrapper = StackStorageWrapper.fromStack((HolderLookup.Provider)context.getLevel().registryAccess(), chestBeingPlaced);
        return this.getStateForPlacement(context, direction, fluidstate, StorageBlockItem.getMainColorFromComponentHolder((IDataComponentHolderExtension)chestBeingPlaced).orElse(-1), StorageBlockItem.getAccentColorFromComponentHolder((IDataComponentHolderExtension)chestBeingPlaced).orElse(-1), WoodStorageBlockItem.getWoodType((IDataComponentHolderExtension)chestBeingPlaced).orElse(WoodType.ACACIA), wrapper.hasContents() && InventoryHelper.isEmpty((IItemHandler)wrapper.getUpgradeHandler()));
    }

    private BlockState getStateForPlacement(BlockPlaceContext context, Direction direction, FluidState fluidstate, int mainColor, int accentColor, WoodType woodType, boolean itemHasNoUpgrades) {
        Direction partnerFacing;
        ChestType chestType = ChestType.SINGLE;
        Direction clickedFace = context.getClickedFace();
        boolean isHoldingSneak = context.isSecondaryUseActive();
        if (clickedFace.getAxis().isHorizontal() && isHoldingSneak && (partnerFacing = this.candidatePartnerFacing(context, clickedFace.getOpposite(), mainColor, accentColor, woodType, itemHasNoUpgrades)) != null && partnerFacing.getAxis() != clickedFace.getAxis()) {
            direction = partnerFacing;
            ChestType chestType2 = chestType = partnerFacing.getCounterClockWise() == clickedFace.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chestType == ChestType.SINGLE && !isHoldingSneak) {
            if (direction == this.candidatePartnerFacing(context, direction.getClockWise(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = ChestType.LEFT;
            } else if (direction == this.candidatePartnerFacing(context, direction.getCounterClockWise(), mainColor, accentColor, woodType, itemHasNoUpgrades)) {
                chestType = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue(TYPE, (Comparable)chestType)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction, int mainColor, int accentColor, WoodType woodType, boolean itemHasNoUpgrades) {
        BlockPos neighborChestPos = context.getClickedPos().relative(direction);
        BlockState blockstate = context.getLevel().getBlockState(neighborChestPos);
        if (!blockstate.is((Block)this) || blockstate.getValue(TYPE) != ChestType.SINGLE) {
            return null;
        }
        if (context.getLevel().getBlockEntity(neighborChestPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).map(be -> mainColor == be.getStorageWrapper().getMainColor() && accentColor == be.getStorageWrapper().getAccentColor() && woodType == be.getWoodType().orElse(WoodType.ACACIA) && (itemHasNoUpgrades || InventoryHelper.isEmpty((IItemHandler)be.getStorageWrapper().getUpgradeHandler()))).orElse(false).booleanValue()) {
            return (Direction)blockstate.getValue((Property)FACING);
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? ChestBlock.createTickerHelper(blockEntityType, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get(), (l, p, s, be) -> ChestBlockEntity.lidAnimateTick(be)) : super.getTicker(level, state, blockEntityType);
    }

    public FluidState getFluidState(BlockState state) {
        return Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED)) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(b -> {
            if (!b.isMainChest()) {
                BlockPos mainChestPos = pos.relative(ChestBlock.getConnectedDirection(state));
                b = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)mainChestPos, ChestBlockEntity.class).orElse(b);
            }
            if (b.isPacked()) {
                return ItemInteractionResult.FAIL;
            }
            if (level.isClientSide || hand == InteractionHand.OFF_HAND) {
                return ItemInteractionResult.SUCCESS;
            }
            if (this.tryItemInteraction(player, hand, (WoodStorageBlockEntity)b, stack, (Direction)state.getValue((Property)FACING), hitResult)) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (ChestBlock.isChestBlockedAt((LevelAccessor)level, pos) || state.getValue(TYPE) != ChestType.SINGLE && ChestBlock.isChestBlockedAt((LevelAccessor)level, pos.relative(ChestBlock.getConnectedDirection(state)))) {
            return InteractionResult.PASS;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(b -> {
            BlockPos mainChestPos;
            if (!b.isMainChest()) {
                mainChestPos = pos.relative(ChestBlock.getConnectedDirection(state));
                b = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)mainChestPos, ChestBlockEntity.class).orElse(b);
            } else {
                mainChestPos = pos;
            }
            if (b.isPacked()) {
                return InteractionResult.PASS;
            }
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_CHEST));
            player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, mainChestPos), b.getDisplayName()), mainChestPos);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        ChestType chestType;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (ChestBlockItem.isDoubleChest(stack) && !level.isClientSide()) {
            BlockPos otherPartPos = pos.relative(((Direction)state.getValue((Property)FACING)).getCounterClockWise());
            level.setBlock(otherPartPos, (BlockState)state.setValue(TYPE, (Comparable)ChestType.LEFT), 3);
            level.getBlockEntity(otherPartPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                this.setRenderBlockRenderProperties(stack, (WoodStorageBlockEntity)be);
                be.setMainPos(pos);
                be.tryToAddToController();
            });
        }
        if ((chestType = (ChestType)state.getValue(TYPE)) == ChestType.SINGLE || level.isClientSide()) {
            return;
        }
        BlockPos otherPos = pos.relative(ChestBlock.getConnectedDirection(state));
        ChestBlock.joinChests((LevelAccessor)level, pos, otherPos, chestType);
        state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    private static void joinChests(LevelAccessor level, BlockPos pos, BlockPos otherPos, ChestType currentChestType) {
        level.getBlockEntity(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(currentBE -> ChestBlock.joinWithChest(level, otherPos, currentChestType, currentBE));
    }

    private static void joinWithChest(LevelAccessor level, BlockPos otherPos, ChestType currentChestType, ChestBlockEntity currentBE) {
        level.getBlockEntity(otherPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(otherBE -> {
            if (InventoryHelper.isEmpty((IItemHandler)currentBE.getStorageWrapper().getUpgradeHandler()) && (currentChestType == ChestType.LEFT || !InventoryHelper.isEmpty((IItemHandler)otherBE.getStorageWrapper().getUpgradeHandler()))) {
                currentBE.joinWithChest((ChestBlockEntity)otherBE);
                currentBE.syncTogglesFrom((ChestBlockEntity)otherBE);
            } else {
                otherBE.joinWithChest(currentBE);
                otherBE.syncTogglesFrom(currentBE);
            }
        });
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (state.getValue(TYPE) != ChestType.SINGLE) {
            level.getBlockEntity(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                be.setDestroyedByPlayer();
                if ((be.isPacked() || Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) && !be.isMainChest()) {
                    BlockPos otherPartPos = pos.relative(ChestBlock.getConnectedDirection(state));
                    level.getBlockEntity(otherPartPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBe -> {
                        be.getStorageWrapper().load(mainBe.getStorageWrapper().save(new CompoundTag()));
                        CompoundTag contentsTag = new CompoundTag();
                        contentsTag.put("contents", (Tag)new CompoundTag());
                        mainBe.getStorageWrapper().load(contentsTag);
                    });
                }
            });
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getValue(TYPE) != ChestType.SINGLE) {
            level.getBlockEntity(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> {
                if (be.isPacked()) {
                    level.removeBlock(pos.relative(ChestBlock.getConnectedDirection(state)), false);
                }
            });
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        ChestBlockEntity chestBlockEntity;
        if (be instanceof ChestBlockEntity && (chestBlockEntity = (ChestBlockEntity)be).isPacked() && be.getBlockState().getValue(TYPE) != ChestType.SINGLE) {
            super.addDropData(stack, be);
            ChestBlockItem.setDoubleChest(stack, true);
        } else {
            super.addDropData(stack, be);
        }
    }

    @Override
    protected void packStorage(Player player, InteractionHand hand, WoodStorageBlockEntity b, ItemStack stackInHand) {
        super.packStorage(player, hand, b, stackInHand);
        if (b.getBlockState().getValue(TYPE) == ChestType.SINGLE) {
            return;
        }
        player.level().getBlockEntity(b.getBlockPos().relative(ChestBlock.getConnectedDirection(b.getBlockState())), ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(be -> super.packStorage(player, hand, (WoodStorageBlockEntity)be, stackInHand));
    }

    @Override
    @Nullable
    public ChestBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ChestBlockEntity(pos, state);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, TICKING, TYPE});
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(StorageBlockEntity::recheckOpen);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue((Property)FACING);
    }

    @Override
    public List<BlockPos> getNeighborPos(BlockState state, BlockPos origin, Direction facing) {
        if (state.getValue(TYPE) == ChestType.SINGLE) {
            return List.of(origin.relative(facing));
        }
        Direction connectedDirection = ChestBlock.getConnectedDirection(state);
        if (connectedDirection == facing) {
            return List.of(origin.relative(facing).relative(facing));
        }
        if (connectedDirection.getOpposite() == facing) {
            return List.of(origin.relative(facing));
        }
        return List.of(origin.relative(facing), origin.relative(connectedDirection).relative(facing));
    }

    public Optional<BlockPos> getOtherPosition(BlockState state, BlockPos pos) {
        return state.getValue(TYPE) == ChestType.SINGLE ? Optional.empty() : Optional.of(pos.relative(ChestBlock.getConnectedDirection(state)));
    }

    @Override
    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (state.getValue(TYPE) != ChestType.SINGLE && pos.relative(ChestBlock.getConnectedDirection(state)).equals((Object)neighbor)) {
            return;
        }
        super.onNeighborChange(state, level, pos, neighbor);
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.entityInside(state, level, pos, entity);
        if (!level.isClientSide && entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).ifPresent(be -> this.tryToPickup(level, itemEntity, be.getMainStorageWrapper()));
        }
    }

    @Override
    protected Vector3f getMiddleFacePoint(BlockState state, BlockPos pos, Direction facing, Vector3f vector) {
        Vector3f point = new Vector3f((Vector3fc)vector);
        float xOffset = 0.0f;
        ChestType type = (ChestType)state.getValue(TYPE);
        if (type == ChestType.LEFT) {
            xOffset = -0.5f;
        } else if (type == ChestType.RIGHT) {
            xOffset = 0.5f;
        }
        point.add(xOffset, 0.0f, 0.6f);
        point.rotate((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
        point.rotate((Quaternionfc)facing.getRotation());
        point.add((float)pos.getX() + 0.5f, (float)pos.getY() + 0.5f, (float)pos.getZ() + 0.5f);
        return point;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public boolean tryFillUpgrades(Player player, InteractionHand hand, Level level, BlockPos pos, ItemStack itemInHand) {
        return super.tryFillUpgrades(player, hand, level, WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(ChestBlockEntity::getMainPos).orElse(pos), itemInHand);
    }

    @Override
    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ChestBlockEntity.class).map(be -> InventoryHelper.getAnalogOutputSignal((ITrackedContentsItemHandler)be.getMainStorageWrapper().getInventoryForInputOutput())).orElse(0);
    }
}

