/*
 * Decompiled with CFR 0.152.
 */
package cc.modlabs.crashfixer.mixin;

import cc.modlabs.crashfixer.Constants;
import net.minecraft.class_2394;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_702.class})
public class ParticleManagerMixin {
    @Unique
    private int crashfixer$spawnedThisTick = 0;
    @Unique
    private boolean crashfixer$warnedThisTick = false;
    @Unique
    private static final int CRASHFIXER_MAX_PARTICLES_PER_TICK = Integer.getInteger("crashfixer.maxParticlesPerTick", 500);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void crashfixer$resetCounter(CallbackInfo ci) {
        this.crashfixer$spawnedThisTick = 0;
        this.crashfixer$warnedThisTick = false;
    }

    @Inject(method={"Lnet/minecraft/client/particle/ParticleManager;addParticle(Lnet/minecraft/client/particle/Particle;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void crashfixer$throttleParticles_obj(class_703 particle, CallbackInfo ci) {
        if (this.crashfixer$spawnedThisTick >= CRASHFIXER_MAX_PARTICLES_PER_TICK) {
            if (!this.crashfixer$warnedThisTick) {
                this.crashfixer$warnedThisTick = true;
                Constants.logger.warn("Particle cap (" + CRASHFIXER_MAX_PARTICLES_PER_TICK + ") reached; throttling further spawns this tick");
            }
            ci.cancel();
            return;
        }
        ++this.crashfixer$spawnedThisTick;
    }

    @Inject(method={"Lnet/minecraft/client/particle/ParticleManager;addParticle(Lnet/minecraft/particle/ParticleEffect;DDDDDD)Lnet/minecraft/client/particle/Particle;"}, at={@At(value="HEAD")}, cancellable=true)
    private void crashfixer$throttleParticles_effect(class_2394 effect, double x, double y, double z, double vx, double vy, double vz, CallbackInfoReturnable<class_703> cir) {
        if (this.crashfixer$spawnedThisTick >= CRASHFIXER_MAX_PARTICLES_PER_TICK) {
            if (!this.crashfixer$warnedThisTick) {
                this.crashfixer$warnedThisTick = true;
                Constants.logger.warn("Particle cap (" + CRASHFIXER_MAX_PARTICLES_PER_TICK + ") reached; throttling further spawns this tick");
            }
            cir.setReturnValue(null);
            return;
        }
        ++this.crashfixer$spawnedThisTick;
    }
}

