/*
 * Decompiled with CFR 0.152.
 */
package cc.modlabs.crashfixer.mixin;

import cc.modlabs.crashfixer.Constants;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1140.class})
public class SoundSystemMixin {
    @Unique
    private static final int CLEANUP_THRESHOLD = Integer.getInteger("crashfixer.sound.cleanupThreshold", 4096);
    private static final long WINDOW_NANOS = Long.getLong("crashfixer.sound.windowNanos", 20000000L);
    private static final int MAX_PLAYS_PER_WINDOW = Integer.getInteger("crashfixer.sound.maxPerWindow", 24);
    private static final int MAX_SAME_SOUND_PER_WINDOW = Integer.getInteger("crashfixer.sound.maxSamePerWindow", 6);
    @Unique
    private static final int CRASHFIXER_MAX_SOUNDS_PER_TICK = Integer.getInteger("crashfixer.sound.maxPerTick", 256);
    @Unique
    private static final int CRASHFIXER_MAX_BLOCK_SOUNDS_PER_TICK = Integer.getInteger("crashfixer.sound.blocks.maxPerTick", 24);
    private static final Deque<Long> recentGlobalPlays = new ArrayDeque<Long>();
    private static final Map<class_2960, Deque<Long>> recentById = new ConcurrentHashMap<class_2960, Deque<Long>>();
    @Unique
    private int crashfixer$soundsThisTick = 0;
    @Unique
    private boolean crashfixer$warnedThisTick = false;
    @Unique
    private int crashfixer$blockSoundsThisTick = 0;
    @Unique
    private boolean crashfixer$warnedBlockThisTick = false;

    private static void prune(Deque<Long> q, long now) {
        while (!q.isEmpty() && now - q.peekFirst() > WINDOW_NANOS) {
            q.removeFirst();
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void crashfixer$resetSoundCounters(CallbackInfo ci) {
        this.crashfixer$soundsThisTick = 0;
        this.crashfixer$warnedThisTick = false;
        this.crashfixer$blockSoundsThisTick = 0;
        this.crashfixer$warnedBlockThisTick = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"Lnet/minecraft/client/sound/SoundSystem;play(Lnet/minecraft/client/sound/SoundInstance;)Lnet/minecraft/client/sound/SoundSystem$PlayResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void crashfixer$throttleSoundPlays(class_1113 sound, CallbackInfoReturnable<class_1140.class_11518> cir) {
        Deque q;
        if (sound == null) {
            return;
        }
        if (sound.method_4774() == class_3419.field_15245) {
            if (this.crashfixer$blockSoundsThisTick >= CRASHFIXER_MAX_BLOCK_SOUNDS_PER_TICK) {
                if (!this.crashfixer$warnedBlockThisTick) {
                    this.crashfixer$warnedBlockThisTick = true;
                    Constants.logger.warn("Block sound cap (" + CRASHFIXER_MAX_BLOCK_SOUNDS_PER_TICK + ") reached; throttling further plays this tick");
                }
                cir.cancel();
                return;
            }
            ++this.crashfixer$blockSoundsThisTick;
        }
        if (this.crashfixer$soundsThisTick >= CRASHFIXER_MAX_SOUNDS_PER_TICK) {
            if (!this.crashfixer$warnedThisTick) {
                this.crashfixer$warnedThisTick = true;
                Constants.logger.warn("Sound cap (" + CRASHFIXER_MAX_SOUNDS_PER_TICK + ") reached; throttling further plays this tick");
            }
            cir.cancel();
            return;
        }
        ++this.crashfixer$soundsThisTick;
        long now = System.nanoTime();
        Deque<Long> deque = recentGlobalPlays;
        synchronized (deque) {
            SoundSystemMixin.prune(recentGlobalPlays, now);
            if (recentGlobalPlays.size() >= MAX_PLAYS_PER_WINDOW) {
                cir.cancel();
                return;
            }
            recentGlobalPlays.addLast(now);
        }
        class_2960 id = sound.method_4775();
        if (id == null) {
            return;
        }
        Deque deque2 = q = recentById.computeIfAbsent(id, k -> new ArrayDeque(MAX_SAME_SOUND_PER_WINDOW + 2));
        synchronized (deque2) {
            SoundSystemMixin.prune(q, now);
            if (recentById.size() > CLEANUP_THRESHOLD && q.isEmpty()) {
                recentById.remove(id, q);
            }
            while (q.size() > MAX_SAME_SOUND_PER_WINDOW) {
                q.pollFirst();
            }
            if (q.size() >= MAX_SAME_SOUND_PER_WINDOW) {
                if (q.size() == MAX_SAME_SOUND_PER_WINDOW) {
                    Constants.logger.debug("Throttling repeated sound: " + String.valueOf(id));
                }
                cir.cancel();
                return;
            }
            q.addLast(now);
        }
    }
}

