/*
 * Decompiled with CFR 0.152.
 */
package cc.modlabs.crashfixer.mixin;

import cc.modlabs.crashfixer.Constants;
import cc.modlabs.crashfixer.CrashFixerCall;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5348;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_2588.class})
public class TranslatableTextContentMixin {
    private static final AtomicBoolean logged = new AtomicBoolean(false);
    private static final int MAX_TRANSLATION_RECURSION = 2;
    private static final int LOG_RESET = 20;
    private static final ThreadLocal<Integer> crashFixer$validCalls = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Integer> crashFixer$recursionDepth = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<Boolean> crashFixer$isPoisoned = ThreadLocal.withInitial(() -> false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private <T> Optional<T> crashfixer$guarded(CrashFixerCall<T> call, String recursionLog) {
        if (crashFixer$isPoisoned.get().booleanValue()) {
            crashFixer$validCalls.set(0);
            return Optional.empty();
        }
        int depth = crashFixer$recursionDepth.get();
        if (depth > 2) {
            if (!logged.getAndSet(true)) {
                Constants.logger.warn(recursionLog + " (depth=" + depth + ")");
            }
            crashFixer$isPoisoned.set(true);
            crashFixer$validCalls.set(0);
            return Optional.empty();
        }
        crashFixer$recursionDepth.set(depth + 1);
        try {
            Optional<T> optional = call.call();
            return optional;
        }
        catch (Throwable t) {
            crashFixer$isPoisoned.set(true);
            crashFixer$validCalls.set(0);
            if (depth == 2) {
                Constants.logger.error(recursionLog + " Exception at depth " + depth + ": " + String.valueOf(t));
            }
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            crashFixer$recursionDepth.set(depth);
            if (depth == 0) {
                crashFixer$isPoisoned.set(false);
                int validCalls = crashFixer$validCalls.get();
                crashFixer$validCalls.set(validCalls + 1);
                if (validCalls > 20) {
                    logged.set(false);
                }
            }
        }
    }

    @Redirect(method={"visit(Lnet/minecraft/text/StringVisitable$Visitor;)Ljava/util/Optional;"}, at=@At(value="INVOKE", target="Lnet/minecraft/text/StringVisitable;visit(Lnet/minecraft/text/StringVisitable$Visitor;)Ljava/util/Optional;"))
    private <T> Optional<T> crashfixer$redirectVisit(class_5348 instance, class_5348.class_5245<T> visitor) {
        return this.crashfixer$guarded(() -> instance.method_27657(visitor), "Prevented recursion in StringVisitable.visit");
    }

    @Redirect(method={"visit(Lnet/minecraft/text/StringVisitable$StyledVisitor;Lnet/minecraft/text/Style;)Ljava/util/Optional;"}, at=@At(value="INVOKE", target="Lnet/minecraft/text/StringVisitable;visit(Lnet/minecraft/text/StringVisitable$StyledVisitor;Lnet/minecraft/text/Style;)Ljava/util/Optional;"))
    private <T> Optional<T> crashfixer$redirectStyledVisit(class_5348 instance, class_5348.class_5246<T> visitor, class_2583 style) {
        return this.crashfixer$guarded(() -> instance.method_27658(visitor, style), "Prevented recursion in StringVisitable.visit(Styled)");
    }
}

