package dev.kikugie.techutils.feature.containerscan;

import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.util.ContainerUtils;
import dev.kikugie.techutils.util.LocalPlacementPos;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_310;

/**
 * Used to access container data inside a placement.
 * <p>
 * Is this overcomplicated? Definitely.
 */
public final class PlacementContainerAccess {
	public static LinkedStorageEntry getEntry(class_2338 worldPos, class_2680 worldState) {
		return new LinkedStorageEntry(worldPos, null, getSchematicInventory(worldPos, worldState).orElse(null));
	}

	public static LinkedStorageEntry getEntry(class_2338 worldPos, class_2680 worldState, class_1277 worldInventory) {
		return new LinkedStorageEntry(worldPos, worldInventory, getSchematicInventory(worldPos, worldState).orElse(null));
	}

	/**
	 * Gets placement container data at a position, if there's a placement there. For double chests returns their combined inventory.
	 *
	 * @param worldPos   position in the world
	 * @param worldState block state of the given position
	 * @return {@link class_1277} with schematic items if its present
	 * @see LocalPlacementPos
	 */
	public static Optional<class_1277> getSchematicInventory(class_2338 worldPos, class_2680 worldState) {
		class_2745 type = getChestType(worldState);
		if (type == class_2745.field_12569)
			return getSchematicInventoryInternal(worldPos, worldState);

		// Double chest handling
		class_2338 adjacentChest = worldPos.method_10081(class_2281.method_9758(worldState).method_62675());
		assert class_310.method_1551().field_1687 != null;
		class_2680 adjacentState = class_310.method_1551().field_1687.method_8320(adjacentChest);

		Optional<class_1277> opt1 = getSchematicInventoryInternal(worldPos, worldState);
		Optional<class_1277> opt2 = getSchematicInventoryInternal(adjacentChest, adjacentState);
		if (opt1.isEmpty() && opt2.isEmpty())
			return Optional.empty();
		class_1277 chest1 = opt1.orElse(new class_1277(27));
		class_1277 chest2 = opt2.orElse(new class_1277(27));

		return type == class_2745.field_12571 ? Optional.of(merge(chest1, chest2)) : Optional.of(merge(chest2, chest1));
	}

	public static Optional<class_1277> getSchematicInventoryInternal(class_2338 worldPos, class_2680 worldState) {
		Optional<class_1263> dummyInv = ContainerUtils.validateContainer(worldPos, worldState);
		// World block is not a container
		if (dummyInv.isEmpty())
			return Optional.empty();

		Optional<LocalPlacementPos> optionalPos = LocalPlacementPos.get(worldPos);
		// Block is not in the schematic
		if (optionalPos.isEmpty())
			return Optional.empty();

		LocalPlacementPos placementPos = optionalPos.get();
		Optional<class_1263> schemInv = ContainerUtils.validateContainer(worldPos, placementPos.blockState());
		// Schematic and world blocks don't match
		if (schemInv.isEmpty()
			|| dummyInv.get().method_5439() != schemInv.get().method_5439()
			|| !(schemInv.get() instanceof class_2586 schemBE)
			|| !(dummyInv.get() instanceof class_2586 dummyBE)
			|| schemBE.method_11017() != dummyBE.method_11017()
		) {
			return Optional.empty();
		}

		return Optional.ofNullable(getItems(placementPos));
	}

	private static class_1277 merge(class_1263 first, class_1263 second) {
		class_1258 combined = new class_1258(first, second);
		class_1277 inventory = new class_1277(combined.method_5439());
		for (int i = 0; i < combined.method_5439(); i++) {
			inventory.method_5447(i, combined.method_5438(i));
		}
		return inventory;
	}

	private static void sendError(String message) {
		TechUtilsMod.LOGGER.warn(message);
	}

	/**
	 * @return {@link class_2745} of a block state. Returns {@link class_2745#field_12569} for any other state, as all that matters is if it's a single-block storage.
	 */
	private static class_2745 getChestType(class_2680 state) {
		if (!(state.method_26204() instanceof class_2281))
			return class_2745.field_12569;
		return state.method_11654(class_2281.field_10770);
	}

	@Nullable
	private static class_1277 getItems(LocalPlacementPos placementPos) {
		Map<class_2338, class_2487> blockEntities = placementPos.placement().getSchematic()
			.getBlockEntityMapForRegion(placementPos.region());
		// No block entity map for the region. Shouldn't be possible unless it was manually modified
		if (blockEntities == null)
			return null;

		class_2487 nbt = blockEntities.get(placementPos.pos());
		// No such entry in the map
		if (nbt == null)
			return null;

		var lookup = class_310.method_1551().field_1687.method_30349();
		var blockEntity = class_2586.method_11005(
			placementPos.pos(),
			placementPos.blockState(),
			nbt,
			lookup
		);

		if (!(blockEntity instanceof class_1263 schematicInventory)) {
			return null;
		}

		var inventory = new class_1277(schematicInventory.method_5439());

		for (int i = 0; i < inventory.method_5439(); i++) {
			var stack = schematicInventory.method_5438(i);
			inventory.method_5447(i, stack);
		}

		return inventory;
	}
}
