package dev.kikugie.techutils.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.kikugie.techutils.Reference;
import dev.kikugie.techutils.mixin.containerscan.MinecraftClientAccessor;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import net.minecraft.class_10366;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4668;
import net.minecraft.class_6367;
import org.joml.Matrix4f;

/**
 * Taken from <a href="https://modrinth.com/plugin/cae2">Client Storage</a> by samolego.
 *
 * @see <a href="https://github.com/samolego/ClientStorage/blob/master/fabric-client/src/main/java/org/samo_lego/clientstorage/fabric_client/render/TransparencyBuffer.java">TransparencyBuffer.java</a>
 */
public class TransparencyBuffer {
	private static final class_276 framebuffer;
	private static class_276 prevFramebuffer;
	private static final RenderPipeline POSITION_TEX_TRANSPARENT = RenderPipeline.builder(MaLiLibPipelines.POSITION_TEX_MASA_STAGE)
		.withLocation(class_2960.method_60655(Reference.MOD_ID, "pipeline/position_tex/transparent"))
		.build();
	private static final class_1921 POSITION_TEX_TRANSPARENT_LAYER = class_1921.method_24049(
		Reference.MOD_ID + "_transparency",
		1536, false, true,
		POSITION_TEX_TRANSPARENT,
		class_1921.class_4688.method_23598()
			.method_34577(class_4668.field_21378)
			.method_23617(false)
	);

	static {
		var client = class_310.method_1551();
		class_1041 window = client.method_22683();
		framebuffer = new class_6367(Reference.MOD_ID + "_transparency", window.method_4489(), window.method_4506(), true);
	}

	public static void prepareExtraFramebuffer() {
		prevFramebuffer = class_310.method_1551().method_1522();
		// Setup extra framebuffer to draw into
		RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(framebuffer.method_30277(), 0, framebuffer.method_30278(), 1);
		((MinecraftClientAccessor) class_310.method_1551()).setFramebuffer(framebuffer);
	}

	public static void preInject(class_332 context) {
		context.method_51452();
		RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 0.5f);
	}

	public static void drawExtraFramebuffer(class_332 context) {
		// Restore the original framebuffer
		((MinecraftClientAccessor) class_310.method_1551()).setFramebuffer(prevFramebuffer);
		drawUntexturedQuad(context,
			0,
			0,
			context.method_51421(),
			context.method_51443(),
			0,
			framebuffer.field_1481,
			framebuffer.field_1482,
			-framebuffer.field_1481,
			framebuffer.field_1482,
			framebuffer.field_1481);
	}

	public static void postInject() {
		RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
	}

	public static void resizeDisplay() {
		class_1041 window = class_310.method_1551().method_22683();
		framebuffer.method_1234(window.method_4489(), window.method_4506());
	}

	public static void drawUntexturedQuad(class_332 context, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
		drawUntexturedQuad(context,
			x,
			x + width,
			y,
			y + height,
			0,
			(u + 0.0F) / (float) textureWidth,
			(u + (float) regionWidth) / (float) textureWidth,
			(v + 0.0F) / (float) textureHeight,
			(v + (float) regionHeight) / (float) textureHeight);
	}

	private static void drawUntexturedQuad(class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
		RenderSystem.setShaderTexture(0, framebuffer.method_30277());
		RenderSystem.backupProjectionMatrix();
		Matrix4f newProjMat = new Matrix4f()
			.setOrtho(
				0,
				(float) x2,
				(float) y2,
				0,
				1000.0F,
				21000.0F
			);
		RenderSystem.setProjectionMatrix(newProjMat, class_10366.field_54954);

		Matrix4f posMat = context.method_51448().method_23760().method_23761();
		context.method_64039(vertexConsumerProvider -> {
			class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(POSITION_TEX_TRANSPARENT_LAYER);
			vertexConsumer.method_22918(posMat, (float) x1, (float) y1, (float) z).method_22913(u1, v1);
			vertexConsumer.method_22918(posMat, (float) x1, (float) y2, (float) z).method_22913(u1, v2);
			vertexConsumer.method_22918(posMat, (float) x2, (float) y2, (float) z).method_22913(u2, v2);
			vertexConsumer.method_22918(posMat, (float) x2, (float) y1, (float) z).method_22913(u2, v1);
		});

		RenderSystem.restoreProjectionMatrix();
	}
}
