package dev.kikugie.techutils.util;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_11362;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9360;

public final class ItemPredicateUtils {
	public static final String PREDICATE_ID = "techutils:item_predicate";
	private static final Map<String, class_2073> PREDICATE_CACHE = new HashMap<>();
	private static final Reference2ReferenceOpenHashMap<class_2073, List<class_2561>> PRETTIFIED_PREDICATES = new Reference2ReferenceOpenHashMap<>();

	private ItemPredicateUtils() {}

	public static class_1799 createPredicateStack(String rawPredicate, class_1799 placeholder) {
		class_11362 writeView = class_11362.method_71458(class_8942.field_60348);
		class_1799 stack = class_1802.field_8866.method_7854();

		writeView.method_71469("Command", rawPredicate);
		class_1747.method_57338(stack, class_2591.field_11904, writeView);

		setPlaceholder(stack, placeholder);

		stack.method_57368(
			class_9334.field_49628,
			class_9279.field_49302,
			nbtComponent -> nbtComponent.method_57451(custom -> custom.method_10566(PREDICATE_ID, new class_2487()))
		);

		stack.method_57379(class_9334.field_49631, class_2561.method_43470("Item Predicate")
			.method_27694(style -> style.method_10977(class_124.field_1068).method_10978(false))
		);

		return stack;
	}

	public static boolean isPredicate(class_1799 stack) {
		return stack.method_7909() == class_1802.field_8866
			&& stack.method_58694(class_9334.field_49628) instanceof class_9279 nbtComponent
			&& nbtComponent.method_57461().method_10545(PREDICATE_ID);
	}

	public static String getRawPredicate(class_1799 stack) {
		return stack.method_58694(class_9334.field_49611) instanceof class_11580<class_2591<?>> data
			? data.method_72540().method_10558("Command").orElse("")
			: "";
	}

	public static @Nullable class_2073 getPredicate(class_1799 stack) {
		if (!isPredicate(stack)) {
			return null;
		}

		var rawPredicate = getRawPredicate(stack);
		return getPredicate(rawPredicate);
	}

	public static class_2073 getPredicate(String rawPredicate) {
		if (PREDICATE_CACHE.containsKey(rawPredicate)) {
			return PREDICATE_CACHE.get(rawPredicate);
		}

		int startingTokenIndex = rawPredicate.indexOf('{');
		if (startingTokenIndex == -1)
			return saveFailedPredicate(rawPredicate, "No item predicate is present!");

		rawPredicate = rawPredicate.substring(startingTokenIndex);

		class_2487 nbt;
		try {
			nbt = class_2522.method_67315(rawPredicate).method_10562("predicate").orElseGet(class_2487::new);
			if (nbt.method_33133()) {
				throw new IllegalArgumentException("No item predicate is present!");
			}
		} catch (Throwable throwable) {
			return saveFailedPredicate(rawPredicate, throwable.getMessage());
		}
		var result = class_2073.field_45754.parse(class_6903.method_46632(class_2509.field_11560, class_310.method_1551().field_1687.method_30349()), nbt);
		if (result.isSuccess()) {
			var predicate = result.getOrThrow();
			PREDICATE_CACHE.put(rawPredicate, predicate);
			PRETTIFIED_PREDICATES.put(predicate, ContainerUtils.prettifyNbt(nbt));

			return predicate;
		} else {
			return saveFailedPredicate(rawPredicate, result.error().get().message());
		}
	}

	public static List<class_2561> getPrettyPredicate(class_1799 predicateStack) {
		var predicate = ItemPredicateUtils.getPredicate(predicateStack);
		if (predicate == null) {
			return List.of();
		}

		if (ItemPredicateUtils.getPlaceholder(predicateStack) instanceof class_1799 placeholder) {
			var nbt = new class_2487();
			var lookup = class_310.method_1551().field_1687.method_30349();
			nbt.method_10566("placeholder", toNbtAllowEmpty(placeholder, lookup));
			var lines = new ArrayList<>(PRETTIFIED_PREDICATES.get(predicate));
			lines.addAll(ContainerUtils.prettifyNbt(nbt));
			return lines;
		} else {
			return Collections.unmodifiableList(PRETTIFIED_PREDICATES.get(predicate));
		}
	}

	public static List<class_2561> getErrorLines(class_1799 stack, class_2073 predicate) {
		var lines = new ArrayList<class_2561>();
		var items = predicate.comp_1784();
		var count = predicate.comp_1785();
		var components = predicate.comp_2374();

		if (items.isPresent() && !stack.method_53187(items.get())) {
			var msg = class_2561.method_43470("Incorrect item type. Expected: ")
				.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
			items.get().method_40239()
				.flatMap(i -> Stream.of(class_2561.method_30163(", "), class_2561.method_30163(i.method_55840())))
				.skip(1)
				.forEach(msg::method_10852);
			lines.add(msg);
		}

		if (!count.method_9054(stack.method_7947())) {
			var min = count.comp_4771().comp_4769();
			var max = count.comp_4771().comp_4770();
			var msg = class_2561.method_43470("Incorrect count. Expected: ")
				.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
			if (min.isPresent() && max.isPresent() && min.get().equals(max.get())) {
				msg.method_10852(class_2561.method_30163(min.get().toString()));
			} else {
				if (min.isPresent()) {
					msg.method_27693("at least " + min.get());
					if (max.isPresent()) {
						msg.method_27693(" and ");
					}
				}
				max.ifPresent(i -> msg.method_27693("at most " + i));
			}
			lines.add(msg);
		}

		var wrongComponents = new ArrayList<class_9331<?>>();
		for (Map.Entry<class_9331<?>, Optional<?>> entry : components.comp_3833().method_57870().method_57846()) {
			class_9331<?> type = entry.getKey();
			if (!Objects.equals(entry.getValue().orElse(null), stack.method_58694(type))) {
				wrongComponents.add(type);
			}
		}
		if (!wrongComponents.isEmpty()) {
			var msg = class_2561.method_43470("Wrong/missing components: ")
				.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
			wrongComponents.stream()
				.flatMap(t -> Stream.of(class_2561.method_30163(", "), class_2561.method_30163(class_156.method_57107(class_7923.field_49658, t))))
				.skip(1)
				.forEach(msg::method_10852);
			lines.add(msg);
		}

		var wrongSubPredicates = new ArrayList<class_9360.class_8745<?>>();
		for (Map.Entry<class_9360.class_8745<?>, class_9360> entry : components.comp_3834().entrySet()) {
			if(!entry.getValue().method_58161(stack)) {
				wrongSubPredicates.add(entry.getKey());
			}
		}
		if (!wrongSubPredicates.isEmpty()) {
			var msg = class_2561.method_43470("Failed sub-predicates: ")
				.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
			wrongSubPredicates.stream()
				.flatMap(t -> Stream.of(class_2561.method_30163(", "), class_2561.method_30163(class_156.method_57107(class_7923.field_56404, t))))
				.skip(1)
				.forEach(msg::method_10852);
			lines.add(msg);
		}

		return lines;
	}

	@Nullable
	public static class_1799 getPlaceholder(class_1799 stack) {
		return isPredicate(stack) && stack.method_58694(class_9334.field_49622) instanceof class_9288 containerComponent
			? containerComponent.method_58114()
			: null;
	}

	public static void setPlaceholder(class_1799 predicateStack, class_1799 placeholder) {
		if (placeholder == null || placeholder.method_7960()) {
			predicateStack.method_57381(class_9334.field_49622);
		} else {
			predicateStack.method_57379(
				class_9334.field_49622,
				class_9288.method_57493(List.of(placeholder))
			);
		}
	}

	private static class_2073 saveFailedPredicate(String rawPredicate, String message) {
		var markerPredicate = class_2073.class_2074.method_8973().method_35233(class_2096.class_2100.method_9058(-1)).method_8976();
		PREDICATE_CACHE.put(rawPredicate, markerPredicate);

		var title = class_2561.method_43470("Could not parse item predicate!")
			.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
		var lines = new ArrayList<class_2561>();
		lines.add(title);
		for (String line : message.split("\n")) {
			lines.add(class_2561.method_43470(line)
				.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false)));
		}
		PRETTIFIED_PREDICATES.put(markerPredicate, lines);
		return markerPredicate;
	}

	private static class_2520 toNbtAllowEmpty(class_1799 stack, class_7225.class_7874 registries) {
		return stack.method_7960() ? new class_2487() : class_1799.field_24671.encode(stack, registries.method_57093(class_2509.field_11560), new class_2487()).getOrThrow();
	}
}
