/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.feature.containerscan.verifier.ItemPredicateEntryScreen;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import net.minecraft.class_746;

public class ItemPredicateCommand {
    private static final SimpleCommandExceptionType WRONG_MAIN_HAND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.itempredicate.placeholder.wrong_main_hand"));
    private static final SimpleCommandExceptionType NO_PLACEHOLDER_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.itempredicate.placeholder.get.not_found"));
    private static final SimpleCommandExceptionType NOT_IN_CREATIVE_MODE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.itempredicate.not_in_creative_mode"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignoredAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"itempredicate").then(ClientCommandManager.literal((String)"give").executes(context -> {
            class_746 player = ((FabricClientCommandSource)context.getSource()).getPlayer();
            ItemPredicateCommand.enforceCreativeMode(player);
            class_1799 offHandStack = player.method_6079().method_7972();
            TechUtilsMod.QUEUED_END_CLIENT_TICK_TASKS.add(client -> client.method_1507((class_437)new ItemPredicateEntryScreen(player, offHandStack)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"edit").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_746 player = source.getPlayer();
            ItemPredicateCommand.enforceCreativeMode(player);
            class_1799 mainHandStack = player.method_6047().method_7972();
            if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
                throw WRONG_MAIN_HAND_EXCEPTION.create();
            }
            String rawPredicate = ItemPredicateUtils.getRawPredicate(mainHandStack);
            class_1799 placeholder = ItemPredicateUtils.getPlaceholder(mainHandStack);
            TechUtilsMod.QUEUED_END_CLIENT_TICK_TASKS.add(client -> client.method_1507((class_437)new ItemPredicateEntryScreen(((FabricClientCommandSource)context.getSource()).getPlayer(), rawPredicate, placeholder)));
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"placeholder").then(ClientCommandManager.literal((String)"set").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_746 player = source.getPlayer();
            ItemPredicateCommand.enforceCreativeMode(player);
            class_1799 mainHandStack = player.method_6047().method_7972();
            class_1799 offHandStack = player.method_6079().method_7972();
            if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
                throw WRONG_MAIN_HAND_EXCEPTION.create();
            }
            ItemPredicateUtils.setPlaceholder(mainHandStack, offHandStack);
            int selectedSlot = player.method_31548().method_67532();
            player.method_31548().method_5447(selectedSlot, mainHandStack);
            source.getClient().field_1761.method_2909(mainHandStack, 36 + selectedSlot);
            player.field_7498.method_7623();
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.itempredicate.placeholder.set.success"));
            return 1;
        }))).then(ClientCommandManager.literal((String)"get").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            class_746 player = source.getPlayer();
            ItemPredicateCommand.enforceCreativeMode(player);
            class_1799 mainHandStack = player.method_6047().method_7972();
            if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
                throw WRONG_MAIN_HAND_EXCEPTION.create();
            }
            class_1799 patt0$temp = ItemPredicateUtils.getPlaceholder(mainHandStack);
            if (!(patt0$temp instanceof class_1799)) {
                throw NO_PLACEHOLDER_FOUND_EXCEPTION.create();
            }
            class_1799 placeholder = patt0$temp;
            player.method_31548().method_5447(40, placeholder);
            source.getClient().field_1761.method_2909(placeholder, 45);
            player.field_7498.method_7623();
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.itempredicate.placeholder.get.success"));
            return 1;
        }))));
    }

    private static void enforceCreativeMode(class_746 player) throws CommandSyntaxException {
        if (!player.method_68878()) {
            throw NOT_IN_CREATIVE_MODE_EXCEPTION.create();
        }
    }
}

