/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.worldedit;

import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.feature.worldedit.WorldEditStorage;
import dev.kikugie.techutils.feature.worldedit.WorldEditSync;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import org.enginehub.worldeditcui.protocol.CUIPacket;

public class WorldEditNetworkHandler {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"worldedit", (String)"cui");
    private static final int PROTOCOL = 4;
    private static WorldEditNetworkHandler instance;
    public final WorldEditStorage storage = WorldEditStorage.init();
    private boolean worldEditConnected = false;
    private boolean yoinkPackets = false;

    private WorldEditNetworkHandler() {
        Set receivers = ClientPlayNetworking.getGlobalReceivers();
        if (receivers.contains(CHANNEL)) {
            this.yoinkPackets = true;
            this.handshake();
            return;
        }
        ClientPlayNetworking.registerReceiver((class_8710.class_9154)CUIPacket.TYPE, (payload, context) -> this.onPacket((CUIPacket)payload));
        this.handshake();
    }

    public static WorldEditNetworkHandler initHandler() {
        if (class_310.method_1551().field_1687 == null) {
            throw new RuntimeException("Registering WorldEdit handler in non-world context!");
        }
        instance = new WorldEditNetworkHandler();
        return instance;
    }

    public static Optional<WorldEditNetworkHandler> getInstance() {
        return Optional.ofNullable(instance);
    }

    public void onYoinkedPacket(class_8710 payload) {
        if (!this.yoinkPackets) {
            return;
        }
        this.onPacket((CUIPacket)payload);
    }

    private void onPacket(CUIPacket packet) {
        if (!this.worldEditConnected) {
            this.worldEditConnected = true;
            TechUtilsMod.LOGGER.info("WorldEdit connected");
            WorldEditSync.getInstance().ifPresent(WorldEditSync::onWorldEditConnected);
        }
        if (packet.args().isEmpty()) {
            TechUtilsMod.LOGGER.warn("WorldEditNetworkHandler#onPacket(): Received CUI packet of length zero");
            return;
        }
        this.handlePacket(packet.eventType(), (String[])packet.args().toArray(String[]::new));
    }

    private void handlePacket(String type, String[] args) {
        if (type.equals("s")) {
            this.storage.setCuboid(args[0].equals("cuboid"));
            return;
        }
        if (!type.equals("p") || !this.storage.isCuboid()) {
            return;
        }
        try {
            int p = Integer.parseInt(args[0]);
            class_2338 pos = new class_2338(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            this.storage.setPos(p == 0, pos);
        }
        catch (NumberFormatException e) {
            TechUtilsMod.LOGGER.warn("WorldEditCUINetworkHandler#handlePacket(): Failed int parsing of position", (Throwable)e);
        }
    }

    private void handshake() {
        ClientPlayNetworking.send((class_8710)new CUIPacket("v", new String[]{String.valueOf(4)}));
    }
}

