/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.worldedit;

import com.mojang.brigadier.CommandDispatcher;
import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.config.WorldEditConfigs;
import dev.kikugie.techutils.feature.worldedit.WorldEditNetworkHandler;
import dev.kikugie.techutils.util.ResponseMuffler;
import dev.kikugie.techutils.util.ValidBox;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class WorldEditSync {
    @Nullable
    private static WorldEditSync instance = null;
    private final class_310 client = class_310.method_1551();
    private final WorldEditNetworkHandler handler = WorldEditNetworkHandler.initHandler();
    private ValidBox lastBox;
    private int syncTick = 0;
    private boolean worldEditConnected = false;
    private boolean commandAvailable = false;
    private boolean initComplete = false;

    public static void init() {
        instance = new WorldEditSync();
    }

    public static Optional<WorldEditSync> getInstance() {
        return Optional.ofNullable(instance);
    }

    public void onTick() {
        boolean initCompleteCache = !this.initComplete && this.worldEditConnected && this.commandAvailable;
        boolean bl = this.initComplete = this.worldEditConnected && this.commandAvailable;
        if (initCompleteCache) {
            this.disableNeighborUpdates();
        }
        if (this.initComplete) {
            this.syncSelection();
        }
    }

    public void onWorldEditConnected() {
        this.worldEditConnected = true;
    }

    public void onCommandTreePacket(CommandDispatcher<class_2172> dispatcher) {
        this.commandAvailable = dispatcher.findNode(List.of("/pos1")) != null;
    }

    private void disableNeighborUpdates() {
        if (!WorldEditConfigs.DISABLE_UPDATES.getBooleanValue()) {
            return;
        }
        ResponseMuffler.scheduleMute("Side effect \"Neighbors\".+");
        Objects.requireNonNull(this.client.method_1562()).method_45730("/perf neighbors off");
        TechUtilsMod.LOGGER.debug("Turning off WorldEdit neighbor updates");
    }

    private void syncSelection() {
        if (!WorldEditConfigs.WE_SYNC.getBooleanValue()) {
            return;
        }
        if (this.syncTick > 0) {
            --this.syncTick;
        }
        if (!this.handler.storage.isCuboid()) {
            return;
        }
        Optional<ValidBox> boxOptional = this.getActiveSelection();
        if (boxOptional.isEmpty()) {
            return;
        }
        ValidBox box = boxOptional.get();
        if (!box.equals(this.lastBox)) {
            this.lastBox = box;
            this.syncTick = WorldEditConfigs.WE_SYNC_TICKS.getIntegerValue();
            return;
        }
        if (this.syncTick != 0) {
            return;
        }
        this.syncTick = -1;
        this.updateRegion(box);
        TechUtilsMod.LOGGER.debug("WorldEdit synced!");
        if (WorldEditConfigs.WE_SYNC_FEEDBACK.getBooleanValue()) {
            this.client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"techutils.feature.worldeditsync.success").method_27692(class_124.field_1060), true);
        }
    }

    private void updateRegion(ValidBox box) {
        ResponseMuffler.scheduleMute("(\\w+ position set to \\(.+\\).)|(Position already set.)");
        this.client.method_1562().method_45730(String.format("/pos1 %d,%d,%d", box.getPos1().method_10263(), box.getPos1().method_10264(), box.getPos1().method_10260()));
        ResponseMuffler.scheduleMute("(\\w+ position set to \\(.+\\).)|(Position already set.)");
        this.client.method_1562().method_45730(String.format("/pos2 %d,%d,%d", box.getPos2().method_10263(), box.getPos2().method_10264(), box.getPos2().method_10260()));
    }

    private Optional<ValidBox> getActiveSelection() {
        AreaSelection selection = DataManager.getSelectionManager().getCurrentSelection();
        if (selection == null) {
            return Optional.empty();
        }
        Box box = selection.getSelectedSubRegionBox();
        if (box == null || box.getPos1() == null || box.getPos2() == null) {
            return Optional.empty();
        }
        return Optional.of(new ValidBox(box.getPos1(), box.getPos2(), "region"));
    }
}

