/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.kikugie.techutils.util.ContainerUtils;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_10914;
import net.minecraft.class_11362;
import net.minecraft.class_11580;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6885;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9360;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public final class ItemPredicateUtils {
    public static final String PREDICATE_ID = "techutils:item_predicate";
    private static final Map<String, class_2073> PREDICATE_CACHE = new HashMap<String, class_2073>();
    private static final Reference2ReferenceOpenHashMap<class_2073, List<class_2561>> PRETTIFIED_PREDICATES = new Reference2ReferenceOpenHashMap();

    private ItemPredicateUtils() {
    }

    public static class_1799 createPredicateStack(String rawPredicate, class_1799 placeholder) {
        class_11362 writeView = class_11362.method_71458((class_8942)class_8942.field_60348);
        class_1799 stack = class_1802.field_8866.method_7854();
        writeView.method_71469("Command", rawPredicate);
        class_1747.method_57338((class_1799)stack, (class_2591)class_2591.field_11904, (class_11362)writeView);
        ItemPredicateUtils.setPlaceholder(stack, placeholder);
        stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, nbtComponent -> nbtComponent.method_57451(custom -> custom.method_10566(PREDICATE_ID, (class_2520)new class_2487())));
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Item Predicate").method_27694(style -> style.method_10977(class_124.field_1068).method_10978(Boolean.valueOf(false))));
        return stack;
    }

    public static boolean isPredicate(class_1799 stack) {
        class_9279 nbtComponent;
        Object object;
        return stack.method_7909() == class_1802.field_8866 && (object = stack.method_58694(class_9334.field_49628)) instanceof class_9279 && (nbtComponent = (class_9279)object).method_57461().method_10545(PREDICATE_ID);
    }

    public static String getRawPredicate(class_1799 stack) {
        String string;
        Object object = stack.method_58694(class_9334.field_49611);
        if (object instanceof class_11580) {
            class_11580 data = (class_11580)object;
            string = data.method_72540().method_10558("Command").orElse("");
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    public static class_2073 getPredicate(class_1799 stack) {
        if (!ItemPredicateUtils.isPredicate(stack)) {
            return null;
        }
        String rawPredicate = ItemPredicateUtils.getRawPredicate(stack);
        return ItemPredicateUtils.getPredicate(rawPredicate);
    }

    public static class_2073 getPredicate(String rawPredicate) {
        class_2487 nbt;
        if (PREDICATE_CACHE.containsKey(rawPredicate)) {
            return PREDICATE_CACHE.get(rawPredicate);
        }
        int startingTokenIndex = rawPredicate.indexOf(123);
        if (startingTokenIndex == -1) {
            return ItemPredicateUtils.saveFailedPredicate(rawPredicate, "No item predicate is present!");
        }
        rawPredicate = rawPredicate.substring(startingTokenIndex);
        try {
            nbt = class_2522.method_67315((String)rawPredicate).method_10562("predicate").orElseGet(class_2487::new);
            if (nbt.method_33133()) {
                throw new IllegalArgumentException("No item predicate is present!");
            }
        }
        catch (Throwable throwable) {
            return ItemPredicateUtils.saveFailedPredicate(rawPredicate, throwable.getMessage());
        }
        DataResult result = class_2073.field_45754.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349()), (Object)nbt);
        if (result.isSuccess()) {
            class_2073 predicate = (class_2073)result.getOrThrow();
            PREDICATE_CACHE.put(rawPredicate, predicate);
            PRETTIFIED_PREDICATES.put((Object)predicate, ContainerUtils.prettifyNbt((class_2520)nbt));
            return predicate;
        }
        return ItemPredicateUtils.saveFailedPredicate(rawPredicate, ((DataResult.Error)result.error().get()).message());
    }

    public static List<class_2561> getPrettyPredicate(class_1799 predicateStack) {
        class_2073 predicate = ItemPredicateUtils.getPredicate(predicateStack);
        if (predicate == null) {
            return List.of();
        }
        class_1799 class_17992 = ItemPredicateUtils.getPlaceholder(predicateStack);
        if (class_17992 instanceof class_1799) {
            class_1799 placeholder = class_17992;
            class_2487 nbt = new class_2487();
            class_5455 lookup = class_310.method_1551().field_1687.method_30349();
            nbt.method_10566("placeholder", ItemPredicateUtils.toNbtAllowEmpty(placeholder, (class_7225.class_7874)lookup));
            ArrayList<class_2561> lines = new ArrayList<class_2561>((Collection)PRETTIFIED_PREDICATES.get((Object)predicate));
            lines.addAll(ContainerUtils.prettifyNbt((class_2520)nbt));
            return lines;
        }
        return Collections.unmodifiableList((List)PRETTIFIED_PREDICATES.get((Object)predicate));
    }

    public static List<class_2561> getErrorLines(class_1799 stack, class_2073 predicate) {
        class_5250 msg;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        Optional items = predicate.comp_1784();
        class_2096.class_2100 count = predicate.comp_1785();
        class_10914 components = predicate.comp_2374();
        if (items.isPresent() && !stack.method_53187((class_6885)items.get())) {
            class_5250 msg2 = class_2561.method_43470((String)"Incorrect item type. Expected: ").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)));
            ((class_6885)items.get()).method_40239().flatMap(i -> Stream.of(class_2561.method_30163((String)", "), class_2561.method_30163((String)i.method_55840()))).skip(1L).forEach(arg_0 -> ((class_5250)msg2).method_10852(arg_0));
            lines.add((class_2561)msg2);
        }
        if (!count.method_9054(stack.method_7947())) {
            Optional min = count.comp_4771().comp_4769();
            Optional max = count.comp_4771().comp_4770();
            msg = class_2561.method_43470((String)"Incorrect count. Expected: ").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)));
            if (min.isPresent() && max.isPresent() && ((Integer)min.get()).equals(max.get())) {
                msg.method_10852(class_2561.method_30163((String)((Integer)min.get()).toString()));
            } else {
                if (min.isPresent()) {
                    msg.method_27693("at least " + String.valueOf(min.get()));
                    if (max.isPresent()) {
                        msg.method_27693(" and ");
                    }
                }
                max.ifPresent(i -> msg.method_27693("at most " + i));
            }
            lines.add((class_2561)msg);
        }
        ArrayList<class_9331> wrongComponents = new ArrayList<class_9331>();
        for (Object entry : components.comp_3833().method_57870().method_57846()) {
            class_9331 class_93312 = (class_9331)entry.getKey();
            if (Objects.equals(((Optional)entry.getValue()).orElse(null), stack.method_58694(class_93312))) continue;
            wrongComponents.add(class_93312);
        }
        if (!wrongComponents.isEmpty()) {
            class_5250 msg3 = class_2561.method_43470((String)"Wrong/missing components: ").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)));
            wrongComponents.stream().flatMap(t -> Stream.of(class_2561.method_30163((String)", "), class_2561.method_30163((String)class_156.method_57107((class_2378)class_7923.field_49658, (Object)t)))).skip(1L).forEach(arg_0 -> ((class_5250)msg3).method_10852(arg_0));
            lines.add((class_2561)msg3);
        }
        ArrayList<class_9360.class_8745> wrongSubPredicates = new ArrayList<class_9360.class_8745>();
        for (Map.Entry entry : components.comp_3834().entrySet()) {
            if (((class_9360)entry.getValue()).method_58161((class_9473)stack)) continue;
            wrongSubPredicates.add((class_9360.class_8745)entry.getKey());
        }
        if (!wrongSubPredicates.isEmpty()) {
            msg = class_2561.method_43470((String)"Failed sub-predicates: ").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)));
            wrongSubPredicates.stream().flatMap(t -> Stream.of(class_2561.method_30163((String)", "), class_2561.method_30163((String)class_156.method_57107((class_2378)class_7923.field_56404, (Object)t)))).skip(1L).forEach(arg_0 -> ((class_5250)msg).method_10852(arg_0));
            lines.add((class_2561)msg);
        }
        return lines;
    }

    @Nullable
    public static class_1799 getPlaceholder(class_1799 stack) {
        class_1799 class_17992;
        Object object;
        if (ItemPredicateUtils.isPredicate(stack) && (object = stack.method_58694(class_9334.field_49622)) instanceof class_9288) {
            class_9288 containerComponent = (class_9288)object;
            class_17992 = containerComponent.method_58114();
        } else {
            class_17992 = null;
        }
        return class_17992;
    }

    public static void setPlaceholder(class_1799 predicateStack, class_1799 placeholder) {
        if (placeholder == null || placeholder.method_7960()) {
            predicateStack.method_57381(class_9334.field_49622);
        } else {
            predicateStack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(List.of(placeholder)));
        }
    }

    private static class_2073 saveFailedPredicate(String rawPredicate, String message) {
        class_2073 markerPredicate = class_2073.class_2074.method_8973().method_35233(class_2096.class_2100.method_9058((int)-1)).method_8976();
        PREDICATE_CACHE.put(rawPredicate, markerPredicate);
        class_5250 title = class_2561.method_43470((String)"Could not parse item predicate!").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false)));
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        lines.add(title);
        for (String line : message.split("\n")) {
            lines.add(class_2561.method_43470((String)line).method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false))));
        }
        PRETTIFIED_PREDICATES.put((Object)markerPredicate, lines);
        return markerPredicate;
    }

    private static class_2520 toNbtAllowEmpty(class_1799 stack, class_7225.class_7874 registries) {
        return stack.method_7960() ? new class_2487() : (class_2520)class_1799.field_24671.encode((Object)stack, (DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)new class_2487()).getOrThrow();
    }
}

