package dev.kikugie.techutils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import fi.dy.masa.litematica.data.DataManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.impl.command.client.ClientCommandInternals;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class IsorenderSelectionCommand {
	public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignoredAccess) {
		if (FabricLoader.getInstance().isModLoaded("isometric-renders")) {
			dispatcher.register(literal("isorender").then(literal("selection").executes(IsorenderSelectionCommand::renderLitematicaSelection)));
		}
	}

	@SuppressWarnings("UnstableApiUsage")
	private static int renderLitematicaSelection(CommandContext<FabricClientCommandSource> context) {
		var selection = DataManager.getSelectionManager().getCurrentSelection();
		if (selection == null) {
			context.getSource().sendError(class_2561.method_30163("No Litematica selection!"));
			return 1;
		}
		var box = selection.getSelectedSubRegionBox();
		if (box == null) {
			context.getSource().sendError(class_2561.method_30163("Invalid Litematica selection!"));
			return 1;
		}

		ClientCommandInternals.executeCommand(String.format("isorender area %d %d %d %d %d %d",
			box.getPos1().method_10263(),
			box.getPos1().method_10264(),
			box.getPos1().method_10260(),
			box.getPos2().method_10263(),
			box.getPos2().method_10264(),
			box.getPos2().method_10260()));

		return 1;
	}
}
