package dev.kikugie.techutils.feature.containerscan.verifier;

import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.feature.containerscan.LinkedStorageEntry;
import dev.kikugie.techutils.feature.containerscan.PlacementContainerAccess;
import dev.kikugie.techutils.feature.containerscan.handlers.InteractionHandler;
import dev.kikugie.techutils.render.TransparencyBuffer;
import dev.kikugie.techutils.util.ContainerUtils;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.malilib.util.WorldUtils;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1270;
import net.minecraft.class_1661;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3936;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class InventoryOverlay {
	@Nullable
	public static InventoryOverlay infoOverlayInstance = null;
	@Nullable
	public static class_1799 hoveredStackToRender;
	public static boolean delayRenderingHoveredStack = false;
	@Nullable
	private static InventoryOverlay instance = null;
	@Nullable
	private static class_2338 lastClickedPos = null;
	private final int MISSING_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getIntegerValue();
	private final int WRONG_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getIntegerValue();
	private final int MISMATCHED_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getIntegerValue();
	private final int EXTRA_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getIntegerValue();
	private final LinkedStorageEntry entry;
	private boolean renderCurrentItemTransparent = false;

	public InventoryOverlay(LinkedStorageEntry entry) {
		this.entry = entry;
	}

	public static void clearOverlay() {
		instance = null;
		lastClickedPos = null;
	}

	public static void onContainerClick(class_3965 hitResult) {
		lastClickedPos = hitResult.method_17777().method_10062();
	}

	public static void onScreenPostContainerClick() {
		if (lastClickedPos == null)
			return;
		class_2338 pos = lastClickedPos;
		class_1937 world = WorldUtils.getBestWorld(class_310.method_1551());
		if (!(ContainerUtils.validateContainer(world, pos, world.method_8320(pos)).orElse(null) instanceof class_1270))
			return;
		if (InteractionHandler.contains(pos))
			return;
		instance = get(pos, true).orElse(null);
	}

	public static Optional<InventoryOverlay> get(class_2338 pos, boolean queueInteraction) {
		class_1937 world = Objects.requireNonNull(WorldUtils.getBestWorld(class_310.method_1551()));

		long tick = world.method_8510();
		class_2680 state = world.method_8320(pos);
		Optional<class_1263> inventory = ContainerUtils.validateContainer(world, pos, state);
		if (inventory.isEmpty())
			return Optional.empty();

		LinkedStorageEntry entry = PlacementContainerAccess.getEntry(pos, state, null);
		entry.setWorldInventory(inventory.get());
		if (entry.getPlacementInventory().isEmpty())
			return Optional.empty();
		if (queueInteraction) InteractionHandler.add(new InteractionHandler(pos, tick) {
			@Override
			public boolean accept(class_437 screen) {
				class_1735 validSlot = null;
				for (class_1735 slot : ((class_3936<?>) screen).method_17577().field_7761) {
					if (!(slot.field_7871 instanceof class_1661)) {
						validSlot = slot;
						break;
					}
				}
				if (validSlot != null)
					entry.setWorldInventory(validSlot.field_7871);
				return true;
			}
		});
		return Optional.of(new InventoryOverlay(entry));
	}

	public static class_1799 drawStack(class_332 context, class_1735 slot, class_1799 stack) {
		return instance == null ? stack : instance.drawStackInternal(context, slot, stack);
	}

	public static void drawTransparencyBuffer(class_332 context, int x, int y) {
		if (instance != null)
			instance.drawTransparencyBufferInternal(context, x, y);
	}

	public static boolean setSlotToSchematicItem(class_1735 slot) {
		if (!LitematicConfigs.INVENTORY_SCREEN_OVERLAY.getBooleanValue()
			|| instance == null || slot.field_7871 instanceof class_1661
		)
			return false;

		var schematicItem = instance.entry.getPlacementInventory().get().method_5438(slot.method_34266());
		slot.method_53512(ItemPredicateUtils.getPlaceholder(schematicItem) instanceof class_1799 placeholder
			? placeholder
			: schematicItem
		);
		return true;
	}

	public class_1799 drawStackInternal(class_332 context, class_1735 slot, class_1799 stack) {
		if (!LitematicConfigs.INVENTORY_SCREEN_OVERLAY.getBooleanValue()
			|| slot.field_7871 instanceof class_1661
			|| slot.field_7871 instanceof class_1731
			|| this.entry.getWorldInventory().isEmpty()
		)
			return stack;

		if (LitematicConfigs.FORCE_SCHEMATIC_ITEM_OVERLAY.getBooleanValue())
			stack = class_1799.field_8037;

		class_1799 schematicStack = this.entry.getPlacementInventory().get().method_5438(slot.method_34266());
		if (schematicStack == null) {
			schematicStack = class_1799.field_8037;
		}

		int color = 0;
		if (ItemPredicateUtils.getPredicate(schematicStack) instanceof class_2073 predicate) {
			if (stack.method_7960()) {
				color = this.MISSING_COLOR;
				stack = ItemPredicateUtils.getPlaceholder(schematicStack) instanceof class_1799 placeholder
					? placeholder
					: schematicStack;
				this.renderCurrentItemTransparent = true;
			} else if (!predicate.method_8970(stack)) {
				color = this.WRONG_COLOR;
			}
		} else if (stack.method_7960() && !schematicStack.method_7960()) {
			color = this.MISSING_COLOR;
			stack = schematicStack;
			this.renderCurrentItemTransparent = true;
		} else if (!stack.method_7960() && schematicStack.method_7960()) {
			color = this.EXTRA_COLOR;
		} else if (!stack.method_7909().equals(schematicStack.method_7909())) {
			color = this.WRONG_COLOR;
		} else if (stack.method_7947() != schematicStack.method_7947()) {
			color = this.MISMATCHED_COLOR;
		} else if (LitematicConfigs.VERIFY_ITEM_COMPONENTS.getBooleanValue()
			&& !Objects.equals(schematicStack.method_57353(), stack.method_57353())) {
			color = WRONG_COLOR;
		}

		if (color != 0)
			drawBackground(context, slot, color);

		if (this.renderCurrentItemTransparent)
			TransparencyBuffer.prepareExtraFramebuffer();


		return stack;
	}

	public void drawBackground(class_332 context, class_1735 slot, int color) {
		int x = slot.field_7873;
		int y = slot.field_7872;
		context.method_25294(x, y, x + 16, y + 16, color);
	}

	public void drawTransparencyBufferInternal(class_332 context, int x, int y) {
		if (LitematicConfigs.INVENTORY_SCREEN_OVERLAY.getBooleanValue() && this.renderCurrentItemTransparent) {
			this.renderCurrentItemTransparent = false;
			class_4587 matrices = context.method_51448();
			TransparencyBuffer.preInject();

			// Align the matrix stack
			matrices.method_22903();
			matrices.method_46416(-x, -y, 0);

			// Draw the framebuffer texture
			TransparencyBuffer.drawExtraFramebuffer(context);
			matrices.method_22909();

			TransparencyBuffer.postInject();
		}
	}
}
