package dev.kikugie.techutils.feature.preview.model;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kikugie.techutils.feature.preview.interaction.InteractionProfile;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_8251;

public class PreviewRenderer {
	private static final double MAX_BLOCK_WIDTH = Math.cos(Math.PI / 6) * 2;
	private static final Color4f BAR_COLOR = new Color4f(0.25f, 1f, 0.25f, 1f);
	private final class_310 client = class_310.method_1551();
	private final LitematicMesh mesh;
	private final InteractionProfile profile;

	private final double horizontalSize;
	private final double verticalSize;
	private final int xSize;
	private final int ySize;
	private final int zSize;
	private int progressBarCooldown = 30;

	public PreviewRenderer(LitematicaSchematic schematic, InteractionProfile profile) {
		this.profile = profile;
		this.mesh = new LitematicMesh(Objects.requireNonNull(schematic,
			"No available schematic to load"));
		final var dimensions = mesh.dimensions();
		this.xSize = (int) dimensions.method_17939();
		this.ySize = (int) dimensions.method_17940();
		this.zSize = (int) dimensions.method_17941();
		var shortestSide = Math.min(xSize, zSize);
		var longestSide = Math.max(xSize, zSize);
		this.horizontalSize = shortestSide * MAX_BLOCK_WIDTH + longestSide - shortestSide;
		this.verticalSize = longestSide * Math.tan(profile.slant()) + ySize;
	}

	public void render(class_332 context, int x, int y, int size) {
		this.profile.set(x, y, size);
		RenderUtils.drawOutlinedBox(x, y, size, size, -1610612736, -6710887);
		if (this.mesh.canRender()) {
			drawIntoActiveFramebuffer(context, x, y, size);
		} else {
			renderProgressBar(x, y, size);
		}
	}

	private void renderProgressBar(int x, int y, int size) {
		if (this.progressBarCooldown > 0) {
			this.progressBarCooldown--;
			return;
		}

		int barWidth = size - 4;
		int barHeight = 8;
		int barX = x + 2;
		int barY = y + size / 2 - 4;
		int fill = (int) (this.mesh.buildProgress() * (barWidth - 2));

		RenderUtils.drawOutlinedBox(barX, barY, barWidth, barHeight, -1610612736, -6710887);
		RenderUtils.drawRect(barX + 1, barY + 1, fill, barHeight - 2, BAR_COLOR.intValue);
	}

	private void emitVertices(class_4587 matrices, class_4597.class_4598 vertexConsumers) {
		if (!mesh.canRender()) {
			if (mesh.state() == LitematicMesh.MeshState.CORRUPT) return;

			mesh.scheduleRebuild();
			return;
		}

		matrices.method_34426();
		matrices.method_46416(-xSize / 2f, -ySize / 2f, -zSize / 2f);

		final var blockEntities = mesh.renderInfo().blockEntities();
		blockEntities.forEach((blockPos, entity) -> {
			matrices.method_22903();
			matrices.method_46416(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
			client.method_31975().method_3555(entity, 0, matrices, vertexConsumers);
			matrices.method_22909();
		});

		applyLight(RenderSystem.getModelViewMatrix());

		final var entities = mesh.renderInfo().entities();
		entities.forEach((vec3d, entry) -> {
			client.method_1561().method_3954(entry.entity(), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, entry.entity().method_5705(0), 0, matrices, vertexConsumers, entry.light());
			applyLight(RenderSystem.getModelViewMatrix());
		});
	}

	private void drawIntoActiveFramebuffer(class_332 context, int x, int y, int size) {
		class_1041 window = client.method_22683();
		float aspectRatio = window.method_4489() / (float) window.method_4506();

		RenderSystem.backupProjectionMatrix();
		Matrix4f projectionMatrix = new Matrix4f().setOrtho(-aspectRatio, aspectRatio, -1, 1, -1000, 3000);
		RenderSystem.setProjectionMatrix(projectionMatrix, class_8251.field_43361);

		// Prepare model view matrix
		final var modelViewStack = RenderSystem.getModelViewStack();
		modelViewStack.pushMatrix();
		modelViewStack.identity();

		context.method_44379(x + 1, y + 1, x + size - 2, y + size - 2);

		// Position
		translateToCoords(modelViewStack, (int) (x + this.profile.dx() + size / 2), (int) (y + this.profile.dy() + size / 2));

		// Rotation
		modelViewStack.rotate(class_7833.field_40714.rotation((float) this.profile.slant()));
		modelViewStack.rotate(class_7833.field_40716.rotation((float) this.profile.angle()));

		// Scale
		float scale = scaleFactor(size) * this.profile.scale();
		modelViewStack.scale(scale, scale, scale);

		RenderSystem.applyModelViewMatrix();

		RenderSystem.runAsFancy(() -> {
			// Emit untransformed vertices
			this.emitVertices(
				new class_4587(),
				class_310.method_1551().method_22940().method_23000()
			);

			// --> Draw
			this.draw(modelViewStack);
		});

		context.method_44380();
		modelViewStack.popMatrix();
		RenderSystem.applyModelViewMatrix();
		RenderSystem.restoreProjectionMatrix();
	}

	public void draw(Matrix4f modelViewMatrix) {
		if (!mesh.canRender()) return;

		applyLight(modelViewMatrix);

		final var meshStack = new class_4587();
		meshStack.method_34425(modelViewMatrix);
		meshStack.method_46416(-xSize / 2f, -ySize / 2f, -zSize / 2f);
		this.mesh.render(meshStack);
	}

	private void applyLight(Matrix4f viewMatrix) {
		Matrix4f lightTransform = new Matrix4f(viewMatrix);
		Vector4f lightDirection = new Vector4f(0, 0.35F, 0.25F, 0);
		lightTransform.invert();
		lightDirection.mul(lightTransform);

		final var transformedLightDirection = new Vector3f(lightDirection.x, lightDirection.y, lightDirection.z);
		RenderSystem.setShaderLights(transformedLightDirection, transformedLightDirection);

		client.method_22940().method_23000().method_22993();
	}

	private void translateToCoords(Matrix4fStack matrixStack, int x, int y) {
		final class_437 screen = this.client.field_1755;
		assert screen != null;
		final int w = screen.field_22789;
		final int h = screen.field_22790;
		matrixStack.translate((2f * x - w) / h, -(2f * y - h) / h, 0);
	}

	private float scaleFactor(int size) {
		assert this.client.field_1755 != null;
		return (float) ((size * 2) / (Math.max(this.horizontalSize, this.verticalSize) * this.client.field_1755.field_22790));
	}

	private int scale(int val) {
		return (int) (val * this.client.method_22683().method_4495());
	}
}
