package dev.kikugie.techutils.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.client.render.*;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL30;

/**
 * Taken from <a href="https://modrinth.com/plugin/cae2">Client Storage</a> by samolego.
 *
 * @see <a href="https://github.com/samolego/ClientStorage/blob/master/fabric-client/src/main/java/org/samo_lego/clientstorage/fabric_client/render/TransparencyBuffer.java">TransparencyBuffer.java</a>
 */
public class TransparencyBuffer {
	private static final class_276 framebuffer;
	private static int previousFramebuffer;

	static {
		class_1041 window = class_310.method_1551().method_22683();
		framebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
		framebuffer.method_1236(0, 0, 0, 0);
	}

	public static void prepareExtraFramebuffer() {
		// Setup extra framebuffer to draw into
		previousFramebuffer = GlStateManager.getBoundFramebuffer();
		framebuffer.method_1230(class_310.field_1703);
		framebuffer.method_1235(false);
	}

	public static void preInject() {
		RenderSystem.enableBlend();
		RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 0.5f);
	}

	public static void drawExtraFramebuffer(class_332 context) {
		// Restore the original framebuffer
		GlStateManager._glBindFramebuffer(GL30.GL_FRAMEBUFFER, previousFramebuffer);
		drawUntexturedQuad(context,
			0,
			0,
			context.method_51421(),
			context.method_51443(),
			0,
			framebuffer.field_1481,
			framebuffer.field_1482,
			-framebuffer.field_1481,
			framebuffer.field_1482,
			framebuffer.field_1481);
	}

	public static void postInject() {
		RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
	}

	public static void resizeDisplay() {
		class_1041 window = class_310.method_1551().method_22683();
		framebuffer.method_1234(window.method_4489(), window.method_4506(), class_310.field_1703);
	}

	public static void drawUntexturedQuad(class_332 context, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
		drawUntexturedQuad(context,
			x,
			x + width,
			y,
			y + height,
			0,
			(u + 0.0F) / (float) textureWidth,
			(u + (float) regionWidth) / (float) textureWidth,
			(v + 0.0F) / (float) textureHeight,
			(v + (float) regionHeight) / (float) textureHeight);
	}

	private static void drawUntexturedQuad(class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
		RenderSystem.setShaderTexture(0, framebuffer.method_30277());
		RenderSystem.setShader(class_757::method_34542);
		RenderSystem.backupProjectionMatrix();
		Matrix4f newProjMat = new Matrix4f()
			.setOrtho(
				0,
				(float) x2,
				(float) y2,
				0,
				1000.0F,
				21000.0F
			);
		RenderSystem.setProjectionMatrix(newProjMat, class_8251.field_43361);

		Matrix4f posMat = context.method_51448().method_23760().method_23761();
		class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
		bufferBuilder.method_22918(posMat, (float) x1, (float) y1, (float) z).method_22913(u1, v1);
		bufferBuilder.method_22918(posMat, (float) x1, (float) y2, (float) z).method_22913(u1, v2);
		bufferBuilder.method_22918(posMat, (float) x2, (float) y2, (float) z).method_22913(u2, v2);
		bufferBuilder.method_22918(posMat, (float) x2, (float) y1, (float) z).method_22913(u2, v1);

		class_286.method_43433(bufferBuilder.method_60800());
		RenderSystem.restoreProjectionMatrix();
	}
}
