package dev.kikugie.techutils.util;

import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1606;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2480;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2627;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_310;
import net.minecraft.class_5628;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_9336;

public class ContainerUtils {
	public static Optional<class_1263> validateContainer(class_1937 world, class_2338 pos, class_2680 state) {
		if (state.method_26204() instanceof class_2343 provider) {
			class_2586 blockEntity;
			if (world != null && InventoryUtils.getTargetInventory(world, pos) instanceof InventoryOverlay.Context ctx && ctx.be() instanceof class_2586 be) {
				blockEntity = be;
			} else {
				blockEntity = provider.method_10123(pos, state);
			}
			if (blockEntity instanceof class_1263 inventory)
				return Optional.of(inventory);
		}
		return Optional.empty();
	}

	public static Optional<class_1263> validateContainer(class_2338 pos, class_2680 state) {
		return validateContainer(null, pos, state);
	}

	public static boolean isChestAccessible(class_1936 world, class_2338 pos, class_2680 state) {
		assert state.method_26204() instanceof class_2281;
		if (class_2281.method_9756(world, pos))
			return false;

		class_2745 type = state.method_11654(class_2281.field_10770);
		if (type == class_2745.field_12569)
			return true;

		class_2338 adjacent = pos.method_10081(class_2281.method_9758(state).method_10163());
		return world.method_8320(adjacent).method_26204() != state.method_26204()
			|| !class_2281.method_9756(world, adjacent);
	}

	public static boolean isShulkerBoxAccessible(class_1936 world, class_2338 pos, class_2680 state) {
		assert state.method_26204() instanceof class_2480;
		class_2627 box = (class_2627) world.method_8321(pos);
		if (box == null || box.method_11313() != class_2627.class_2628.field_12065)
			return true;

		return world.method_18026(class_1606
			.method_33347(1.0F, state.method_11654(class_2480.field_11496), 0.0F, 0.5F)
			.method_996(pos).method_1011(1.0E-6D));
	}

	public static List<class_2561> getFormattedComponents(class_1799 stack) {
		var ops = class_6903.method_46632(class_2509.field_11560, class_310.method_1551().field_1687.method_30349());
		var lines = new ArrayList<class_2561>();
		for (class_9336<?> component : stack.method_57353()) {
			component.method_57943(ops).mapOrElse(
				nbt -> {
					var text = class_2561.method_43473();
					text.method_27694(style -> style.method_10977(class_124.field_1068).method_10978(false));
					text.method_10852(class_2561.method_43470(String.valueOf(class_7923.field_49658.method_10221(component.comp_2443())))
						.method_27694(style -> style.method_10977(class_124.field_1080))
					);
					text.method_27693(" => ");

					var prettyLines = prettifyNbt(nbt);
					text.method_10852(prettyLines.getFirst());

					lines.add(text);
					lines.addAll(prettyLines.subList(1, prettyLines.size()));

					return null;
				},
				e -> {
					var error = class_2561.method_43470(
						"Failed to encode component '%s' - %s"
							.formatted(class_7923.field_49658.method_10221(component.comp_2443()), e.message())
					).method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false));
					lines.add(error);
					return null;
				}
			);
		}
		return lines;
	}

	public static List<class_2561> prettifyNbt(class_2520 nbt) {
		var style = class_2583.field_24360.method_10977(class_124.field_1068).method_10978(false);
		var lines = new ArrayList<class_2561>();

		var currentLine = class_2561.method_43473().method_10862(style);
		lines.add(currentLine);
		class_2561 prettyPrintedText = new class_5628("    ").method_32305(nbt);
		for (class_2561 sibling : prettyPrintedText.method_10855()) {
			String string = sibling.getString();
			if (string.contains("\n")) {
				var parts = string.split("\n", 2);

				if (!parts[0].isEmpty())
					currentLine.method_10852(class_2561.method_43470(parts[0]).method_10862(sibling.method_10866()));

				currentLine = class_2561.method_43473().method_10862(style);
				lines.add(currentLine);

				if (!parts[1].isEmpty())
					currentLine.method_10852(class_2561.method_43470(parts[1]).method_10862(sibling.method_10866()));
			} else {
				currentLine.method_10852(sibling);
			}
		}

		return lines;
	}
}
