package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoCalculator;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_761;
import java.util.function.Function;

@SuppressWarnings("UnstableApiUsage")
public class WorldMesherRenderContext extends AbstractBlockRenderContext {

	private final class_1920 blockView;
	private final Function<class_1921, class_4588> bufferFunc;

	public WorldMesherRenderContext(class_1920 blockView, Function<class_1921, class_4588> bufferFunc) {
		this.blockView = blockView;
		this.bufferFunc = bufferFunc;

		this.blockInfo.prepareForWorld(blockView, true);
		this.blockInfo.random = class_5819.method_43047();
	}

	public void tessellateBlock(class_1920 blockView, class_2680 blockState, class_2338 blockPos, final class_1087 model, class_4587 matrixStack) {
		try {
			class_243 vec3d = blockState.method_26226(blockView, blockPos);
			matrixStack.method_22904(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);

			this.matrix = matrixStack.method_23760().method_23761();
			this.normalMatrix = matrixStack.method_23760().method_23762();

			blockInfo.recomputeSeed = true;

			aoCalc.clear();
			blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
			model.emitBlockQuads(blockInfo.blockView, blockInfo.blockState, blockInfo.blockPos, blockInfo.randomSupplier, this);
		} catch (Throwable throwable) {
			class_128 crashReport = class_128.method_560(throwable, "Tessellating block in WorldMesher mesh");
			class_129 crashReportSection = crashReport.method_562("Block being tessellated");
			class_129.method_586(crashReportSection, blockView, blockPos, blockState);
			throw new class_148(crashReport);
		}
	}

	@Override
	protected AoCalculator createAoCalc(BlockRenderInfo blockInfo) {
		return new AoCalculator(blockInfo) {
			@Override
			public int light(class_2338 pos, class_2680 state) {
				return class_761.method_23793(WorldMesherRenderContext.this.blockView, state, pos);
			}

			@Override
			public float ao(class_2338 pos, class_2680 state) {
				return AoLuminanceFix.INSTANCE.apply(WorldMesherRenderContext.this.blockView, pos, state);
			}
		};
	}

	@Override
	protected class_4588 getVertexConsumer(class_1921 layer) {
		return this.bufferFunc.apply(layer);
	}
}
