/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.config;

import com.google.common.collect.ImmutableList;
import dev.kikugie.techutils.Reference;
import dev.kikugie.techutils.config.Configs;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import java.util.Objects;

public class ConfigGui
extends GuiConfigsBase {
    private static GuiTabs tab = GuiTabs.LITEMATICA;

    public ConfigGui() {
        super(10, 50, "techutils", null, "techutils.config.title", new Object[]{Reference.MOD_VERSION});
    }

    public void initGui() {
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        int rows = 1;
        for (GuiTabs tab : GuiTabs.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.field_22789 - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createButton(x, y, width, tab);
        }
        if (rows > 1) {
            int scrollbarPosition = Objects.requireNonNull((WidgetListConfigOptions)this.getListWidget()).getScrollbar().getValue();
            this.setListPosition(this.getListX(), 50 + (rows - 1) * 22);
            this.reCreateListWidget();
            ((WidgetListConfigOptions)this.getListWidget()).getScrollbar().setValue(scrollbarPosition);
            ((WidgetListConfigOptions)this.getListWidget()).refreshEntries();
        }
    }

    private int createButton(int x, int y, int width, GuiTabs tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(ConfigGui.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        GuiTabs tab = ConfigGui.tab;
        ImmutableList<IConfigBase> configs = switch (tab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Configs.LITEMATIC_CONFIGS.get();
            case 1 -> Configs.WORLDEDIT_CONFIGS.get();
            case 2 -> Configs.MISC_CONFIGS.get();
        };
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum GuiTabs {
        LITEMATICA("litematica"),
        WORLDEDIT("worldedit"),
        MISC("misc");

        private final String translationKey;

        private GuiTabs(String translationKey) {
            this.translationKey = "techutils.config.category." + translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private record ButtonListener(GuiTabs tab, ConfigGui parent) implements IButtonActionListener
    {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            this.parent.reCreateListWidget();
            Objects.requireNonNull((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

