/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.config.MiscConfigs;
import dev.kikugie.techutils.config.WorldEditConfigs;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.io.File;
import java.util.ArrayList;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "techutils.json";
    public static LitematicConfigs LITEMATIC_CONFIGS = new LitematicConfigs();
    public static WorldEditConfigs WORLDEDIT_CONFIGS = new WorldEditConfigs();
    public static MiscConfigs MISC_CONFIGS = new MiscConfigs();

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectory(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"litematica", LITEMATIC_CONFIGS.get());
            ConfigUtils.readConfigBase((JsonObject)root, (String)"worldedit", WORLDEDIT_CONFIGS.get());
            ConfigUtils.readConfigBase((JsonObject)root, (String)"misc", MISC_CONFIGS.get());
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectory();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"litematica", LITEMATIC_CONFIGS.get());
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"worldedit", WORLDEDIT_CONFIGS.get());
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"misc", MISC_CONFIGS.get());
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class BaseConfigs {
        public final ImmutableList<IConfigBase> OPTIONS;

        public BaseConfigs(ImmutableList<IConfigBase> options) {
            this.OPTIONS = options;
        }

        public ImmutableList<IConfigBase> get() {
            return this.OPTIONS;
        }

        public ImmutableList<IHotkey> getHotkeys() {
            ArrayList<IHotkey> list = new ArrayList<IHotkey>();
            for (IConfigBase configValue : this.OPTIONS) {
                if (!(configValue instanceof IHotkey)) continue;
                list.add((IHotkey)configValue);
            }
            return ImmutableList.copyOf(list);
        }

        public ImmutableList<IKeybind> getKeybinds() {
            ArrayList<IKeybind> list = new ArrayList<IKeybind>();
            for (IConfigBase configValue : this.OPTIONS) {
                if (!(configValue instanceof IHotkey)) continue;
                list.add(((IHotkey)configValue).getKeybind());
            }
            return ImmutableList.copyOf(list);
        }
    }
}

