/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.containerscan;

import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.feature.containerscan.LinkedStorageEntry;
import dev.kikugie.techutils.util.ContainerUtils;
import dev.kikugie.techutils.util.LocalPlacementPos;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class PlacementContainerAccess {
    public static LinkedStorageEntry getEntry(class_2338 worldPos, class_2680 worldState) {
        return new LinkedStorageEntry(worldPos, null, PlacementContainerAccess.getSchematicInventory(worldPos, worldState).orElse(null));
    }

    public static LinkedStorageEntry getEntry(class_2338 worldPos, class_2680 worldState, class_1277 worldInventory) {
        return new LinkedStorageEntry(worldPos, (class_1263)worldInventory, PlacementContainerAccess.getSchematicInventory(worldPos, worldState).orElse(null));
    }

    public static Optional<class_1277> getSchematicInventory(class_2338 worldPos, class_2680 worldState) {
        class_2745 type = PlacementContainerAccess.getChestType(worldState);
        if (type == class_2745.field_12569) {
            return PlacementContainerAccess.getSchematicInventoryInternal(worldPos, worldState);
        }
        class_2338 adjacentChest = worldPos.method_10081(class_2281.method_9758((class_2680)worldState).method_10163());
        assert (class_310.method_1551().field_1687 != null);
        class_2680 adjacentState = class_310.method_1551().field_1687.method_8320(adjacentChest);
        Optional<class_1277> opt1 = PlacementContainerAccess.getSchematicInventoryInternal(worldPos, worldState);
        Optional<class_1277> opt2 = PlacementContainerAccess.getSchematicInventoryInternal(adjacentChest, adjacentState);
        if (opt1.isEmpty() && opt2.isEmpty()) {
            return Optional.empty();
        }
        class_1277 chest1 = opt1.orElse(new class_1277(27));
        class_1277 chest2 = opt2.orElse(new class_1277(27));
        return type == class_2745.field_12571 ? Optional.of(PlacementContainerAccess.merge((class_1263)chest1, (class_1263)chest2)) : Optional.of(PlacementContainerAccess.merge((class_1263)chest2, (class_1263)chest1));
    }

    public static Optional<class_1277> getSchematicInventoryInternal(class_2338 worldPos, class_2680 worldState) {
        LocalPlacementPos placementPos;
        block6: {
            block5: {
                class_1263 class_12632;
                Optional<class_1263> dummyInv = ContainerUtils.validateContainer(worldPos, worldState);
                if (dummyInv.isEmpty()) {
                    return Optional.empty();
                }
                Optional<LocalPlacementPos> optionalPos = LocalPlacementPos.get(worldPos);
                if (optionalPos.isEmpty()) {
                    return Optional.empty();
                }
                placementPos = optionalPos.get();
                Optional<class_1263> schemInv = ContainerUtils.validateContainer(worldPos, placementPos.blockState());
                if (schemInv.isEmpty() || dummyInv.get().method_5439() != schemInv.get().method_5439() || !((class_12632 = schemInv.get()) instanceof class_2586)) break block5;
                class_2586 schemBE = (class_2586)class_12632;
                class_12632 = dummyInv.get();
                if (!(class_12632 instanceof class_2586)) break block5;
                class_2586 dummyBE = (class_2586)class_12632;
                if (schemBE.method_11017() == dummyBE.method_11017()) break block6;
            }
            return Optional.empty();
        }
        return Optional.ofNullable(PlacementContainerAccess.getItems(placementPos));
    }

    private static class_1277 merge(class_1263 first, class_1263 second) {
        class_1258 combined = new class_1258(first, second);
        class_1277 inventory = new class_1277(combined.method_5439());
        for (int i = 0; i < combined.method_5439(); ++i) {
            inventory.method_5447(i, combined.method_5438(i));
        }
        return inventory;
    }

    private static void sendError(String message) {
        TechUtilsMod.LOGGER.warn(message);
    }

    private static class_2745 getChestType(class_2680 state) {
        if (!(state.method_26204() instanceof class_2281)) {
            return class_2745.field_12569;
        }
        return (class_2745)state.method_11654((class_2769)class_2281.field_10770);
    }

    @Nullable
    private static class_1277 getItems(LocalPlacementPos placementPos) {
        Map blockEntities = placementPos.placement().getSchematic().getBlockEntityMapForRegion(placementPos.region());
        if (blockEntities == null) {
            return null;
        }
        class_2487 nbt = (class_2487)blockEntities.get(placementPos.pos());
        if (nbt == null) {
            return null;
        }
        class_5455 lookup = class_310.method_1551().field_1687.method_30349();
        class_2586 blockEntity = class_2586.method_11005((class_2338)placementPos.pos(), (class_2680)placementPos.blockState(), (class_2487)nbt, (class_7225.class_7874)lookup);
        if (!(blockEntity instanceof class_1263)) {
            return null;
        }
        class_1263 schematicInventory = (class_1263)blockEntity;
        class_1277 inventory = new class_1277(schematicInventory.method_5439());
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = schematicInventory.method_5438(i);
            inventory.method_5447(i, stack);
        }
        return inventory;
    }
}

