/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.containerscan.scanners;

import com.google.common.collect.Iterables;
import dev.kikugie.techutils.feature.containerscan.LinkedStorageEntry;
import dev.kikugie.techutils.feature.containerscan.PlacementContainerAccess;
import dev.kikugie.techutils.feature.containerscan.handlers.InteractionHandler;
import dev.kikugie.techutils.feature.containerscan.scanners.Scanner;
import dev.kikugie.techutils.feature.containerscan.screens.BlockingScreenHandler;
import dev.kikugie.techutils.render.outline.OutlineRenderer;
import dev.kikugie.techutils.util.ContainerUtils;
import dev.kikugie.techutils.util.LocalPlacementPos;
import dev.kikugie.techutils.util.ValidBox;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.malilib.util.Color4f;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3936;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class InteractionScanner
implements Scanner {
    private final Map<class_2338, LinkedStorageEntry> cache = new Hashtable<class_2338, LinkedStorageEntry>();
    private final class_310 client = class_310.method_1551();
    private final class_746 player;
    private final class_638 world;
    private final class_636 interactionManager;
    @Nullable
    private final SchematicPlacement placement;
    private final Set<class_2338> waiting;
    private boolean running;

    public InteractionScanner() {
        this.player = Objects.requireNonNull(this.client.field_1724);
        this.world = Objects.requireNonNull(this.client.field_1687);
        this.interactionManager = Objects.requireNonNull(this.client.field_1761);
        this.waiting = new HashSet<class_2338>();
        this.running = true;
        this.placement = null;
    }

    public InteractionScanner(@Nullable SchematicPlacement placement) {
        this.player = Objects.requireNonNull(this.client.field_1724);
        this.world = Objects.requireNonNull(this.client.field_1687);
        this.interactionManager = Objects.requireNonNull(this.client.field_1761);
        this.waiting = new HashSet<class_2338>();
        this.running = true;
        this.placement = placement;
        this.initPlacementBlocks();
    }

    private void initPlacementBlocks() {
        if (this.placement == null) {
            return;
        }
        this.waiting.clear();
        this.cache.clear();
        LitematicaSchematic schematic = this.placement.getSchematic();
        for (String region : schematic.getAreas().keySet()) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(region);
            Map blockEntities = schematic.getBlockEntityMapForRegion(region);
            if (blockEntities == null) continue;
            assert (container != null);
            for (class_2338 pos : blockEntities.keySet()) {
                class_2680 schemState;
                class_2338 worldPos = LocalPlacementPos.getWorldPos(pos, region, this.placement);
                class_2680 worldState = this.world.method_8320(worldPos);
                if (!worldState.equals(schemState = container.get(pos.method_10263(), pos.method_10264(), pos.method_10260()))) continue;
                this.waiting.add(worldPos);
            }
        }
    }

    private Set<class_2338> getNearbyContainers() {
        class_243 camera = this.getEyesPos((class_1657)this.player);
        double reach = this.player.method_55754();
        List<class_2338> positions = this.placement != null ? this.getPlacementContainers(camera, reach) : this.getWorldContainers(camera, reach);
        HashSet<class_2338> result = new HashSet<class_2338>();
        for (class_2338 pos : positions) {
            this.validatePos(pos, camera).ifPresent(result::add);
        }
        return result;
    }

    private List<class_2338> getWorldContainers(class_243 camera, double reach) {
        class_2338 corner1 = class_2338.method_49638((class_2374)camera.method_1031(reach, reach, reach));
        class_2338 corner2 = class_2338.method_49638((class_2374)camera.method_1023(reach, reach, reach));
        return this.getAvailable(camera, reach, class_2338.method_10097((class_2338)corner1, (class_2338)corner2));
    }

    private List<class_2338> getPlacementContainers(class_243 camera, double reach) {
        class_2338 corner1 = class_2338.method_49638((class_2374)camera.method_1031(reach, reach, reach));
        class_2338 corner2 = class_2338.method_49638((class_2374)camera.method_1023(reach, reach, reach));
        ValidBox box = new ValidBox(corner1, corner2);
        return this.getAvailable(camera, reach, Iterables.filter(this.waiting, box::contains));
    }

    private List<class_2338> getAvailable(class_243 camera, double reach, Iterable<class_2338> positions) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (class_2338 pos : positions) {
            if (!this.isInReach(pos, camera, reach)) continue;
            result.add(new class_2338((class_2382)pos));
        }
        return result;
    }

    private Optional<class_2338> validatePos(class_2338 pos, class_243 camera) {
        class_2680 state = this.world.method_8320(pos);
        if (state.method_26215() || this.cache.containsKey(pos) || ContainerUtils.validateContainer(pos, state).isEmpty()) {
            return Optional.empty();
        }
        if (state.method_26204() instanceof class_2281) {
            if (!this.player.method_7325() && !ContainerUtils.isChestAccessible((class_1936)this.world, pos, state)) {
                return Optional.empty();
            }
            class_2745 type = (class_2745)state.method_11654((class_2769)class_2281.field_10770);
            if (type == class_2745.field_12569) {
                return Optional.of(pos);
            }
            class_2338 adjacent = pos.method_10081(class_2281.method_9758((class_2680)state).method_10163());
            return Optional.of(pos.method_19770((class_2374)camera) < adjacent.method_19770((class_2374)camera) ? pos : adjacent);
        }
        if (state.method_26204() instanceof class_2480) {
            return this.player.method_7325() || ContainerUtils.isShulkerBoxAccessible((class_1936)this.world, pos, state) ? Optional.of(pos) : Optional.empty();
        }
        return Optional.of(pos);
    }

    private boolean isInReach(class_2338 pos, class_243 camera, double reach) {
        double dz;
        double dy;
        double dx = camera.method_10216() - ((double)pos.method_10263() + 0.5);
        return dx * dx + (dy = camera.method_10214() - ((double)pos.method_10264() + 0.5)) * dy + (dz = camera.method_10215() - ((double)pos.method_10260() + 0.5)) * dz <= reach * reach;
    }

    private class_243 getEyesPos(class_1657 player) {
        return new class_243(player.method_23317(), player.method_23318() + (double)player.method_18381(player.method_18376()), player.method_23321());
    }

    private void register(class_2338 pos, long tick) {
        if (InteractionHandler.contains(pos)) {
            return;
        }
        class_2680 state = this.world.method_8320(pos);
        Optional<class_1263> inventory = ContainerUtils.validateContainer(pos, state);
        if (inventory.isEmpty()) {
            return;
        }
        final class_1277 worldInv = new class_1277(inventory.get().method_5439());
        LinkedStorageEntry entry = this.placement == null ? new LinkedStorageEntry(pos, (class_1263)worldInv, null) : PlacementContainerAccess.getEntry(pos, state, worldInv);
        this.cache.put(pos, entry);
        Optional<Color4f> color = entry.validate();
        Color4f red = new Color4f(1.0f, 0.0f, 0.0f, 1.0f);
        color.ifPresent(it -> OutlineRenderer.add((class_1922)this.world, red.intValue, camera -> pos.method_19770((class_2374)camera) <= 1024.0, pos));
        this.waiting.remove(pos);
        InteractionHandler.add(new InteractionHandler(this, pos, tick){

            @Override
            public boolean accept(class_437 screen) {
                class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
                player.field_7512 = new BlockingScreenHandler(((class_3936)screen).method_17577(), worldInv);
                return false;
            }
        });
        this.interact(pos, this.getEyesPos((class_1657)this.player));
    }

    private void interact(class_2338 pos, class_243 player) {
        class_243 click = class_243.method_24954((class_2382)pos).method_1031(0.5, 0.5, 0.5);
        class_3965 hit = new class_3965(click, class_2350.method_10142((double)(click.field_1352 - player.field_1352), (double)(click.field_1351 - player.field_1351), (double)(click.field_1350 - player.field_1350)), pos, false);
        this.interactionManager.method_2896(this.client.field_1724, class_1268.field_5808, hit);
    }

    @Override
    public void tick() {
        if (!this.running || this.placement != null && this.waiting.isEmpty()) {
            return;
        }
        long tick = this.world.method_8510();
        Set<class_2338> nearby = this.getNearbyContainers();
        for (class_2338 pos : nearby) {
            this.register(pos, tick);
        }
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Override
    public void stop() {
        this.running = false;
    }

    @Override
    public void update() {
        this.initPlacementBlocks();
    }
}

