/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.preview.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.kikugie.techutils.Reference;
import dev.kikugie.techutils.feature.preview.model.DummyWorld;
import dev.kikugie.techutils.feature.preview.model.DynamicRenderInfo;
import dev.kikugie.techutils.feature.preview.model.FluidVertexConsumer;
import dev.kikugie.techutils.feature.preview.model.RegionBlockView;
import dev.kikugie.techutils.mixin.preview.BlockEntityAccessor;
import dev.kikugie.techutils.util.ValidBox;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.WorldMesherRenderContext;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LitematicMesh {
    private static final Logger LOGGER = LoggerFactory.getLogger(LitematicMesh.class);
    private final LitematicaSchematic schematic;
    private final class_310 client;
    private final DummyWorld dummyWorld;
    private final class_2338 from;
    private final class_2338 to;
    private final class_238 dimensions;
    private final boolean cull;
    private final TriFunction<class_1657, class_2338, class_2338, List<class_1297>> entitySupplier;
    private DynamicRenderInfo renderInfo = DynamicRenderInfo.EMPTY;
    private MeshState state = MeshState.NEW;
    private float buildProgress = 0.0f;
    @Nullable
    private CompletableFuture<Void> buildFuture = null;
    private final Map<class_1921, class_291> bufferStorage = new HashMap<class_1921, class_291>();

    public LitematicMesh(LitematicaSchematic schematic) {
        this.schematic = schematic;
        this.client = class_310.method_1551();
        this.dummyWorld = DummyWorld.fromWorld(this.client.field_1687);
        ValidBox fullBox = this.fullBox(schematic.getAreas().values());
        this.from = fullBox.getMin();
        this.to = fullBox.getMax();
        this.cull = true;
        this.dimensions = class_238.method_54784((class_2338)this.from, (class_2338)this.to);
        this.entitySupplier = (playerEntity, blockPos, blockPos2) -> this.readEntities();
        this.scheduleRebuild();
    }

    private List<class_1297> readEntities() {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        this.schematic.getAreas().keySet().forEach(region -> {
            List schematicEntities = this.schematic.getEntityListForRegion(region);
            class_2338 offset = this.schematic.getSubRegionPosition(region);
            assert (schematicEntities != null);
            schematicEntities.forEach(entityInfo -> {
                class_1297 entity = EntityUtils.createEntityAndPassengersFromNBT((class_2487)entityInfo.nbt, (class_1937)this.dummyWorld);
                entity.method_33574(entity.method_19538().method_1031((double)Math.max(offset.method_10263(), 0), (double)Math.max(offset.method_10264(), 0), (double)Math.max(offset.method_10260(), 0)));
                entities.add(entity);
            });
        });
        return entities;
    }

    private ValidBox fullBox(Collection<Box> boxes) {
        int[] corners = new int[]{0, 0, 0, 0, 0, 0};
        for (Box box : boxes) {
            ValidBox validBox = ValidBox.of(box);
            class_2338 min = validBox.getMin();
            class_2338 max = validBox.getMax();
            corners[0] = Math.min(corners[0], min.method_10263());
            corners[1] = Math.min(corners[1], min.method_10264());
            corners[2] = Math.min(corners[2], min.method_10260());
            corners[3] = Math.max(corners[3], max.method_10263());
            corners[4] = Math.max(corners[4], max.method_10264());
            corners[5] = Math.max(corners[5], max.method_10260());
        }
        return new ValidBox(corners);
    }

    public void render(class_4587 matrices) {
        if (!this.canRender()) {
            throw new IllegalStateException("World mesh not prepared!");
        }
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_1921 translucent = class_1921.method_23583();
        this.bufferStorage.forEach((renderLayer, vertexBuffer) -> {
            if (renderLayer == translucent) {
                return;
            }
            this.drawBuffer((class_291)vertexBuffer, (class_1921)renderLayer, matrix);
        });
        if (this.bufferStorage.containsKey(translucent)) {
            this.drawBuffer(this.bufferStorage.get(translucent), translucent, matrix);
        }
        class_291.method_1354();
    }

    private void drawBuffer(class_291 vertexBuffer, class_1921 renderLayer, Matrix4f matrix) {
        renderLayer.method_23516();
        vertexBuffer.method_1353();
        vertexBuffer.method_34427(matrix, RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
        renderLayer.method_23518();
    }

    public boolean canRender() {
        return this.state.canRender;
    }

    public MeshState state() {
        return this.state;
    }

    @Deprecated(forRemoval=true)
    public MeshState getState() {
        return this.state();
    }

    public float buildProgress() {
        return this.buildProgress;
    }

    @Deprecated(forRemoval=true)
    public float getBuildProgress() {
        return this.buildProgress();
    }

    public DynamicRenderInfo renderInfo() {
        return this.renderInfo;
    }

    @Deprecated(forRemoval=true)
    public DynamicRenderInfo getRenderInfo() {
        return this.renderInfo();
    }

    public class_2338 startPos() {
        return this.from;
    }

    public class_2338 endPos() {
        return this.to;
    }

    public class_238 dimensions() {
        return this.dimensions;
    }

    public void reset() {
        this.bufferStorage.forEach((renderLayer, vertexBuffer) -> vertexBuffer.close());
        this.bufferStorage.clear();
        this.state = MeshState.NEW;
    }

    @Deprecated(forRemoval=true)
    public void clear() {
        this.reset();
    }

    public synchronized void scheduleRebuild() {
        this.scheduleRebuild(class_156.method_18349());
    }

    public synchronized CompletableFuture<Void> scheduleRebuild(Executor executor) {
        if (this.buildFuture != null) {
            return this.buildFuture;
        }
        this.buildProgress = 0.0f;
        this.state = this.state != MeshState.NEW ? MeshState.REBUILDING : MeshState.BUILDING;
        this.buildFuture = CompletableFuture.runAsync(this::build, executor).whenComplete((unused, throwable) -> {
            this.buildFuture = null;
            if (throwable == null) {
                this.state = MeshState.READY;
            } else {
                LOGGER.warn("World mesh building failed", throwable);
                this.state = MeshState.CORRUPT;
            }
        });
        return this.buildFuture;
    }

    private void build() {
        class_750 allocatorStorage = new class_750();
        class_776 blockRenderManager = this.client.method_1541();
        class_4587 matrices = new class_4587();
        HashMap builderStorage = new HashMap();
        class_5819 random = class_5819.method_43053();
        WorldMesherRenderContext renderContext = null;
        try {
            renderContext = RendererAccess.INSTANCE.getRenderer() instanceof IndigoRenderer ? new WorldMesherRenderContext((class_1920)this.dummyWorld, layer -> this.getOrCreateBuilder(allocatorStorage, builderStorage, (class_1921)layer)) : null;
        }
        catch (Throwable throwable) {
            String fabricApiVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("techutils").get()).getMetadata().getCustomValue("fabric_api_build_version").getAsString();
            LOGGER.error("Could not create a context for rendering Fabric API models. This is most likely due to an incompatible Fabric API version - this build of {} was compiled against '{}', try that instead", new Object[]{Reference.MOD_NAME, fabricApiVersion, throwable});
        }
        CompletableFuture entitiesFuture = new CompletableFuture();
        this.client.execute(() -> entitiesFuture.complete(((List)this.entitySupplier.apply((Object)this.client.field_1724, (Object)this.from, (Object)this.to.method_10069(1, 1, 1))).stream().map(entity -> {
            entity.method_5773();
            return new DynamicRenderInfo.EntityEntry((class_1297)entity, this.client.method_1561().method_23839(entity, 0.0f));
        }).toList()));
        HashMap<class_2338, class_2586> blockEntities = new HashMap<class_2338, class_2586>();
        WorldMesherRenderContext finalRenderContext = renderContext;
        this.schematic.getAreas().keySet().forEach(region -> this.buildRegion((String)region, blockEntities, matrices, blockRenderManager, allocatorStorage, builderStorage, finalRenderContext, random));
        CompletableFuture future = new CompletableFuture();
        RenderSystem.recordRenderCall(() -> {
            this.bufferStorage.forEach((renderLayer, vertexBuffer) -> vertexBuffer.close());
            this.bufferStorage.clear();
            builderStorage.forEach((renderLayer, bufferBuilder) -> {
                class_291 newBuffer = new class_291(class_291.class_8555.field_44793);
                class_9801 built = bufferBuilder.method_60794();
                if (built == null) {
                    return;
                }
                if (renderLayer == class_1921.method_23583()) {
                    built.method_60819(allocatorStorage.method_3154(renderLayer), class_8251.method_49906((float)0.0f, (float)0.0f, (float)1000.0f));
                }
                newBuffer.method_1353();
                newBuffer.method_1352(built);
                class_291 discardedBuffer = this.bufferStorage.put((class_1921)renderLayer, newBuffer);
                if (discardedBuffer != null) {
                    discardedBuffer.close();
                }
            });
            future.complete(null);
        });
        future.join();
        HashMultimap entities = HashMultimap.create();
        for (DynamicRenderInfo.EntityEntry entityEntry : (List)entitiesFuture.join()) {
            entities.put((Object)entityEntry.entity().method_19538(), (Object)entityEntry);
        }
        allocatorStorage.close();
        this.renderInfo = new DynamicRenderInfo(blockEntities, (Multimap<class_243, DynamicRenderInfo.EntityEntry>)entities);
    }

    private void buildRegion(String region, HashMap<class_2338, class_2586> blockEntities, class_4587 matrices, class_776 blockRenderManager, class_750 allocatorStorage, HashMap<class_1921, class_287> builderStorage, WorldMesherRenderContext renderContext, class_5819 random) {
        Box box = (Box)this.schematic.getAreas().get(region);
        RegionBlockView view = new RegionBlockView(Objects.requireNonNull(this.schematic.getSubRegionContainer(region)), box);
        Map schematicBlockEntities = this.schematic.getBlockEntityMapForRegion(region);
        int currentBlockIndex = 0;
        int blocksToBuild = (this.to.method_10263() - this.from.method_10263() + 1) * (this.to.method_10264() - this.from.method_10264() + 1) * (this.to.method_10260() - this.from.method_10260() + 1);
        for (class_2338 pos : class_2338.method_10097((class_2338)this.from, (class_2338)this.to)) {
            class_2343 provider;
            class_2586 blockEntity;
            this.buildProgress = (float)(++currentBlockIndex) / (float)blocksToBuild;
            class_2680 state = view.method_8320(pos);
            if (state.method_26215()) continue;
            class_2338 renderPos = pos.method_10059((class_2382)this.from);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2343 && (blockEntity = (provider = (class_2343)class_22482).method_10123(this.client.method_1560().method_24515(), state)) != null) {
                ((BlockEntityAccessor)blockEntity).setCachedState(state);
                blockEntity.method_58690(schematicBlockEntities.getOrDefault(pos, new class_2487()), (class_7225.class_7874)this.dummyWorld.method_30349());
                blockEntity.method_31662((class_1937)this.dummyWorld);
                blockEntities.put(renderPos, blockEntity);
            }
            if (!state.method_26227().method_15769()) {
                class_3610 fluidState = state.method_26227();
                class_1921 fluidLayer = class_4696.method_23680((class_3610)fluidState);
                matrices.method_22903();
                matrices.method_46416((float)(-(pos.method_10263() & 0xF)), (float)(-(pos.method_10264() & 0xF)), (float)(-(pos.method_10260() & 0xF)));
                matrices.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
                blockRenderManager.method_3352(pos, (class_1920)view, (class_4588)new FluidVertexConsumer(this.getOrCreateBuilder(allocatorStorage, builderStorage, fluidLayer), matrices.method_23760().method_23761()), state, fluidState);
                matrices.method_22909();
            }
            matrices.method_22903();
            matrices.method_46416((float)renderPos.method_10263(), (float)renderPos.method_10264(), (float)renderPos.method_10260());
            class_1921 blockLayer = class_4696.method_23679((class_2680)state);
            class_1087 model = blockRenderManager.method_3349(state);
            if (renderContext != null && !model.isVanillaAdapter()) {
                renderContext.tessellateBlock(view, state, pos, model, matrices);
            } else if (state.method_26217() == class_2464.field_11458) {
                blockRenderManager.method_3350().method_3374((class_1920)view, model, state, pos, matrices, this.getOrCreateBuilder(allocatorStorage, builderStorage, blockLayer), this.cull, random, state.method_26190(pos), class_4608.field_21444);
            }
            matrices.method_22909();
        }
    }

    private class_4588 getOrCreateBuilder(class_750 allocatorStorage, Map<class_1921, class_287> builderStorage, class_1921 layer) {
        return (class_4588)builderStorage.computeIfAbsent(layer, renderLayer -> new class_287(allocatorStorage.method_3154(layer), class_293.class_5596.field_27382, class_290.field_1590));
    }

    public static enum MeshState {
        NEW(false, false),
        BUILDING(true, false),
        REBUILDING(true, true),
        READY(false, true),
        CORRUPT(false, false);

        public final boolean isBuildStage;
        public final boolean canRender;

        private MeshState(boolean buildStage, boolean canRender) {
            this.isBuildStage = buildStage;
            this.canRender = canRender;
        }
    }

    public static class Builder {
        private final class_1920 world;
        private final TriFunction<class_1657, class_2338, class_2338, List<class_1297>> entitySupplier;
        private final class_2338 origin;
        private final class_2338 end;
        private boolean cull = true;
        private boolean useGlobalNeighbors = false;
        private boolean freezeEntities = false;
        private Runnable startAction;
        private Runnable endAction;

        @Deprecated(forRemoval=true)
        public Builder(class_1920 world, class_2338 origin, class_2338 end, Function<class_1657, List<class_1297>> entitySupplier) {
            this.startAction = () -> {};
            this.endAction = () -> {};
            this.world = world;
            this.origin = origin;
            this.end = end;
            this.entitySupplier = (player, $, $$) -> (List)entitySupplier.apply((class_1657)player);
        }

        public Builder(class_1920 world, class_2338 origin, class_2338 end, TriFunction<class_1657, class_2338, class_2338, List<class_1297>> entitySupplier) {
            this.startAction = () -> {};
            this.endAction = () -> {};
            this.world = world;
            this.origin = origin;
            this.end = end;
            this.entitySupplier = entitySupplier;
        }

        public Builder(class_1937 world, class_2338 origin, class_2338 end) {
            this((class_1920)world, origin, end, (TriFunction<class_1657, class_2338, class_2338, List<class_1297>>)((TriFunction)(except, min, max) -> world.method_8333((class_1297)except, class_238.method_54784((class_2338)min, (class_2338)max), entity -> !(entity instanceof class_1657))));
        }

        public Builder(class_1920 world, class_2338 origin, class_2338 end) {
            this(world, origin, end, (class_1657 except) -> List.of());
        }

        public Builder disableCulling() {
            this.cull = false;
            return this;
        }

        public Builder useGlobalNeighbors() {
            this.useGlobalNeighbors = true;
            return this;
        }

        public Builder freezeEntities() {
            this.freezeEntities = true;
            return this;
        }

        public Builder renderActions(Runnable startAction, Runnable endAction) {
            this.startAction = startAction;
            this.endAction = endAction;
            return this;
        }
    }
}

