/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.preview.model;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.kikugie.techutils.feature.preview.interaction.InteractionProfile;
import dev.kikugie.techutils.feature.preview.model.DynamicRenderInfo;
import dev.kikugie.techutils.feature.preview.model.LitematicMesh;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class PreviewRenderer {
    private static final double MAX_BLOCK_WIDTH = Math.cos(0.5235987755982988) * 2.0;
    private static final Color4f BAR_COLOR = new Color4f(0.25f, 1.0f, 0.25f, 1.0f);
    private final class_310 client = class_310.method_1551();
    private final LitematicMesh mesh;
    private final InteractionProfile profile;
    private final double horizontalSize;
    private final double verticalSize;
    private final int xSize;
    private final int ySize;
    private final int zSize;
    private int progressBarCooldown = 30;

    public PreviewRenderer(LitematicaSchematic schematic, InteractionProfile profile) {
        this.profile = profile;
        this.mesh = new LitematicMesh(Objects.requireNonNull(schematic, "No available schematic to load"));
        class_238 dimensions = this.mesh.dimensions();
        this.xSize = (int)dimensions.method_17939();
        this.ySize = (int)dimensions.method_17940();
        this.zSize = (int)dimensions.method_17941();
        int shortestSide = Math.min(this.xSize, this.zSize);
        int longestSide = Math.max(this.xSize, this.zSize);
        this.horizontalSize = (double)shortestSide * MAX_BLOCK_WIDTH + (double)longestSide - (double)shortestSide;
        this.verticalSize = (double)longestSide * Math.tan(profile.slant()) + (double)this.ySize;
    }

    public void render(class_332 context, int x, int y, int size) {
        this.profile.set(x, y, size);
        RenderUtils.drawOutlinedBox((int)x, (int)y, (int)size, (int)size, (int)-1610612736, (int)-6710887);
        if (this.mesh.canRender()) {
            this.drawIntoActiveFramebuffer(context, x, y, size);
        } else {
            this.renderProgressBar(x, y, size);
        }
    }

    private void renderProgressBar(int x, int y, int size) {
        if (this.progressBarCooldown > 0) {
            --this.progressBarCooldown;
            return;
        }
        int barWidth = size - 4;
        int barHeight = 8;
        int barX = x + 2;
        int barY = y + size / 2 - 4;
        int fill = (int)(this.mesh.buildProgress() * (float)(barWidth - 2));
        RenderUtils.drawOutlinedBox((int)barX, (int)barY, (int)barWidth, (int)barHeight, (int)-1610612736, (int)-6710887);
        RenderUtils.drawRect((int)(barX + 1), (int)(barY + 1), (int)fill, (int)(barHeight - 2), (int)PreviewRenderer.BAR_COLOR.intValue);
    }

    private void emitVertices(class_4587 matrices, class_4597.class_4598 vertexConsumers) {
        if (!this.mesh.canRender()) {
            if (this.mesh.state() == LitematicMesh.MeshState.CORRUPT) {
                return;
            }
            this.mesh.scheduleRebuild();
            return;
        }
        matrices.method_34426();
        matrices.method_46416((float)(-this.xSize) / 2.0f, (float)(-this.ySize) / 2.0f, (float)(-this.zSize) / 2.0f);
        Map<class_2338, class_2586> blockEntities = this.mesh.renderInfo().blockEntities();
        blockEntities.forEach((blockPos, entity) -> {
            matrices.method_22903();
            matrices.method_46416((float)blockPos.method_10263(), (float)blockPos.method_10264(), (float)blockPos.method_10260());
            this.client.method_31975().method_3555(entity, 0.0f, matrices, (class_4597)vertexConsumers);
            matrices.method_22909();
        });
        this.applyLight(RenderSystem.getModelViewMatrix());
        Multimap<class_243, DynamicRenderInfo.EntityEntry> entities = this.mesh.renderInfo().entities();
        entities.forEach((vec3d, entry) -> {
            this.client.method_1561().method_3954(entry.entity(), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, entry.entity().method_5705(0.0f), 0.0f, matrices, (class_4597)vertexConsumers, entry.light());
            this.applyLight(RenderSystem.getModelViewMatrix());
        });
    }

    private void drawIntoActiveFramebuffer(class_332 context, int x, int y, int size) {
        class_1041 window = this.client.method_22683();
        float aspectRatio = (float)window.method_4489() / (float)window.method_4506();
        RenderSystem.backupProjectionMatrix();
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(-aspectRatio, aspectRatio, -1.0f, 1.0f, -1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (class_8251)class_8251.field_43361);
        Matrix4fStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushMatrix();
        modelViewStack.identity();
        context.method_44379(x + 1, y + 1, x + size - 2, y + size - 2);
        this.translateToCoords(modelViewStack, (int)((float)x + this.profile.dx() + (float)(size / 2)), (int)((float)y + this.profile.dy() + (float)(size / 2)));
        modelViewStack.rotate((Quaternionfc)class_7833.field_40714.rotation((float)this.profile.slant()));
        modelViewStack.rotate((Quaternionfc)class_7833.field_40716.rotation((float)this.profile.angle()));
        float scale = this.scaleFactor(size) * this.profile.scale();
        modelViewStack.scale(scale, scale, scale);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.runAsFancy(() -> {
            this.emitVertices(new class_4587(), class_310.method_1551().method_22940().method_23000());
            this.draw((Matrix4f)modelViewStack);
        });
        context.method_44380();
        modelViewStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
    }

    public void draw(Matrix4f modelViewMatrix) {
        if (!this.mesh.canRender()) {
            return;
        }
        this.applyLight(modelViewMatrix);
        class_4587 meshStack = new class_4587();
        meshStack.method_34425(modelViewMatrix);
        meshStack.method_46416((float)(-this.xSize) / 2.0f, (float)(-this.ySize) / 2.0f, (float)(-this.zSize) / 2.0f);
        this.mesh.render(meshStack);
    }

    private void applyLight(Matrix4f viewMatrix) {
        Matrix4f lightTransform = new Matrix4f((Matrix4fc)viewMatrix);
        Vector4f lightDirection = new Vector4f(0.0f, 0.35f, 0.25f, 0.0f);
        lightTransform.invert();
        lightDirection.mul((Matrix4fc)lightTransform);
        Vector3f transformedLightDirection = new Vector3f(lightDirection.x, lightDirection.y, lightDirection.z);
        RenderSystem.setShaderLights((Vector3f)transformedLightDirection, (Vector3f)transformedLightDirection);
        this.client.method_22940().method_23000().method_22993();
    }

    private void translateToCoords(Matrix4fStack matrixStack, int x, int y) {
        class_437 screen = this.client.field_1755;
        assert (screen != null);
        int w = screen.field_22789;
        int h = screen.field_22790;
        matrixStack.translate((2.0f * (float)x - (float)w) / (float)h, -(2.0f * (float)y - (float)h) / (float)h, 0.0f);
    }

    private float scaleFactor(int size) {
        assert (this.client.field_1755 != null);
        return (float)((double)(size * 2) / (Math.max(this.horizontalSize, this.verticalSize) * (double)this.client.field_1755.field_22790));
    }

    private int scale(int val) {
        return (int)((double)val * this.client.method_22683().method_4495());
    }
}

