/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.feature.worldedit;

import com.sk89q.worldedit.fabric.net.handler.WECUIPacketHandler;
import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.feature.worldedit.WorldEditStorage;
import dev.kikugie.techutils.feature.worldedit.WorldEditSync;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8710;

public class WorldEditNetworkHandler {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"worldedit", (String)"cui");
    private static final int PROTOCOL = 4;
    private static WorldEditNetworkHandler instance;
    public final WorldEditStorage storage = WorldEditStorage.init();
    private boolean worldEditConnected = false;
    private boolean yoinkPackets = false;

    private WorldEditNetworkHandler() {
        Set receivers = ClientPlayNetworking.getGlobalReceivers();
        if (receivers.contains(CHANNEL)) {
            this.yoinkPackets = true;
            return;
        }
        ClientPlayNetworking.registerReceiver((class_8710.class_9154)WECUIPacketHandler.CuiPacket.TYPE, (payload, context) -> this.onPacket(payload.text()));
        this.handshake();
    }

    public static WorldEditNetworkHandler initHandler() {
        if (class_310.method_1551().field_1687 == null) {
            throw new RuntimeException("Registering WorldEdit handler in non-world context!");
        }
        instance = new WorldEditNetworkHandler();
        return instance;
    }

    public static Optional<WorldEditNetworkHandler> getInstance() {
        return Optional.ofNullable(instance);
    }

    public void onYoinkedPacket(class_8710 payload) {
        if (!this.yoinkPackets) {
            return;
        }
        this.onPacket(((WECUIPacketHandler.CuiPacket)payload).text());
    }

    private void onPacket(String message) {
        if (!this.worldEditConnected) {
            this.worldEditConnected = true;
            TechUtilsMod.LOGGER.info("WorldEdit connected");
            WorldEditSync.getInstance().ifPresent(WorldEditSync::onWorldEditConnected);
        }
        if (message.isEmpty()) {
            TechUtilsMod.LOGGER.warn("WorldEditNetworkHandler#onPacket(): Received CUI packet of length zero");
            return;
        }
        String[] split = message.split("\\|", -1);
        boolean multi = split[0].startsWith("+");
        String type = split[0].substring(multi ? 1 : 0);
        String[] args = message.substring(type.length() + (multi ? 2 : 1)).split("\\|", -1);
        TechUtilsMod.LOGGER.info(message);
        this.handlePacket(type, args);
    }

    private void handlePacket(String type, String[] args) {
        if (type.equals("s")) {
            this.storage.setCuboid(args[0].equals("cuboid"));
            return;
        }
        if (!type.equals("p") || !this.storage.isCuboid()) {
            return;
        }
        try {
            int p = Integer.parseInt(args[0]);
            class_2338 pos = new class_2338(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
            this.storage.setPos(p == 0, pos);
        }
        catch (NumberFormatException e) {
            TechUtilsMod.LOGGER.warn("WorldEditCUINetworkHandler#handlePacket(): Failed int parsing of position");
            e.printStackTrace();
        }
    }

    private void handshake() {
        String message = "v|4";
        ClientPlayNetworking.send((class_8710)new WECUIPacketHandler.CuiPacket(message));
    }
}

