/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.mixin.mod.litematica;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.serialization.DynamicOps;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.feature.containerscan.verifier.BlockMismatchExtension;
import dev.kikugie.techutils.feature.containerscan.verifier.SchematicVerifierExtension;
import dev.kikugie.techutils.mixin.mod.litematica.ItemUtilsAccessor;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.WorldUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SchematicVerifier.class}, remap=false)
public abstract class SchematicVerifierMixin<InventoryBE extends class_2586>
extends TaskBase
implements SchematicVerifierExtension {
    @Shadow
    @Final
    private static class_2338.class_2339 MUTABLE_POS;
    @Shadow
    private SchematicPlacement schematicPlacement;
    @Shadow
    private class_638 worldClient;
    @Unique
    private final Set<Pair<InventoryBE, InventoryBE>> wrongInventories = new ReferenceOpenHashSet();
    @Unique
    private final ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> wrongInventoriesPositions = ArrayListMultimap.create();
    @Unique
    private final List<class_2338> wrongInventoriesPositionsClosest = new ArrayList<class_2338>();
    @Unique
    private final List<SchematicVerifier.BlockMismatch> selectedInventoryMismatches = new ArrayList<SchematicVerifier.BlockMismatch>();

    @Shadow
    protected abstract void addAndSortPositions(SchematicVerifier.MismatchType var1, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> var2, List<class_2338> var3, int var4);

    @Override
    public List<SchematicVerifier.BlockMismatch> getSelectedInventoryMismatches$techutils() {
        return Collections.unmodifiableList(this.selectedInventoryMismatches);
    }

    @Override
    public int getWrongInventoriesCount$techutils() {
        return this.wrongInventories.size();
    }

    @ModifyExpressionValue(method={"verifyChunks"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/world/ChunkManagerSchematic;isChunkLoaded(II)Z", remap=true)})
    private boolean ensureInventoriesAreLoaded(boolean isLoaded, @Local class_1923 pos) {
        return isLoaded && this.canProcessChunk(pos);
    }

    @Redirect(method={"verifyChunks"}, slice=@Slice(from=@At(value="INVOKE", target="Lfi/dy/masa/litematica/world/ChunkManagerSchematic;isChunkLoaded(II)Z")), at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getChunk(II)Lnet/minecraft/world/chunk/WorldChunk;", ordinal=0, remap=true))
    private class_2818 pickBestWorld(class_638 clientWorld, int x, int z) {
        class_638 class_6382;
        class_1937 class_19372 = WorldUtils.getBestWorld((class_310)this.mc);
        if (class_19372 instanceof class_1937) {
            class_1937 world = class_19372;
            class_6382 = world;
        } else {
            class_6382 = clientWorld;
        }
        return class_6382.method_8497(x, z);
    }

    @Unique
    private boolean canProcessChunk(class_1923 pos) {
        EntitiesDataStorage eds = EntitiesDataStorage.getInstance();
        if ((eds.hasServuxServer() || eds.getIfReceivedBackupPackets()) && Objects.equals(eds.getWorld(), this.worldClient) && !eds.hasCompletedChunk(pos)) {
            if (eds.hasPendingChunk(pos)) {
                return false;
            }
            ImmutableMap volumes = this.schematicPlacement.getBoxesWithinChunk(pos.field_9181, pos.field_9180);
            int minY = 319;
            int maxY = -64;
            for (Map.Entry volumeEntry : volumes.entrySet()) {
                IntBoundingBox bb = (IntBoundingBox)volumeEntry.getValue();
                minY = Math.min(bb.minY, minY);
                maxY = Math.max(bb.maxY, maxY);
            }
            if (eds.hasServuxServer()) {
                eds.requestServuxBulkEntityData(pos, minY, maxY);
            } else if (eds.getIfReceivedBackupPackets()) {
                eds.requestBackupBulkEntityData(pos, minY, maxY);
            }
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, this.worldClient, 0);
    }

    @Inject(method={"verifyChunk"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;checkBlockStates(IIILnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V", remap=true)})
    private void checkInventories(class_2791 chunkClient, class_2791 chunkSchematic, IntBoundingBox box, CallbackInfoReturnable<Boolean> cir) {
        class_1263 found;
        class_1263 expected;
        block7: {
            block6: {
                class_2586 expectedBE = chunkSchematic.method_8321((class_2338)MUTABLE_POS);
                class_2586 foundBE = chunkClient.method_8321((class_2338)MUTABLE_POS);
                if (!(expectedBE instanceof class_1263)) break block6;
                expected = (class_1263)expectedBE;
                if (!(foundBE instanceof class_1263)) break block6;
                found = (class_1263)foundBE;
                if (expectedBE.method_11017() == foundBE.method_11017()) break block7;
            }
            return;
        }
        int size = expected.method_5439();
        if (size != found.method_5439()) {
            return;
        }
        IdentityHashMap<class_2680, class_1799> itemsForStates = ItemUtilsAccessor.getItemsForStates();
        boolean verifyItemComponents = LitematicConfigs.VERIFY_ITEM_COMPONENTS.getBooleanValue();
        for (int i = size - 1; i >= 0; --i) {
            class_1799 expectedStack = expected.method_5438(i);
            class_1799 foundStack = found.method_5438(i);
            Boolean predFailed = null;
            class_2073 class_20732 = ItemPredicateUtils.getPredicate(expectedStack);
            if (class_20732 instanceof class_2073) {
                class_2073 predicate = class_20732;
                predFailed = !predicate.method_8970(foundStack);
            }
            if (!(predFailed != null ? predFailed != false : expectedStack.method_7909() != foundStack.method_7909() || expectedStack.method_7947() != foundStack.method_7947() || verifyItemComponents && !Objects.equals(expectedStack.method_57353(), foundStack.method_57353()))) continue;
            class_2338 pos = MUTABLE_POS.method_10062();
            Pair<class_2586, class_2586> pair = this.populateTooltipsIfNecessary((class_2586)expected, (class_2586)found, verifyItemComponents);
            this.wrongInventories.add(pair);
            this.warCrime((class_2586)pair.getLeft(), (class_2586)pair.getRight(), itemsForStates, pos);
            break;
        }
    }

    @Unique
    private void warCrime(InventoryBE expected, InventoryBE found, IdentityHashMap<class_2680, class_1799> itemsForStates, class_2338 pos) {
        class_2680 foundState = found.method_11010();
        HashMap<class_2746, Boolean> propertyMap = new HashMap<class_2746, Boolean>(foundState.method_11656());
        propertyMap.put(class_2746.method_11825((String)"war_crime"), true);
        class_2680 newState = new class_2680(foundState.method_26204(), new Reference2ObjectArrayMap(propertyMap), null);
        itemsForStates.put(newState, ItemUtils.getItemForBlock((class_1937)this.worldClient, (class_2338)pos, (class_2680)foundState, (boolean)true));
        this.wrongInventoriesPositions.put((Object)Pair.of((Object)expected.method_11010(), (Object)newState), (Object)pos);
        found.method_31664(newState);
    }

    @Unique
    private Pair<InventoryBE, InventoryBE> populateTooltipsIfNecessary(InventoryBE expected, InventoryBE found, boolean verifyItemComponents) {
        class_5455 lookupClient = this.worldClient.method_30349();
        class_5455 lookupExpected = expected.method_10997().method_30349();
        class_2586 expectedNew = class_2586.method_11005((class_2338)expected.method_11016(), (class_2680)expected.method_11010(), (class_2487)expected.method_38242((class_7225.class_7874)lookupExpected), (class_7225.class_7874)lookupClient);
        class_5455 lookupFound = found.method_10997().method_30349();
        class_2586 foundNew = class_2586.method_11005((class_2338)found.method_11016(), (class_2680)found.method_11010(), (class_2487)found.method_38242((class_7225.class_7874)lookupFound), (class_7225.class_7874)lookupClient);
        int size = ((class_1263)expected).method_5439();
        for (int i = size - 1; i >= 0; --i) {
            class_1799 expectedStack = ((class_1263)expectedNew).method_5438(i);
            class_1799 foundStack = ((class_1263)foundNew).method_5438(i);
            class_2073 class_20732 = ItemPredicateUtils.getPredicate(expectedStack);
            if (class_20732 instanceof class_2073) {
                class_2073 predicate = class_20732;
                expectedStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Item Predicate").method_27694(style -> style.method_10977(class_124.field_1068).method_10978(Boolean.valueOf(false))));
                foundStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, nbtComponent -> nbtComponent.method_57451(nbt -> nbt.method_10566("techutils:error_lines", (class_2520)ERROR_LINES_CODEC.encodeStart((DynamicOps)class_2509.field_11560, ItemPredicateUtils.getErrorLines(foundStack, predicate)).getOrThrow())));
                continue;
            }
            if (!verifyItemComponents || Objects.equals(expectedStack.method_57353(), foundStack.method_57353())) continue;
            foundStack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, nbtComponent -> nbtComponent.method_57451(nbt -> nbt.method_10566("techutils:error_lines", (class_2520)ERROR_LINES_CODEC.encodeStart((DynamicOps)class_2509.field_11560, List.of(class_2561.method_43470((String)"Item components don't match!").method_27694(style -> style.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(false))))).getOrThrow())));
        }
        return Pair.of((Object)expectedNew, (Object)foundNew);
    }

    @Inject(method={"addCountFor"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCountForWrongInventories(SchematicVerifier.MismatchType mismatchType, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> map, List<SchematicVerifier.BlockMismatch> list, CallbackInfo ci) {
        if (mismatchType != WRONG_INVENTORIES) {
            return;
        }
        for (Pair<InventoryBE, InventoryBE> pair : this.wrongInventories) {
            class_2680 leftState = ((class_2586)pair.getLeft()).method_11010();
            class_2680 rightState = ((class_2586)pair.getRight()).method_11010();
            SchematicVerifier.BlockMismatch blockMismatch = new SchematicVerifier.BlockMismatch(WRONG_INVENTORIES, leftState, rightState, 1);
            ((BlockMismatchExtension)blockMismatch).setInventories$techutils(pair);
            list.add(blockMismatch);
        }
        ci.cancel();
    }

    @Inject(method={"toggleMismatchEntrySelected"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/HashMultimap;remove(Ljava/lang/Object;Ljava/lang/Object;)Z")})
    private void tryRemoveSelectedInventoryMismatch(SchematicVerifier.BlockMismatch mismatch, CallbackInfo ci, @Local SchematicVerifier.MismatchType type) {
        if (type == WRONG_INVENTORIES) {
            this.selectedInventoryMismatches.remove(mismatch);
        }
    }

    @Inject(method={"toggleMismatchEntrySelected"}, at={@At(value="INVOKE", target="Lcom/google/common/collect/HashMultimap;put(Ljava/lang/Object;Ljava/lang/Object;)Z")})
    private void tryAddSelectedInventoryMismatch(SchematicVerifier.BlockMismatch mismatch, CallbackInfo ci, @Local SchematicVerifier.MismatchType type) {
        if (type == WRONG_INVENTORIES) {
            this.selectedInventoryMismatches.add(mismatch);
        }
    }

    @Inject(method={"removeSelectedEntriesOfType"}, at={@At(value="HEAD")})
    private void tryRemoveSelectedInventoryMismatches(SchematicVerifier.MismatchType type, CallbackInfo ci) {
        if (type == WRONG_INVENTORIES) {
            this.selectedInventoryMismatches.clear();
        }
    }

    @WrapOperation(method={"getMismatchOverviewCombined"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;addCountFor(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;Lcom/google/common/collect/ArrayListMultimap;Ljava/util/List;)V", ordinal=0)})
    private void updateClosestWrongInventoriesPositions(SchematicVerifier instance, SchematicVerifier.MismatchType type, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> positions, List<SchematicVerifier.BlockMismatch> list, Operation<Void> original) {
        original.call(new Object[]{instance, WRONG_INVENTORIES, this.wrongInventoriesPositions, list});
        original.call(new Object[]{instance, type, positions, list});
    }

    @Inject(method={"updateClosestPositions"}, at={@At(value="TAIL")})
    private void updateClosestWrongInventoriesPositions(class_2338 centerPos, int maxEntries, CallbackInfo ci) {
        this.addAndSortPositions(WRONG_INVENTORIES, this.wrongInventoriesPositions, this.wrongInventoriesPositionsClosest, maxEntries);
    }

    @WrapOperation(method={"combineClosestPositions"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;getMismatchRenderPositionFor(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;Ljava/util/List;)V", ordinal=0)})
    private void updateClosestWrongInventoriesPositions(SchematicVerifier instance, SchematicVerifier.MismatchType type, List<SchematicVerifier.MismatchRenderPos> tempList, Operation<Void> original) {
        original.call(new Object[]{instance, WRONG_INVENTORIES, tempList});
        original.call(new Object[]{instance, type, tempList});
    }

    @Inject(method={"getMapForMismatchType"}, at={@At(value="HEAD")}, cancellable=true)
    private void addWrongInventoriesMap(SchematicVerifier.MismatchType mismatchType, CallbackInfoReturnable<ArrayListMultimap<Pair<class_2680, class_2680>, class_2338>> cir) {
        if (mismatchType == WRONG_INVENTORIES) {
            cir.setReturnValue(this.wrongInventoriesPositions);
        }
    }

    @Inject(method={"getClosestMismatchedPositionsFor"}, at={@At(value="HEAD")}, cancellable=true)
    private void addWrongInventoriesMismatchedPositions(SchematicVerifier.MismatchType type, CallbackInfoReturnable<List<class_2338>> cir) {
        if (type == WRONG_INVENTORIES) {
            cir.setReturnValue(this.wrongInventoriesPositionsClosest);
        }
    }

    @ModifyExpressionValue(method={"ignoreStateMismatch(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$BlockMismatch;Z)V"}, at={@At(value="INVOKE", target="Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;getMapForMismatchType(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;)Lcom/google/common/collect/ArrayListMultimap;")})
    private ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> removeInventoryIfNecessary(ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> positions, @Local(argsOnly=true) SchematicVerifier.BlockMismatch mismatch) {
        if (positions == this.wrongInventoriesPositions) {
            this.wrongInventories.remove(((BlockMismatchExtension)mismatch).getInventories$techutils());
            this.selectedInventoryMismatches.remove(mismatch);
        }
        return positions;
    }

    @Inject(method={"clearData"}, at={@At(value="HEAD")})
    private void clearAdditionalData(CallbackInfo ci) {
        IdentityHashMap<class_2680, class_1799> itemsForStates = ItemUtilsAccessor.getItemsForStates();
        for (Pair pair : this.wrongInventoriesPositions.keySet()) {
            itemsForStates.remove(pair.getRight());
        }
        this.wrongInventories.clear();
        this.wrongInventoriesPositions.clear();
        this.selectedInventoryMismatches.clear();
        EntitiesDataStorage.getInstance().reset(false);
    }
}

