/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils.render.outline;

import dev.kikugie.techutils.mixin.containerscan.WorldRendererAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4618;
import net.minecraft.class_630;

public class OutlineRenderer {
    private static final class_1921 OUTLINE_LAYER = class_1921.method_23287((class_2960)class_2960.method_60654((String)"textures/misc/white.png"));
    private static final Map<class_2338, RenderEntry> entries = new Hashtable<class_2338, RenderEntry>();
    private static final Map<class_238, class_630.class_628> compiledShapes = new Hashtable<class_238, class_630.class_628>();
    public static boolean isRendering = false;

    public static void add(class_1922 world, int color, Predicate<class_243> renderCondition, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        ArrayList<class_238> boundingBoxes = new ArrayList<class_238>(state.method_26218(world, pos).method_1090());
        if (boundingBoxes.isEmpty()) {
            boundingBoxes.add(new class_238(pos));
        }
        ArrayList<class_630.class_628> cuboids = new ArrayList<class_630.class_628>();
        for (class_238 box : boundingBoxes) {
            cuboids.add(OutlineRenderer.compileAndCache(box));
        }
        entries.put(pos, new RenderEntry(cuboids, pos, color, renderCondition));
    }

    public static void render(WorldRenderContext context) {
        if (!entries.isEmpty()) {
            class_4587 matrices = context.matrixStack();
            class_243 camera = context.camera().method_19326();
            WorldRendererAccessor worldRenderer = (WorldRendererAccessor)context.worldRenderer();
            if (!isRendering) {
                worldRenderer.getEntityOutlinePostProcessor().method_1258(context.tickCounter().method_60637(false));
                class_310.method_1551().method_1522().method_1235(false);
            }
            matrices.method_22903();
            matrices.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
            OutlineRenderer.renderOutlines(matrices, camera, worldRenderer.getBufferBuilders().method_23003());
            matrices.method_22909();
        }
        isRendering = false;
    }

    private static void renderOutlines(class_4587 matrices, class_243 camera, class_4618 consumers) {
        for (RenderEntry entry : entries.values()) {
            if (!entry.renderCondition.test(camera)) continue;
            consumers.method_23286(entry.color >> 16 & 0xFF, entry.color >> 8 & 0xFF, entry.color & 0xFF, entry.color >> 24 & 0xFF);
            matrices.method_22903();
            matrices.method_46416((float)entry.pos.method_10263(), (float)entry.pos.method_10264(), (float)entry.pos.method_10260());
            for (class_630.class_628 cuboid : entry.model) {
                cuboid.method_32089(matrices.method_23760(), consumers.getBuffer(OUTLINE_LAYER), 0, 10, -1);
            }
            matrices.method_22909();
        }
    }

    private static class_630.class_628 compileAndCache(class_238 box) {
        if (compiledShapes.containsKey(box)) {
            return compiledShapes.get(box);
        }
        float sizeX = (float)(box.field_1320 - box.field_1323);
        float sizeY = (float)(box.field_1325 - box.field_1322);
        float sizeZ = (float)(box.field_1324 - box.field_1321);
        class_630.class_628 cuboid = new class_630.class_628(0, 0, (float)box.field_1323 * 16.0f, (float)box.field_1322 * 16.0f, (float)box.field_1321 * 16.0f, sizeX * 16.0f, sizeY * 16.0f, sizeZ * 16.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, Set.of(class_2350.values()));
        compiledShapes.put(box, cuboid);
        return cuboid;
    }

    private record RenderEntry(Collection<class_630.class_628> model, class_2338 pos, int color, Predicate<class_243> renderCondition) {
    }
}

