package dev.kikugie.techutils.feature.containerscan;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.malilib.util.Color4f;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

/**
 * Represents contents of an existing container and one according to a placement at the same position.
 */
public class LinkedStorageEntry {
	private static final Supplier<Color4f> MISSING_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING::getColor;
	private static final Supplier<Color4f> WRONG_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK::getColor;
	private static final Supplier<Color4f> MISMATCHED_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE::getColor;
	private static final Supplier<Color4f> EXTRA_COLOR = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA::getColor;
	public final class_2338 pos;
	@Nullable
	private class_1263 worldInventory;
	@Nullable
	private class_1263 placementInventory;

	public LinkedStorageEntry(class_2338 pos, @Nullable class_1263 worldInventory, @Nullable class_1263 placementInventory) {
		this.pos = pos;
		this.worldInventory = worldInventory;
		this.placementInventory = placementInventory;
	}

	public Optional<class_1263> getWorldInventory() {
		return Optional.ofNullable(this.worldInventory);
	}

	public void setWorldInventory(@Nullable class_1263 inventory) {
		this.worldInventory = inventory;
	}

	public Optional<class_1263> getPlacementInventory() {
		return Optional.ofNullable(this.placementInventory);
	}

	public void setPlacementInventory(@Nullable class_1263 inventory) {
		this.placementInventory = inventory;
	}

	public Optional<Color4f> validate() {
		if (this.worldInventory == null || this.placementInventory == null)
			return Optional.empty();

		int type = 0;
		for (int i = 0; i < this.worldInventory.method_5439(); i++) {
			class_1799 world = this.worldInventory.method_5438(i);
			class_1799 schem = this.placementInventory.method_5438(i);

			if (world.method_7960() && !schem.method_7960())
				type = Math.max(type, 1);
			else if (!world.method_7960() && schem.method_7960())
				type = Math.max(type, 2);
			else if (!world.method_7909().equals(schem.method_7909()))
				type = Math.max(type, 4);
			else if (world.method_7947() != schem.method_7947())
				type = Math.max(type, 3);
		}

		return switch (type) {
			case 1 -> Optional.of(MISSING_COLOR.get());
			case 2 -> Optional.of(EXTRA_COLOR.get());
			case 3 -> Optional.of(MISMATCHED_COLOR.get());
			case 4 -> Optional.of(WRONG_COLOR.get());
			default -> Optional.empty();
		};
	}
}
