package dev.kikugie.techutils.feature.containerscan.verifier;

import com.chocohead.mm.api.ClassTinkerers;
import com.mojang.serialization.Codec;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.MismatchType;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_8824;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public interface SchematicVerifierExtension {
	String ERROR_LINES_ID = "techutils:error_lines";
	Codec<List<class_2561>> ERROR_LINES_CODEC = class_8824.field_46597.listOf();
	MismatchType WRONG_INVENTORIES = ClassTinkerers.getEnum(MismatchType.class, "WRONG_INVENTORIES");

	/**
	 * One must imagine Sisyphus happy
	 */
	static @NotNull class_1799 addErrorLines(class_1799 stack, List<class_2561> lines) {
		var data = stack.method_57824(class_9334.field_49628);
		if (data == null || !data.method_57463().method_10545(ERROR_LINES_ID)) {
			return stack;
		}

		stack = stack.method_7972();
		var nbt = stack.method_57824(class_9334.field_49628).method_57461();
		var errorLines = ERROR_LINES_CODEC.parse(class_2509.field_11560, nbt.method_10554(ERROR_LINES_ID, class_2520.field_33260)).getOrThrow();
		nbt.method_10551(ERROR_LINES_ID);
		if (nbt.method_33133()) {
			stack.method_57381(class_9334.field_49628);
			for (class_2561 line : lines) {
				if (line.method_10851() instanceof class_2588 ttc
					&& ttc.method_11022().equals("item.components")
				) {
					Object[] args = ttc.method_11023();
					args[0] = ((int) args[0]) - 1;
				}
			}
		} else {
			stack.method_57379(class_9334.field_49628, class_9279.method_57456(nbt));
		}
		lines.addAll(errorLines);

		return stack;
	}

	List<SchematicVerifier.BlockMismatch> getSelectedInventoryMismatches$techutils();

	int getWrongInventoriesCount$techutils();
}
