package dev.kikugie.techutils.mixin.containerscan;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.feature.containerscan.verifier.InventoryOverlay;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_465.class)
public class HandledScreenMixin {

	@Shadow
	protected int x;

	@Shadow
	protected int y;

	@Shadow @Nullable protected class_1735 focusedSlot;

	@ModifyExpressionValue(method = "drawSlot", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;getStack()Lnet/minecraft/item/ItemStack;", ordinal = 0))
	private class_1799 setTransparency(class_1799 stack, @Local(argsOnly = true) class_332 context, @Local(argsOnly = true) class_1735 slot) {
		return InventoryOverlay.drawStack(context, slot, stack);
	}

	@Inject(method = "drawSlot", at = @At("RETURN"))
	private void restoreTransparency(class_332 context, class_1735 slot, CallbackInfo ci) {
		InventoryOverlay.drawTransparencyBuffer(context, this.x, this.y);
	}

	@ModifyExpressionValue(method = "drawMouseoverTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;hasStack()Z"))
	private boolean tryDrawTooltipOfSchematicItem(boolean hasStack, @Share("prevItem") LocalRef<class_1799> prevItemRef) {
		var prevItem = focusedSlot.method_7677();
		if ((!hasStack || LitematicConfigs.FORCE_SCHEMATIC_ITEM_OVERLAY.getBooleanValue())
			&& InventoryOverlay.setSlotToSchematicItem(focusedSlot)
		) {
			hasStack = focusedSlot.method_7681();
			if (hasStack) {
				prevItemRef.set(prevItem);
			} else {
				focusedSlot.method_53512(prevItem);
			}
		}
		return hasStack;
	}

	@Inject(method = "drawMouseoverTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/screen/slot/Slot;getStack()Lnet/minecraft/item/ItemStack;", shift = At.Shift.AFTER))
	private void trySetFocusedSlotBackToPrev(CallbackInfo ci, @Share("prevItem") LocalRef<class_1799> prevItemRef) {
		var prevItem = prevItemRef.get();
		if (prevItem != null) {
			focusedSlot.method_53512(prevItem);
		}
	}
}
