package dev.kikugie.techutils.mixin.mod.litematica;

import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import fi.dy.masa.litematica.gui.GuiSchematicLoad;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;

@Mixin(targets = "fi.dy.masa.litematica.gui.GuiSchematicLoad$ButtonListener", remap = false)
public class GuiSchematicLoad$ButtonListenerMixin {
	@Shadow @Final private GuiSchematicLoad gui;

	@Inject(method = "actionPerformedWithButton", at = @At(value = "FIELD", target = "Lfi/dy/masa/litematica/gui/GuiSchematicLoad$ButtonListener$Type;LOAD_SCHEMATIC:Lfi/dy/masa/litematica/gui/GuiSchematicLoad$ButtonListener$Type;"))
	private void replaceItemPredicatesWithPlaceholders(CallbackInfo ci, @Local LitematicaSchematic schematic) {
		if (!LitematicConfigs.REPLACE_ITEM_PREDICATES_WITH_PLACEHOLDERS.getBooleanValue()) {
			return;
		}

		var accessedSchematic = ((LitematicaSchematicAccessor) schematic);
		var containers = accessedSchematic.getBlockContainers();
		var blockEntities = accessedSchematic.getTileEntities();
		Map<String, Map<class_2338, class_2487>> processedBlockEntities = new HashMap<>();
		var lookup = gui.mc.field_1687.method_30349();

		for (var regionEntry : blockEntities.entrySet()) {
			String region = regionEntry.getKey();
			var regionBlockEntities = regionEntry.getValue();
			var regionContainer = containers.get(region);
			Map<class_2338, class_2487> processedRegionBlockEntities = new HashMap<>();

			for (var entry : regionBlockEntities.entrySet()) {
				class_2338 blockEntityPos = entry.getKey();
				var blockEntityNbt = entry.getValue();
				var blockEntity = class_2586.method_11005(
					blockEntityPos,
					regionContainer.get(blockEntityPos.method_10263(), blockEntityPos.method_10264(), blockEntityPos.method_10260()),
					blockEntityNbt,
					lookup
				);

				if (blockEntity instanceof class_1263 inventory) {
					for (int i = 0; i < inventory.method_5439(); i++) {
						var stack = inventory.method_5438(i);
						if (ItemPredicateUtils.getPlaceholder(stack) instanceof class_1799 placeholder) {
							inventory.method_5447(i, placeholder);
						}
					}
					processedRegionBlockEntities.put(blockEntityPos, blockEntity.method_38242(lookup));
				} else {
					processedRegionBlockEntities.put(blockEntityPos, blockEntityNbt);
				}
			}

			processedBlockEntities.put(region, processedRegionBlockEntities);
		}

		accessedSchematic.setTileEntities(processedBlockEntities);
	}
}
