/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.techutils;

import com.mojang.brigadier.CommandDispatcher;
import dev.kikugie.techutils.command.IsorenderSelectionCommand;
import dev.kikugie.techutils.command.ItemPredicateCommand;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.config.malilib.InitHandler;
import dev.kikugie.techutils.feature.containerscan.handlers.InteractionHandler;
import dev.kikugie.techutils.feature.containerscan.verifier.SchematicVerifierExtension;
import dev.kikugie.techutils.feature.worldedit.WorldEditSync;
import dev.kikugie.techutils.util.ContainerUtils;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import dev.kikugie.techutils.util.ResponseMuffler;
import fi.dy.masa.litematica.gui.GuiSchematicVerifier;
import fi.dy.masa.malilib.event.InitializationHandler;
import fi.dy.masa.malilib.interfaces.IInitializationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_7417;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TechUtilsMod
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"techutils");
    public static final List<Consumer<class_310>> QUEUED_END_CLIENT_TICK_TASKS = new ArrayList<Consumer<class_310>>();

    public void onInitializeClient() {
        InitializationHandler.getInstance().registerInitializationHandler((IInitializationHandler)new InitHandler());
        this.registerCommands();
        this.registerWorldEditSync();
        ClientTickEvents.START_WORLD_TICK.register(world -> InteractionHandler.tick(world.method_8510()));
        ItemTooltipCallback.EVENT.register((stack, tooltipContext, tooltipType, lines) -> {
            if (ItemPredicateUtils.isPredicate(stack)) {
                lines.removeIf(text -> {
                    class_2588 ttc;
                    class_7417 patt0$temp = text.method_10851();
                    return patt0$temp instanceof class_2588 && (ttc = (class_2588)patt0$temp).method_11022().contains("op_warning");
                });
                lines.addAll(ItemPredicateUtils.getPrettyPredicate(stack));
                return;
            }
            class_310 client = class_310.method_1551();
            if (client.field_1755 instanceof GuiSchematicVerifier) {
                stack = SchematicVerifierExtension.addErrorLines(stack, lines);
            }
            if (LitematicConfigs.VERIFY_ITEM_COMPONENTS.getBooleanValue()) {
                lines.addAll(ContainerUtils.getFormattedComponents(stack));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (Consumer<class_310> task : QUEUED_END_CLIENT_TICK_TASKS) {
                task.accept(client);
            }
            QUEUED_END_CLIENT_TICK_TASKS.clear();
        });
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            IsorenderSelectionCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher, registryAccess);
            ItemPredicateCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher, registryAccess);
        });
    }

    private void registerWorldEditSync() {
        ClientTickEvents.START_WORLD_TICK.register(tick -> WorldEditSync.getInstance().ifPresent(WorldEditSync::onTick));
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> !ResponseMuffler.test(message.getString()));
    }
}

