package dev.kikugie.techutils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.kikugie.techutils.TechUtilsMod;
import dev.kikugie.techutils.feature.containerscan.verifier.ItemPredicateEntryScreen;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import net.minecraft.class_746;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class ItemPredicateCommand {
	private static final SimpleCommandExceptionType WRONG_MAIN_HAND_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.itempredicate.placeholder.wrong_main_hand"));
	private static final SimpleCommandExceptionType NO_PLACEHOLDER_FOUND_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.itempredicate.placeholder.get.not_found"));
	private static final SimpleCommandExceptionType NOT_IN_CREATIVE_MODE_EXCEPTION = new SimpleCommandExceptionType(class_2561.method_43471("commands.itempredicate.not_in_creative_mode"));

	public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 ignoredAccess) {
		dispatcher.register(literal("itempredicate")
			.then(literal("give")
				.executes(context -> {
					var player = context.getSource().getPlayer();

					enforceCreativeMode(player);

					var offHandStack = player.method_6079().method_7972();
					TechUtilsMod.QUEUED_END_CLIENT_TICK_TASKS.add(client -> client.method_1507(new ItemPredicateEntryScreen(player, offHandStack)));
					return 1;
				})
			)
			.then(literal("edit")
				.executes(context -> {
					var source = context.getSource();
					var player = source.getPlayer();

					enforceCreativeMode(player);

					var mainHandStack = player.method_6047().method_7972();

					if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
						throw WRONG_MAIN_HAND_EXCEPTION.create();
					}

					var rawPredicate = ItemPredicateUtils.getRawPredicate(mainHandStack);
					var placeholder = ItemPredicateUtils.getPlaceholder(mainHandStack);

					TechUtilsMod.QUEUED_END_CLIENT_TICK_TASKS.add(client -> client.method_1507(new ItemPredicateEntryScreen(context.getSource().getPlayer(), rawPredicate, placeholder)));
					return 1;
				})
			)
			.then(literal("placeholder")
				.then(literal("set")
					.executes(context -> {
						var source = context.getSource();
						var player = source.getPlayer();

						enforceCreativeMode(player);

						var mainHandStack = player.method_6047().method_7972();
						var offHandStack = player.method_6079().method_7972();

						if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
							throw WRONG_MAIN_HAND_EXCEPTION.create();
						}

						ItemPredicateUtils.setPlaceholder(mainHandStack, offHandStack);
						int selectedSlot = player.method_31548().method_67532();
						player.method_31548().method_5447(selectedSlot, mainHandStack);
						source.getClient().field_1761.method_2909(mainHandStack, 36 + selectedSlot);
						player.field_7498.method_7623();

						source.sendFeedback(class_2561.method_43471("commands.itempredicate.placeholder.set.success"));

						return 1;
					})
				)
				.then(literal("get")
					.executes(context -> {
						var source = context.getSource();
						var player = source.getPlayer();

						enforceCreativeMode(player);

						var mainHandStack = player.method_6047().method_7972();

						if (!ItemPredicateUtils.isPredicate(mainHandStack)) {
							throw WRONG_MAIN_HAND_EXCEPTION.create();
						}

						if (!(ItemPredicateUtils.getPlaceholder(mainHandStack) instanceof class_1799 placeholder)) {
							throw NO_PLACEHOLDER_FOUND_EXCEPTION.create();
						}

						player.method_31548().method_5447(class_1661.field_30639, placeholder);
						source.getClient().field_1761.method_2909(placeholder, 45);
						player.field_7498.method_7623();

						source.sendFeedback(class_2561.method_43471("commands.itempredicate.placeholder.get.success"));

						return 1;
					})
				)
			)
		);
	}

	private static void enforceCreativeMode(class_746 player) throws CommandSyntaxException {
		if (!player.method_68878())
			throw NOT_IN_CREATIVE_MODE_EXCEPTION.create();
	}
}
