package dev.kikugie.techutils.mixin.compactscoreboard;

import dev.kikugie.techutils.config.MiscConfigs;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_329;
import net.minecraft.class_5250;
import net.minecraft.class_9023;

@Mixin(class_329.class)
public class InGameHudMixin {
	@Unique
	private static final NumberFormat FORMATTER = NumberFormat.getCompactNumberInstance(Locale.US, NumberFormat.Style.SHORT);

	static {
		FORMATTER.setMaximumFractionDigits(1);
	}

	@SuppressWarnings("unchecked")
	@ModifyArg(method = "renderScoreboardSidebar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/scoreboard/ScoreboardObjective;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/scoreboard/ScoreboardObjective;getNumberFormatOr(Lnet/minecraft/scoreboard/number/NumberFormat;)Lnet/minecraft/scoreboard/number/NumberFormat;"))
	private <T extends net.minecraft.class_9022> T replaceWithCompactFormat(T format) {
		if (!MiscConfigs.COMPACT_SCOREBOARD.getBooleanValue())
			return format;

		return (T) new net.minecraft.class_9022() {
			@Override
			public class_5250 method_55457(int number) {
				return class_2561.method_43470(FORMATTER.format(number)).method_27692(class_124.field_1061);
			}

			@Override
			public class_9023<T> method_55456() {
				return null;
			}
		};
	}
}
