package dev.kikugie.techutils.mixin.containerscan;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import dev.kikugie.techutils.feature.containerscan.verifier.InventoryOverlay;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_465;
import net.minecraft.class_8881;
import net.minecraft.class_8898;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8898.class)
public abstract class CrafterScreenMixin extends class_465<class_8881> {
	public CrafterScreenMixin(class_8881 handler, class_1661 inventory, class_2561 title) {
		super(handler, inventory, title);
	}

	/**
	 * This method complements {@link HandledScreenMixin#tryDrawTooltipOfSchematicItem(boolean, LocalRef)}
	 * because without it the "Click to disable slot" tooltip will clash with the forced schematic item tooltip.
	 */
	@Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/CrafterScreen;drawMouseoverTooltip(Lnet/minecraft/client/gui/DrawContext;II)V"))
	private void tryDrawTooltipOfMissingItem(CallbackInfo ci, @Share("didSetItem") LocalBooleanRef didSetItem) {
		if (field_2787 != null && field_2787.method_7677().method_7960()
			&& InventoryOverlay.setSlotToSchematicItem(field_2787)
		) {
			didSetItem.set(true);
		}
	}

	@Inject(method = "render", at = @At("TAIL"))
	private void trySetFocusedSlotBackToEmpty(CallbackInfo ci, @Share("didSetItem") LocalBooleanRef didSetItem) {
		if (didSetItem.get()) {
			field_2787.method_53512(class_1799.field_8037);
		}
	}
}
