package dev.kikugie.techutils.mixin.mod.litematica;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.kikugie.techutils.config.LitematicConfigs;
import dev.kikugie.techutils.feature.containerscan.verifier.BlockMismatchExtension;
import dev.kikugie.techutils.feature.containerscan.verifier.SchematicVerifierExtension;
import dev.kikugie.techutils.util.ItemPredicateUtils;
import fi.dy.masa.litematica.data.EntitiesDataStorage;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.BlockMismatch;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.MismatchRenderPos;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.MismatchType;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.WorldUtils;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

import static fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.BlockMismatch;
import static fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.MismatchRenderPos;
import static fi.dy.masa.litematica.schematic.verifier.SchematicVerifier.MismatchType;

@Mixin(value = SchematicVerifier.class, remap = false)
public abstract class SchematicVerifierMixin<InventoryBE extends class_2586 & class_1263> extends TaskBase implements SchematicVerifierExtension {
	@Shadow @Final private static class_2338.class_2339 MUTABLE_POS;
	@Shadow private SchematicPlacement schematicPlacement;
	@Shadow private class_638 worldClient;

	@Shadow protected abstract void addAndSortPositions(MismatchType type, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> sourceMap, List<class_2338> listOut, int maxEntries);

	@Unique
	private final Set<Pair<InventoryBE, InventoryBE>> wrongInventories = new ReferenceOpenHashSet<>();
	@Unique
	private final ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> wrongInventoriesPositions = ArrayListMultimap.create();
	@Unique
	private final List<class_2338> wrongInventoriesPositionsClosest = new ArrayList<>();
	@Unique
	private final List<BlockMismatch> selectedInventoryMismatches = new ArrayList<>();

	@Override
	public List<BlockMismatch> getSelectedInventoryMismatches$techutils() {
		return Collections.unmodifiableList(selectedInventoryMismatches);
	}

	@Override
	public int getWrongInventoriesCount$techutils() {
		return wrongInventories.size();
	}

	@ModifyExpressionValue(method = "verifyChunks", at = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/world/ChunkManagerSchematic;isChunkLoaded(II)Z", remap = true))
	private boolean ensureInventoriesAreLoaded(boolean isLoaded, @Local class_1923 pos) {
		return isLoaded && canProcessChunk(pos);
	}

	@Redirect(
		method = "verifyChunks",
		slice = @Slice(
			from = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/world/ChunkManagerSchematic;isChunkLoaded(II)Z")
		),
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/world/ClientWorld;getChunk(II)Lnet/minecraft/world/chunk/WorldChunk;",
			ordinal = 0,
			remap = true
		)
	)
	private class_2818 pickBestWorld(class_638 clientWorld, int x, int z) {
		return (WorldUtils.getBestWorld(mc) instanceof class_1937 world ? world : clientWorld).method_8497(x, z);
	}

	/**
	 * Basically a clone of {@link fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic#canProcessChunk}
	 */
	@Unique
	private boolean canProcessChunk(class_1923 pos)
	{
		// Request entity data from Servux, if the ClientWorld matches, and treat it as not yet loaded
		EntitiesDataStorage eds = EntitiesDataStorage.getInstance();
		if ((eds.hasServuxServer() || eds.getIfReceivedBackupPackets())
			&& Objects.equals(eds.getWorld(), this.worldClient)
			&& !eds.hasCompletedChunk(pos))
		{
			if (eds.hasPendingChunk(pos))
				return false;

			ImmutableMap<String, IntBoundingBox> volumes = schematicPlacement.getBoxesWithinChunk(pos.field_9181, pos.field_9180);
			int minY = 319;         // Invert Values
			int maxY = -64;

			for (Map.Entry<String, IntBoundingBox> volumeEntry : volumes.entrySet())
			{
				IntBoundingBox bb = volumeEntry.getValue();

				minY = Math.min(bb.minY, minY);
				maxY = Math.max(bb.maxY, maxY);
			}

			if (eds.hasServuxServer())
			{
				eds.requestServuxBulkEntityData(pos, minY, maxY);
			}
			else if (eds.getIfReceivedBackupPackets())
			{
				eds.requestBackupBulkEntityData(pos, minY, maxY);
			}

			return false;
		}

		return this.areSurroundingChunksLoaded(pos, this.worldClient, 0);
	}

	@Inject(method = "verifyChunk", at = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;checkBlockStates(IIILnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V", remap = true))
	private void checkInventories(class_2791 chunkClient, class_2791 chunkSchematic, IntBoundingBox box, CallbackInfoReturnable<Boolean> cir) {
		var expectedBE = chunkSchematic.method_8321(MUTABLE_POS);
		var foundBE = chunkClient.method_8321(MUTABLE_POS);
		if (!(expectedBE instanceof class_1263 expected && foundBE instanceof class_1263 found)
			|| expectedBE.method_11017() != foundBE.method_11017()) {
			return;
		}

		int size = expected.method_5439();
		if (size != found.method_5439()) {
			return;
		}

		var itemsForStates = ItemUtilsAccessor.getItemsForStates();
		boolean verifyItemComponents = LitematicConfigs.VERIFY_ITEM_COMPONENTS.getBooleanValue();
		for (int i = size - 1; i >= 0; i--) {
			var expectedStack = expected.method_5438(i);
			var foundStack = found.method_5438(i);

			Boolean predFailed = null;
			if (ItemPredicateUtils.getPredicate(expectedStack) instanceof class_2073 predicate) {
				predFailed = !predicate.method_8970(foundStack);
			}

			if (predFailed != null
				? predFailed
				: expectedStack.method_7909() != foundStack.method_7909()
					|| expectedStack.method_7947() != foundStack.method_7947()
					|| verifyItemComponents
					&& !Objects.equals(expectedStack.method_57353(), foundStack.method_57353())
			) {
				var pos = MUTABLE_POS.method_10062();
				//noinspection unchecked
				var pair = populateTooltipsIfNecessary((InventoryBE) expected, (InventoryBE) found, verifyItemComponents);
				wrongInventories.add(pair);
				warCrime(pair.getLeft(), pair.getRight(), itemsForStates, pos);
				break;
			}
		}
	}

	/**
	 * I ask for your forgiveness, future viewer (this makes differentiating inventories with the same block state possible)
	 */
	@Unique
	private void warCrime(InventoryBE expected, InventoryBE found, IdentityHashMap<class_2680, class_1799> itemsForStates, class_2338 pos) {
		class_2680 foundState = found.method_11010();
		HashMap<class_2769<?>, Comparable<?>> propertyMap = new HashMap<>(foundState.method_11656());

		propertyMap.put(class_2746.method_11825("war_crime"), true);
		class_2680 newState = new class_2680(foundState.method_26204(), new Reference2ObjectArrayMap<>(propertyMap), null);

		itemsForStates.put(newState, ItemUtils.getItemForBlock(worldClient, pos, foundState, true));
		wrongInventoriesPositions.put(Pair.of(expected.method_11010(), newState), pos);
		found.method_31664(newState);
	}

	@SuppressWarnings("unchecked")
	@Unique
	private Pair<InventoryBE, InventoryBE> populateTooltipsIfNecessary(InventoryBE expected, InventoryBE found, boolean verifyItemComponents) {
		class_5455 lookupClient = worldClient.method_30349();
		class_5455 lookupExpected = expected.method_10997().method_30349();
		final var expectedNew = (InventoryBE) class_2586.method_11005(expected.method_11016(), expected.method_11010(), expected.method_38242(lookupExpected), lookupClient);
		class_5455 lookupFound = found.method_10997().method_30349();
		final var foundNew = (InventoryBE) class_2586.method_11005(found.method_11016(), found.method_11010(), found.method_38242(lookupFound), lookupClient);
		int size = expected.method_5439();
		for (int i = size - 1; i >= 0; i--) {
			var expectedStack = expectedNew.method_5438(i);
			var foundStack = foundNew.method_5438(i);

			if (ItemPredicateUtils.getPredicate(expectedStack) instanceof class_2073 predicate) {
				expectedStack.method_57379(class_9334.field_49631, class_2561.method_43470("Item Predicate")
					.method_27694(style -> style.method_10977(class_124.field_1068).method_10978(false))
				);
				foundStack.method_57368(class_9334.field_49628, class_9279.field_49302, nbtComponent ->
					nbtComponent.method_57451(nbt ->
						nbt.method_10566(ERROR_LINES_ID, ERROR_LINES_CODEC
							.encodeStart(class_2509.field_11560, ItemPredicateUtils.getErrorLines(foundStack, predicate)).getOrThrow())
					)
				);
				continue;
			}

			if (verifyItemComponents && !Objects.equals(expectedStack.method_57353(), foundStack.method_57353())) {
				foundStack.method_57368(class_9334.field_49628, class_9279.field_49302, nbtComponent ->
					nbtComponent.method_57451(nbt ->
						nbt.method_10566(ERROR_LINES_ID, ERROR_LINES_CODEC
							.encodeStart(class_2509.field_11560, List.of(class_2561.method_43470("Item components don't match!")
								.method_27694(style -> style.method_10977(class_124.field_1061).method_10978(false)))).getOrThrow())
					)
				);
			}
		}
		return Pair.of(expectedNew, foundNew);
	}

	@Inject(method = "addCountFor", at = @At("HEAD"), cancellable = true)
	private void addCountForWrongInventories(MismatchType mismatchType, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> map, List<BlockMismatch> list, CallbackInfo ci) {
		if (mismatchType != WRONG_INVENTORIES) {
			return;
		}

		for (var pair : wrongInventories) {
			class_2680 leftState = pair.getLeft().method_11010();
			class_2680 rightState = pair.getRight().method_11010();
			BlockMismatch blockMismatch = new BlockMismatch(WRONG_INVENTORIES, leftState, rightState, 1);
			//noinspection unchecked
			((BlockMismatchExtension<InventoryBE>) blockMismatch).setInventories$techutils(pair);
			list.add(blockMismatch);
		}
		ci.cancel();
	}

	@Inject(method = "toggleMismatchEntrySelected", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/HashMultimap;remove(Ljava/lang/Object;Ljava/lang/Object;)Z"))
	private void tryRemoveSelectedInventoryMismatch(BlockMismatch mismatch, CallbackInfo ci, @Local MismatchType type) {
		if (type == WRONG_INVENTORIES) {
			selectedInventoryMismatches.remove(mismatch);
		}
	}

	@Inject(method = "toggleMismatchEntrySelected", at = @At(value = "INVOKE", target = "Lcom/google/common/collect/HashMultimap;put(Ljava/lang/Object;Ljava/lang/Object;)Z"))
	private void tryAddSelectedInventoryMismatch(BlockMismatch mismatch, CallbackInfo ci, @Local MismatchType type) {
		if (type == WRONG_INVENTORIES) {
			selectedInventoryMismatches.add(mismatch);
		}
	}

	@Inject(method = "removeSelectedEntriesOfType", at = @At("HEAD"))
	private void tryRemoveSelectedInventoryMismatches(MismatchType type, CallbackInfo ci) {
		if (type == WRONG_INVENTORIES) {
			selectedInventoryMismatches.clear();
		}
	}

	@WrapOperation(method = "getMismatchOverviewCombined", at = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;addCountFor(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;Lcom/google/common/collect/ArrayListMultimap;Ljava/util/List;)V", ordinal = 0))
	private void updateClosestWrongInventoriesPositions(SchematicVerifier instance, MismatchType type, ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> positions, List<BlockMismatch> list, Operation<Void> original) {
		original.call(instance, WRONG_INVENTORIES, wrongInventoriesPositions, list);
		original.call(instance, type, positions, list);
	}

	@Inject(method = "updateClosestPositions", at = @At("TAIL"))
	private void updateClosestWrongInventoriesPositions(class_2338 centerPos, int maxEntries, CallbackInfo ci) {
		addAndSortPositions(WRONG_INVENTORIES, wrongInventoriesPositions, wrongInventoriesPositionsClosest, maxEntries);
	}

	@WrapOperation(method = "combineClosestPositions", at = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;getMismatchRenderPositionFor(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;Ljava/util/List;)V", ordinal = 0))
	private void updateClosestWrongInventoriesPositions(SchematicVerifier instance, MismatchType type, List<MismatchRenderPos> tempList, Operation<Void> original) {
		original.call(instance, WRONG_INVENTORIES, tempList);
		original.call(instance, type, tempList);
	}

	@Inject(method = "getMapForMismatchType", at = @At("HEAD"), cancellable = true)
	private void addWrongInventoriesMap(MismatchType mismatchType, CallbackInfoReturnable<ArrayListMultimap<Pair<class_2680, class_2680>, class_2338>> cir) {
		if (mismatchType == WRONG_INVENTORIES) {
			cir.setReturnValue(wrongInventoriesPositions);
		}
	}

	@Inject(method = "getClosestMismatchedPositionsFor", at = @At("HEAD"), cancellable = true)
	private void addWrongInventoriesMismatchedPositions(MismatchType type, CallbackInfoReturnable<List<class_2338>> cir) {
		if (type == WRONG_INVENTORIES) {
			cir.setReturnValue(wrongInventoriesPositionsClosest);
		}
	}

	@ModifyExpressionValue(method = "ignoreStateMismatch(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$BlockMismatch;Z)V", at = @At(value = "INVOKE", target = "Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier;getMapForMismatchType(Lfi/dy/masa/litematica/schematic/verifier/SchematicVerifier$MismatchType;)Lcom/google/common/collect/ArrayListMultimap;"))
	private ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> removeInventoryIfNecessary(ArrayListMultimap<Pair<class_2680, class_2680>, class_2338> positions, @Local(argsOnly = true) BlockMismatch mismatch) {
		if (positions == wrongInventoriesPositions) {
			wrongInventories.remove(((BlockMismatchExtension<?>) mismatch).getInventories$techutils());
			selectedInventoryMismatches.remove(mismatch);
		}
		return positions;
	}

	@Inject(method = "clearData", at = @At("HEAD"))
	private void clearAdditionalData(CallbackInfo ci) {
		var itemsForStates = ItemUtilsAccessor.getItemsForStates();
		for (Pair<class_2680, class_2680> pair : wrongInventoriesPositions.keySet()) {
			itemsForStates.remove(pair.getRight());
		}
		wrongInventories.clear();
		wrongInventoriesPositions.clear();
		selectedInventoryMismatches.clear();
		EntitiesDataStorage.getInstance().reset(false);
	}
}
